/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.api.impl.service.content.factory.LabelFactory;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.SpaceLabelService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;

public class SpaceLabelServiceImpl
implements SpaceLabelService {
    private final SpaceManagerInternal spaceManager;
    private final PaginationService paginationService;
    private final PermissionManager permissionManager;
    private final LabelManagerInternal labelManager;
    private final LabelFactory labelFactory;
    private final SpaceService.Validator spaceValidator;
    private final LabelPermissionEnforcer labelPermissionEnforcer;
    private final ApplicationConfiguration applicationConfig;
    private static final int MAX_SPACE_LABELS_TO_PROCESS_DEFAULT = 10000;
    private static final String MAX_SPACE_LABELS_TO_PROCESS_KEY = "confluence.rest.spacelabels.max.to.process";
    private static final int MAX_SPACE_RELATED_LABELS_TO_PROCESS_DEFAULT = 10000;
    private static final String MAX_SPACE_RELATED_LABELS_TO_PROCESS_KEY = "confluence.rest.spacelabels.related.max.to.process";
    private static final int MAX_SPACE_RECENT_LABELS_TO_PROCESS_DEFAULT = 10000;
    private static final String MAX_SPACE_RECENT_LABELS_TO_PROCESS_KEY = "confluence.rest.spacelabels.recent.max.to.process";
    private static final int MAX_SPACE_POPULAR_LABELS_TO_PROCESS_DEFAULT = 10000;
    private static final String MAX_SPACE_POPULAR_LABELS_TO_PROCESS_KEY = "confluence.rest.spacelabels.popular.max.to.process";

    public SpaceLabelServiceImpl(SpaceManagerInternal spaceManager, PaginationService paginationService, PermissionManager permissionManager, LabelManagerInternal labelManager, LabelFactory labelFactory, SpaceService.Validator spaceValidator, LabelPermissionEnforcer labelPermissionEnforcer, ApplicationConfiguration applicationConfig) {
        this.spaceManager = spaceManager;
        this.paginationService = paginationService;
        this.permissionManager = permissionManager;
        this.labelManager = labelManager;
        this.labelFactory = labelFactory;
        this.spaceValidator = spaceValidator;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
        this.applicationConfig = applicationConfig;
    }

    private int getMaxLabelsToProcess(String systemPropertyKey, int defaultValue) {
        return (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{Integer.getInteger(systemPropertyKey), Optional.ofNullable((String)this.applicationConfig.getProperty((Object)systemPropertyKey)).map(value -> {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).orElse(null), defaultValue});
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findAllContentLabelsPaginated(String spaceKey, PageRequest pageRequest) {
        this.spaceValidator.validateGet(spaceKey).throwIfNotSuccessful();
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getLabelsInSpace(spaceKey, input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, result.getResults(), result.hasMore(), MAX_SPACE_LABELS_TO_PROCESS_KEY, 10000);
        }, this.labelEntityToModelMapper());
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findPopularContentLabelsPaginated(String spaceKey, PageRequest pageRequest) {
        this.spaceValidator.validateGet(spaceKey).throwIfNotSuccessful();
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getMostPopularLabelsInSpace(spaceKey, input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, result.getResults().stream().map(LabelSearchResult::getLabel).toList(), result.hasMore(), MAX_SPACE_POPULAR_LABELS_TO_PROCESS_KEY, 10000);
        }, this.labelEntityToModelMapper());
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findRecentContentLabelsPaginated(String spaceKey, PageRequest pageRequest) {
        this.spaceValidator.validateGet(spaceKey).throwIfNotSuccessful();
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getRecentlyUsedLabelsInSpace(spaceKey, input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, result.getResults(), result.hasMore(), MAX_SPACE_RECENT_LABELS_TO_PROCESS_KEY, 10000);
        }, this.labelEntityToModelMapper());
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findRelatedContentLabelsPaginated(String spaceKey, String labelName, PageRequest pageRequest) {
        this.validator().validateFindRelatedContentLabelsPaginated(labelName, spaceKey).throwIfNotSuccessful("Cannot get labels");
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.labels());
        Label internalLabel = this.labelManager.getLabel(labelName);
        if (!this.labelPermissionEnforcer.userCanViewLabel(internalLabel)) {
            return PageResponseImpl.empty((boolean)false, (PageRequest)pageRequest);
        }
        return this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getRelatedLabelsInSpace(internalLabel, spaceKey, input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, result.getResults(), result.hasMore(), MAX_SPACE_RELATED_LABELS_TO_PROCESS_KEY, 10000);
        }, this.labelEntityToModelMapper());
    }

    private Function<Iterable<Label>, Iterable<com.atlassian.confluence.api.model.content.Label>> labelEntityToModelMapper() {
        return labels -> this.labelFactory.buildFrom((Iterable)labels, null);
    }

    private PageResponse<Label> fetchFilteredLabelsPageResponse(PageRequest pageRequest, LimitedRequest input, List<Label> labelList, boolean hasMore, String maxLabelsToProcessKey, int maxLabelsToProcessDefault) {
        List authorizedLabels = this.labelPermissionEnforcer.filterAuthorizedLabels(labelList);
        return PageResponseImpl.builder().addAll((Iterable)authorizedLabels).hasMore(input.getStart() + input.getLimit() < this.getMaxLabelsToProcess(maxLabelsToProcessKey, maxLabelsToProcessDefault) && hasMore).pageRequest(pageRequest).build();
    }

    public SpaceLabelService.Validator validator() {
        return new ValidatorImpl();
    }

    public class ValidatorImpl
    implements SpaceLabelService.Validator {
        public ValidationResult validateFindRelatedContentLabelsPaginated(String labelName, String spaceKey) {
            if (LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get()) == null) {
                return new SimpleValidationResult.Builder().authorized(true).addError("Invalid label: " + labelName, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.badRequestExceptionSupplier()).build();
            }
            Label label = SpaceLabelServiceImpl.this.labelManager.getLabel(labelName);
            if (label == null) {
                return new SimpleValidationResult.Builder().authorized(true).addError("Cannot find label with name: " + labelName, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
            }
            Space internalSpace = SpaceLabelServiceImpl.this.spaceManager.getSpace(spaceKey);
            if (internalSpace == null) {
                return new SimpleValidationResult.Builder().authorized(true).addError("Unknown space key: " + spaceKey, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (!SpaceLabelServiceImpl.this.permissionManager.hasPermission(user, Permission.VIEW, (Object)internalSpace)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }
    }
}

