/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.api.impl.service.content.SpaceValidatorImpl;
import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.factory.SpaceFactory;
import com.atlassian.confluence.api.impl.service.content.finder.AbstractFinder;
import com.atlassian.confluence.api.impl.service.longtasks.LongTaskFactory;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.BlockedSpace;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.PersonalSpaceDetailsForCreation;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.pagination.SpaceFilterAwarePageResponseImpl;
import com.atlassian.confluence.api.model.reference.Collapsed;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.content.SpaceLabelService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.dmz.service.content.finder.FinderProxyFactory;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.dmz.spaces.SpaceRemovalLongRunningTask;
import com.atlassian.confluence.impl.space.deletion.SpaceDeletionManager;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceServiceImpl
implements SpaceService {
    private static final Logger log = LoggerFactory.getLogger(SpaceServiceImpl.class);
    private static final Expansions DEFAULT_CREATE_UPDATE_EXPANSIONS = new Expansions(ExpansionsParser.parse((String)("homepage,description." + String.valueOf(ContentRepresentation.PLAIN))));
    private final SpaceManagerInternal spaceManager;
    private final SpaceFactory spaceFactory;
    private final PageManagerInternal pageManager;
    private final ContentFactory contentFactory;
    private final PaginationService paginationService;
    private final SpacePermissionManager spacePermissionManager;
    private final LongRunningTaskManager longRunningTaskManager;
    private final LongTaskFactory longTaskFactory;
    private final I18NBeanFactory i18NBeanFactory;
    private final FinderProxyFactory finderProxyFactory;
    private final LabelManager labelManager;
    private final SpaceDeletionManager spaceDeletionManager;
    private final SpaceLabelService spaceLabelService;
    private final SpaceValidatorImpl spaceValidator;
    private final TrashManager trashManager;
    private final UserAccessor userAccessor;

    public SpaceServiceImpl(SpaceManagerInternal spaceManager, SpaceFactory spaceFactory, PageManagerInternal pageManager, ContentFactory contentFactory, PaginationService paginationService, SpacePermissionManager spacePermissionManager, LongRunningTaskManager longRunningTaskManager, LongTaskFactory longTaskFactory, I18NBeanFactory i18NBeanFactory, FinderProxyFactory finderProxyFactory, LabelManager labelManager, SpaceDeletionManager spaceDeletionManager, SpaceLabelService spaceLabelService, SpaceService.Validator spaceValidator, TrashManager trashManager, UserAccessor userAccessor) {
        this.spaceManager = spaceManager;
        this.spaceFactory = spaceFactory;
        this.pageManager = pageManager;
        this.contentFactory = contentFactory;
        this.paginationService = paginationService;
        this.spacePermissionManager = spacePermissionManager;
        this.longRunningTaskManager = longRunningTaskManager;
        this.longTaskFactory = longTaskFactory;
        this.i18NBeanFactory = i18NBeanFactory;
        this.finderProxyFactory = finderProxyFactory;
        this.labelManager = labelManager;
        this.spaceDeletionManager = spaceDeletionManager;
        this.spaceLabelService = spaceLabelService;
        this.spaceValidator = (SpaceValidatorImpl)spaceValidator;
        this.trashManager = trashManager;
        this.userAccessor = userAccessor;
    }

    public com.atlassian.confluence.api.model.content.Space create(com.atlassian.confluence.api.model.content.Space space, boolean isPrivate) throws ServiceException {
        this.validator().validateCreate(space, isPrivate).throwIfNotSuccessful("Cannot create Space");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String key = space.getKey();
        String name = space.getName();
        String description = this.getDescription(space);
        Space newSpace = isPrivate ? this.spaceManager.createPrivateSpace(key, name, description, user) : this.spaceManager.createSpace(key, name, description, user);
        return this.spaceFactory.buildFrom(newSpace, DEFAULT_CREATE_UPDATE_EXPANSIONS);
    }

    public com.atlassian.confluence.api.model.content.Space createPersonalSpaceForSelf(PersonalSpaceDetailsForCreation spaceDetails) throws ServiceException {
        this.validator().validateCreatePersonalSpaceForSelf(spaceDetails).throwIfNotSuccessful();
        return this.createPersonalSpace(spaceDetails, AuthenticatedUserThreadLocal.get());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public com.atlassian.confluence.api.model.content.Space createPersonalSpaceForUser(PersonalSpaceDetailsForCreation spaceDetails, String username) throws ServiceException {
        this.validator().validateCreatePersonalSpaceForUser(spaceDetails, username).throwIfNotSuccessful();
        return this.createPersonalSpace(spaceDetails, this.userAccessor.getUserByName(username));
    }

    com.atlassian.confluence.api.model.content.Space createPersonalSpace(PersonalSpaceDetailsForCreation spaceDetails, ConfluenceUser owner) {
        String description = this.getDescription(spaceDetails.getDescription());
        String spaceName = owner.getFullName();
        Space newSpace = spaceDetails.isPrivate() ? this.spaceManager.createPrivatePersonalSpace(spaceName, description, owner) : this.spaceManager.createPersonalSpace(spaceName, description, owner);
        return this.spaceFactory.buildFrom(newSpace, DEFAULT_CREATE_UPDATE_EXPANSIONS);
    }

    public LongTaskSubmission delete(com.atlassian.confluence.api.model.content.Space spaceToDelete) throws ServiceException {
        this.validator().validateDelete(spaceToDelete).throwIfNotSuccessful("Cannot delete Space");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        SpaceRemovalLongRunningTask spaceRemovalLongRunningTask = new SpaceRemovalLongRunningTask(spaceToDelete.getKey(), this.spaceManager, user, this.i18NBeanFactory.getI18NBean());
        LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask(user, (LongRunningTask)spaceRemovalLongRunningTask);
        LongTaskId taskId = longRunningTaskId.asLongTaskId();
        return this.longTaskFactory.buildSubmission(taskId);
    }

    public void delete(long spaceId) throws ServiceException {
        this.validateDeleteSpacePermissions(spaceId);
        this.spaceDeletionManager.deleteSpaceAsync(spaceId);
    }

    public void deleteSynchronously(long spaceId) throws ServiceException {
        this.validateDeleteSpacePermissions(spaceId);
        this.spaceDeletionManager.deleteSpaceSync(spaceId);
    }

    private void validateDeleteSpacePermissions(long spaceId) {
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", this.getSpaceById(spaceId), AuthenticatedUserThreadLocal.get())) {
            throw new PermissionException("Access to space with " + spaceId + " denied.");
        }
    }

    private Space getSpaceById(long spaceId) {
        List spaces = this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceIds(Set.of(Long.valueOf(spaceId))).build(), LimitedRequestImpl.create((int)1), new Predicate[0]).getResults();
        if (spaces.isEmpty()) {
            throw new PermissionException("Access to space with " + spaceId + " denied or the space does not exists.");
        }
        return (Space)spaces.get(0);
    }

    private String getDescription(Map<ContentRepresentation, FormattedBody> descriptionMap) {
        if (descriptionMap == null || descriptionMap instanceof Collapsed) {
            return null;
        }
        FormattedBody description = descriptionMap.get(SpaceFactory.DEFAULT_DESCRIPTION_REPRESENTATION);
        if (description == null) {
            log.debug("Space description map supplied, but no entry for: {}", (Object)SpaceFactory.DEFAULT_DESCRIPTION_REPRESENTATION);
            return null;
        }
        return description.getValue();
    }

    private String getDescription(com.atlassian.confluence.api.model.content.Space space) {
        return this.getDescription(space.getDescription());
    }

    public SpaceService.SpaceFinder find(Expansion ... expansions) {
        SpaceFinderImpl finder = new SpaceFinderImpl(expansions);
        return (SpaceService.SpaceFinder)this.finderProxyFactory.createProxy((Object)finder, SpaceService.SpaceFinder.class);
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findAllContentLabelsPaginated(String spaceKey, PageRequest pageRequest) {
        return this.spaceLabelService.findAllContentLabelsPaginated(spaceKey, pageRequest);
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findPopularContentLabelsPaginated(String spaceKey, PageRequest pageRequest) {
        return this.spaceLabelService.findPopularContentLabelsPaginated(spaceKey, pageRequest);
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findRecentContentLabelsPaginated(String spaceKey, PageRequest pageRequest) {
        return this.spaceLabelService.findRecentContentLabelsPaginated(spaceKey, pageRequest);
    }

    public PageResponse<com.atlassian.confluence.api.model.content.Label> findRelatedContentLabelsPaginated(String spaceKey, String labelName, PageRequest pageRequest) {
        return this.spaceLabelService.findRelatedContentLabelsPaginated(spaceKey, labelName, pageRequest);
    }

    public void archive(String spaceKey) {
        com.atlassian.confluence.api.model.content.Space space = com.atlassian.confluence.api.model.content.Space.builder().key(spaceKey).build();
        this.validator().validateArchive(space).throwIfNotSuccessful("Cannot archive Space");
        Space internalSpace = Objects.requireNonNull(this.spaceManager.getSpace(spaceKey));
        this.spaceManager.archiveSpace(internalSpace);
    }

    public void restore(String spaceKey) {
        com.atlassian.confluence.api.model.content.Space space = com.atlassian.confluence.api.model.content.Space.builder().key(spaceKey).build();
        this.validator().validateRestore(space).throwIfNotSuccessful("Cannot restore Space");
        Space internalSpace = Objects.requireNonNull(this.spaceManager.getSpace(spaceKey));
        this.spaceManager.unarchiveSpace(internalSpace);
    }

    public com.atlassian.confluence.api.model.content.Space update(com.atlassian.confluence.api.model.content.Space space) throws ServiceException {
        Reference homepageRef;
        Space originalSpace;
        this.validator().validateUpdate(space).throwIfNotSuccessful("Cannot update Space");
        Space updatedSpace = Objects.requireNonNull(this.spaceManager.getSpace(space.getKey()));
        try {
            originalSpace = (Space)updatedSpace.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceException("Unable to create clone while updating space with key: " + space.getKey(), (Throwable)e);
        }
        updatedSpace.setName(space.getName());
        String description = this.getDescription(space);
        if (description != null) {
            updatedSpace.getDescription().setBodyAsString(description);
        }
        if ((homepageRef = space.getHomepageRef()).exists() && homepageRef.isExpanded()) {
            ContentId homepageId = ((Content)homepageRef.get()).getId();
            updatedSpace.setHomePage(this.pageManager.getPage(homepageId.asLong()));
        }
        this.spaceManager.saveSpace(updatedSpace, originalSpace);
        return this.spaceFactory.buildFrom(updatedSpace, DEFAULT_CREATE_UPDATE_EXPANSIONS);
    }

    public SpaceService.SpaceContentFinder findContent(com.atlassian.confluence.api.model.content.Space space, Expansion ... expansions) throws NotFoundException {
        SpaceContentImpl finder = new SpaceContentImpl(space, expansions);
        return (SpaceService.SpaceContentFinder)this.finderProxyFactory.createProxy((Object)finder, SpaceService.SpaceContentFinder.class);
    }

    public void emptyTrash(String spaceKey) throws ServiceException {
        this.validator().validateEmptyTrash(spaceKey).throwIfNotSuccessful();
        Space internalSpace = this.spaceManager.getSpace(spaceKey);
        this.trashManager.emptyTrash(internalSpace);
    }

    public SpaceValidatorImpl validator() {
        return this.spaceValidator;
    }

    public class SpaceFinderImpl
    extends AbstractFinder<com.atlassian.confluence.api.model.content.Space>
    implements SpaceService.SpaceFinder {
        private final SpacesQuery.Builder queryBuilder;

        SpaceFinderImpl(Expansion ... expansions) {
            super(expansions);
            this.queryBuilder = SpacesQuery.newQuery();
        }

        public SpaceService.SpaceFinder withKeys(String ... keys) {
            this.queryBuilder.withSpaceKeys(Arrays.asList(keys));
            return this;
        }

        public SpaceService.SpaceFinder withIds(Set<Long> ids) {
            this.queryBuilder.withSpaceIds(ids);
            return this;
        }

        public SpaceService.SpaceFinder withType(SpaceType type) {
            this.queryBuilder.withSpaceType(com.atlassian.confluence.spaces.SpaceType.getSpaceType((String)type.getType()));
            return this;
        }

        public SpaceService.SpaceFinder withStatus(com.atlassian.confluence.api.model.content.SpaceStatus status) {
            try {
                this.queryBuilder.withSpaceStatus(SpaceStatus.valueOf((String)status.getStatus().toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Could not fetch spaces with unrecognized status " + status.getValue());
            }
            return this;
        }

        public SpaceService.SpaceFinder withLabels(com.atlassian.confluence.api.model.content.Label ... labels) {
            this.queryBuilder.withLabels((Iterable)Arrays.stream(labels).map(label -> {
                Label internalLabel = SpaceServiceImpl.this.labelManager.getLabel(label.getLabel(), Namespace.getNamespace((String)label.getPrefix()));
                if (internalLabel == null) {
                    throw new BadRequestException("Could not fetch spaces with unrecognized label " + label.getLabel());
                }
                return internalLabel;
            }).collect(Collectors.toList()));
            return this;
        }

        public SpaceService.SpaceFinder withContentContainingLabels(List<String> labels) {
            this.queryBuilder.withContentContainingLabels((Iterable)labels.stream().map(label -> {
                ParsedLabelName parsedLabel = LabelParser.parse((String)label, (User)AuthenticatedUserThreadLocal.get());
                if (parsedLabel == null) {
                    throw new BadRequestException("Could not parse label " + label);
                }
                Label internalLabel = SpaceServiceImpl.this.labelManager.getLabel(parsedLabel.toLabel());
                if (internalLabel == null) {
                    throw new BadRequestException("Could not fetch spaces with unrecognized label " + label);
                }
                return internalLabel;
            }).collect(Collectors.toList()));
            return this;
        }

        public SpaceService.SpaceFinder withIsFavourited(boolean isFavourited) {
            this.queryBuilder.withIsFavourited(isFavourited);
            return this;
        }

        public SpaceService.SpaceFinder withHasRetentionPolicy(boolean hasRetentionPolicy) {
            this.queryBuilder.withHasRetentionPolicy(hasRetentionPolicy);
            return this;
        }

        public PageResponse<com.atlassian.confluence.api.model.content.Space> fetchMany(PageRequest request) {
            Expansions parsedExpansions = new Expansions(this.expansions);
            SpacesQuery query = this.queryBuilder.build();
            PageResponse originalResponse = SpaceServiceImpl.this.paginationService.performPaginationListRequest(LimitedRequestImpl.create((PageRequest)request, (int)PaginationLimits.spaces((Expansions)parsedExpansions)), input -> SpaceServiceImpl.this.spaceManager.getSpaces(query, input, new Predicate[]{SpaceServiceImpl.this.validator().getCanView(), SpaceServiceImpl.this.validator().getCanViewContentWithLabels(query.getContentLabels())}), items -> SpaceServiceImpl.this.spaceFactory.buildFrom((Iterable)items, parsedExpansions));
            if (this.getExpansions().canExpand("respectSpaceFilter")) {
                List<com.atlassian.confluence.api.model.content.Space> filteredList = originalResponse.getResults().stream().filter(space -> !(space instanceof BlockedSpace)).toList();
                List<com.atlassian.confluence.api.model.content.Space> blockedList = originalResponse.getResults().stream().filter(space -> space instanceof BlockedSpace).toList();
                return SpaceFilterAwarePageResponseImpl.from((PageResponse)originalResponse, blockedList, filteredList).build();
            }
            return originalResponse;
        }

        public Optional<com.atlassian.confluence.api.model.content.Space> fetch() {
            List spaces = this.fetchMany((PageRequest)new SimplePageRequest(0, 1)).getResults();
            return spaces.isEmpty() ? Optional.empty() : Optional.of((com.atlassian.confluence.api.model.content.Space)spaces.get(0));
        }
    }

    public class SpaceContentImpl
    implements SpaceService.SpaceContentFinder {
        private final com.atlassian.confluence.api.model.content.Space space;
        private final Expansions contentExpansions;
        private List<ContentType> contentTypeFilter = Arrays.asList(ContentType.PAGE, ContentType.BLOG_POST);
        private Depth depth = Depth.ALL;

        SpaceContentImpl(com.atlassian.confluence.api.model.content.Space space, Expansion ... expansions) throws NotFoundException {
            this.space = (com.atlassian.confluence.api.model.content.Space)Preconditions.checkNotNull((Object)space);
            this.contentExpansions = new Expansions((Expansion[])Preconditions.checkNotNull((Object)expansions));
        }

        public SpaceService.SpaceContentFinder withDepth(Depth depth) {
            this.depth = (Depth)Preconditions.checkNotNull((Object)depth);
            return this;
        }

        public Map<ContentType, PageResponse<Content>> fetchMappedByType(PageRequest pageRequest) throws BadRequestException {
            ImmutableMap.Builder contentByType = ImmutableMap.builder();
            for (ContentType type : this.contentTypeFilter) {
                contentByType.put((Object)type, this.fetchMany(type, pageRequest));
            }
            return contentByType.build();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PageResponse<Content> fetchMany(ContentType type, PageRequest pageRequest) throws BadRequestException {
            void var4_7;
            final Space internalSpace = SpaceServiceImpl.this.validator().getInternalSpace(this.space);
            if (internalSpace == null) {
                throw new NotFoundException("A space with key " + this.space.getKey() + " does not exist or you do not have permission to view it");
            }
            if (ContentType.PAGE.equals((Object)type)) {
                if (Depth.ALL.equals(this.depth)) {
                    PaginationBatch<Page> paginationBatch = new PaginationBatch<Page>(){

                        public PageResponse<Page> apply(@NonNull LimitedRequest nextRequest) {
                            return SpaceServiceImpl.this.pageManager.getFilteredPages(internalSpace, nextRequest, new Predicate[0]);
                        }
                    };
                    return this.fetchPageOfContent(pageRequest, (PaginationBatch<? extends AbstractPage>)var4_7);
                } else {
                    if (!Depth.ROOT.equals(this.depth)) throw new BadRequestException("Unrecognized depth :" + String.valueOf(this.depth));
                    PaginationBatch<Page> paginationBatch = new PaginationBatch<Page>(){

                        public PageResponse<Page> apply(@NonNull LimitedRequest nextRequest) {
                            return SpaceServiceImpl.this.pageManager.getTopLevelPages(internalSpace, nextRequest);
                        }
                    };
                }
                return this.fetchPageOfContent(pageRequest, (PaginationBatch<? extends AbstractPage>)var4_7);
            } else {
                if (!ContentType.BLOG_POST.equals((Object)type)) throw new BadRequestException("Not supported content type: " + type.getType());
                PaginationBatch<BlogPost> paginationBatch = new PaginationBatch<BlogPost>(){

                    public PageResponse<BlogPost> apply(@NonNull LimitedRequest nextRequest) {
                        return SpaceServiceImpl.this.pageManager.getFilteredBlogPosts(internalSpace, nextRequest, new Predicate[0]);
                    }
                };
            }
            return this.fetchPageOfContent(pageRequest, (PaginationBatch<? extends AbstractPage>)var4_7);
        }

        private PageResponse<Content> fetchPageOfContent(PageRequest pageRequest, PaginationBatch<? extends AbstractPage> batchFetcher) {
            LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.content((Expansions)this.contentExpansions));
            return SpaceServiceImpl.this.paginationService.performPaginationListRequest(limitedRequest, batchFetcher, items -> SpaceServiceImpl.this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, this.contentExpansions));
        }
    }
}

