/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.plugin.webresource.WebResourceDependenciesRecorder;
import com.atlassian.plugin.webresource.assembler.LegacyPageBuilderService;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Pair;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.LazyReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadlocalWebResourceDependenciesRecorder
implements WebResourceDependenciesRecorder {
    private static final Logger log = LoggerFactory.getLogger(ThreadlocalWebResourceDependenciesRecorder.class);
    private final LegacyPageBuilderService pageBuilderService;
    private final ThreadLocal<RecordingWebResourceAssembler> assemblerStorage = new ThreadLocal();
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;

    public ThreadlocalWebResourceDependenciesRecorder(WebResourceAssemblerFactory webResourceAssemblerFactory, LegacyPageBuilderService pageBuilderService) {
        this.pageBuilderService = Objects.requireNonNull(pageBuilderService);
        this.webResourceAssemblerFactory = Objects.requireNonNull(webResourceAssemblerFactory);
    }

    public <T> Pair<T, WebResourceDependenciesRecorder.RecordedResources> recordResources(Callable<T> renderAction, Consumer<RequiredResources> requiredResourcesCallback, Consumer<WebResourceAssemblerBuilder> assemblerBuilderCallback) throws Exception {
        try {
            Pair pair;
            block9: {
                Ticker ignored = Timers.start((String)(ThreadlocalWebResourceDependenciesRecorder.class.getSimpleName() + ".record()"));
                try {
                    log.debug("start recording webresource dependencies");
                    WebResourceAssemblerBuilder builder = this.webResourceAssemblerFactory.create();
                    assemblerBuilderCallback.accept(builder);
                    RecordingWebResourceAssembler assembler = new RecordingWebResourceAssembler(builder.build());
                    this.assemblerStorage.set(assembler);
                    this.pageBuilderService.clearRequestLocal();
                    this.pageBuilderService.seed((WebResourceAssembler)assembler);
                    requiredResourcesCallback.accept(assembler.resources());
                    pair = Pair.pair(renderAction.call(), (Object)new CachingRecordedResources(assembler));
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return pair;
        }
        finally {
            this.pageBuilderService.clearRequestLocal();
            this.assemblerStorage.remove();
            log.debug("ended recording webresource dependencies");
        }
    }

    private static class RecordingWebResourceAssembler
    implements WebResourceAssembler {
        private final WebResourceAssembler delegate;
        private final LinkedHashMap<String, ResourcePhase> contexts = Maps.newLinkedHashMap();
        private final LinkedHashMap<String, ResourcePhase> webResources = Maps.newLinkedHashMap();

        RecordingWebResourceAssembler(WebResourceAssembler delegate) {
            this.delegate = delegate;
        }

        public AssembledResources assembled() {
            return this.delegate.assembled();
        }

        public WebResourceAssembler copy() {
            return this.delegate.copy();
        }

        public RequiredData data() {
            return this.delegate.data();
        }

        public RequiredResources resources() {
            return new RecordingRequiredResources(this.delegate.resources());
        }

        private class RecordingRequiredResources
        implements RequiredResources {
            private final RequiredResources realImplementation;

            RecordingRequiredResources(RequiredResources resources) {
                this.realImplementation = resources;
            }

            public @NonNull RequiredResources exclude(@Nullable Set<String> webResource, @Nullable Set<String> context) {
                if (context != null) {
                    context.forEach(RecordingWebResourceAssembler.this.contexts::remove);
                }
                if (webResource != null) {
                    webResource.forEach(RecordingWebResourceAssembler.this.webResources::remove);
                }
                this.realImplementation.exclude(webResource, context);
                return this;
            }

            public @NonNull RequiredResources requireContext(@NonNull String context) {
                return this.requireContext(ResourcePhase.defaultPhase(), context);
            }

            public @NonNull RequiredResources requireContext(@NonNull ResourcePhase phase, @NonNull String context) {
                RecordingWebResourceAssembler.this.contexts.put(context, phase);
                this.realImplementation.requireContext(phase, context);
                return this;
            }

            public @NonNull RequiredResources requireWebResource(@NonNull String webResource) {
                return this.requireWebResource(ResourcePhase.defaultPhase(), webResource);
            }

            public @NonNull RequiredResources requireWebResource(@NonNull ResourcePhase phase, @NonNull String webResource) {
                RecordingWebResourceAssembler.this.webResources.put(webResource, phase);
                this.realImplementation.requireWebResource(webResource);
                return this;
            }

            public @NonNull RequiredResources requirePage(@NonNull String page) {
                return this.requirePage(ResourcePhase.defaultPhase(), page);
            }

            public @NonNull RequiredResources requirePage(@NonNull ResourcePhase phase, @NonNull String page) {
                throw new UnsupportedOperationException("Not implemented");
            }

            public @NonNull RequiredResources excludeSuperbatch() {
                throw new UnsupportedOperationException("Not implemented");
            }

            public @NonNull RequiredResources requireSuperbatch(@NonNull ResourcePhase resourcePhase) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
        }
    }

    private class CachingRecordedResources
    implements WebResourceDependenciesRecorder.RecordedResources {
        private final Supplier<WebResourceSet> superbatchResourceCache;
        private final Supplier<WebResourceSet> resourcesCache;
        private final RecordingWebResourceAssembler assembler;

        CachingRecordedResources(RecordingWebResourceAssembler assembler) {
            this.assembler = assembler;
            this.superbatchResourceCache = new LazyReference<WebResourceSet>(){

                protected WebResourceSet create() {
                    try {
                        WebResourceSet webResourceSet;
                        block9: {
                            Ticker ignored = Timers.start((String)(ThreadlocalWebResourceDependenciesRecorder.class.getSimpleName() + ".superbatch.create()"));
                            try {
                                log.trace("start superbatch webresource dependencies calculation");
                                WebResourceAssemblerBuilder superBatchBuilder = ThreadlocalWebResourceDependenciesRecorder.this.webResourceAssemblerFactory.create();
                                superBatchBuilder.includeSuperbatchResources(true);
                                WebResourceAssembler superBatchAssembler = superBatchBuilder.build();
                                webResourceSet = superBatchAssembler.assembled().drainIncludedResources();
                                if (ignored == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (ignored != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            ignored.close();
                        }
                        return webResourceSet;
                    }
                    finally {
                        log.trace("finish superbatch webresource dependencies calculation");
                    }
                }
            };
            this.resourcesCache = Lazy.supplier(() -> assembler.assembled().drainIncludedResources());
        }

        public Supplier<WebResourceSet> webresources() {
            return this.resourcesCache;
        }

        public Iterable<String> contexts() {
            return List.copyOf(this.assembler.contexts.keySet());
        }

        public Iterable<String> resourceKeys() {
            return List.copyOf(this.assembler.webResources.keySet());
        }

        public Supplier<WebResourceSet> superbatch() {
            return this.superbatchResourceCache;
        }
    }
}

