/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.factory;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.factory.Fauxpansions;
import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.impl.service.content.factory.SpaceMetadataFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.ModelFactory;
import com.atlassian.confluence.api.model.content.BlockedSpace;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentSelector;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.content.webresource.WebResourceDependencies;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.permissions.SpacePermissionContainer;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.retention.SpaceRetentionPolicy;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.permissions.SpacePermissionService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.retention.SpaceRetentionPolicyService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.util.logging.LoggingContext;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableSet;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceFactory
implements ModelFactory<Space, com.atlassian.confluence.api.model.content.Space> {
    public static final ContentRepresentation DEFAULT_DESCRIPTION_REPRESENTATION = ContentRepresentation.PLAIN;
    private static final Logger log = LoggerFactory.getLogger(SpaceFactory.class);
    private static final String MDC_SPACE_ID = "spaceId";
    private static final String MDC_SPACE_KEY = "spaceKey";
    private final SpaceLogoManager spaceLogoManager;
    private final SpaceManager spaceManager;
    private final Supplier<ContentFactory> contentFactorySupplier;
    private final SpaceMetadataFactory spaceMetadataFactory;
    private final PersonFactory personFactory;
    private final PermissionManager permissionManager;
    private final SpaceRetentionPolicyService spaceRetentionPolicyService;
    private final SpacePermissionService spacePermissionService;
    private final SpaceFilteringService spaceFilteringService;
    private static final int DEFAULT_ICON_HEIGHT = 48;
    private static final int DEFAULT_ICON_WIDTH = 48;
    private static final Collection<ContentRepresentation> DESCRIPTION_REPRESENTATIONS = ImmutableSet.of((Object)ContentRepresentation.PLAIN, (Object)ContentRepresentation.VIEW);

    public SpaceFactory(SpaceLogoManager spaceLogoManager, SpaceManager spaceManager, Supplier<ContentFactory> contentFactorySupplier, SpaceMetadataFactory spaceMetadataFactory, PersonFactory personFactory, PermissionManager permissionManager, SpaceRetentionPolicyService spaceRetentionPolicyService, SpacePermissionService spacePermissionService, SpaceFilteringService spaceFilteringService) {
        this.spaceLogoManager = spaceLogoManager;
        this.spaceManager = spaceManager;
        this.contentFactorySupplier = contentFactorySupplier;
        this.spaceMetadataFactory = spaceMetadataFactory;
        this.personFactory = personFactory;
        this.permissionManager = permissionManager;
        this.spaceRetentionPolicyService = spaceRetentionPolicyService;
        this.spacePermissionService = spacePermissionService;
        this.spaceFilteringService = spaceFilteringService;
    }

    public com.atlassian.confluence.api.model.content.Space buildFrom(long spaceId, Expansions expansions) {
        Space space = this.spaceManager.getSpace(spaceId);
        if (space == null) {
            return com.atlassian.confluence.api.model.content.Space.builder().id(spaceId).build();
        }
        return this.buildFrom(space, expansions);
    }

    public com.atlassian.confluence.api.model.content.Space buildFrom(String spaceKey, Expansions expansions) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.buildFrom(space, expansions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.atlassian.confluence.api.model.content.Space buildFrom(Space space, Expansions expansions) {
        block4: {
            BlockedSpace blockedSpace;
            Objects.requireNonNull(space);
            LoggingContext.put((String)MDC_SPACE_ID, (Object)space.getId());
            LoggingContext.put((String)MDC_SPACE_KEY, (Object)space.getKey());
            try {
                if (log.isDebugEnabled()) {
                    log.warn("Building space {} with expansions {}", (Object)space.getKey(), (Object)expansions);
                }
                if (!this.shouldBlockForSpaceFilter(space, expansions)) break block4;
                blockedSpace = BlockedSpace.builder((Long)space.getId(), (String)space.getKey()).build();
            }
            catch (Throwable throwable) {
                LoggingContext.remove((String[])new String[]{MDC_SPACE_ID, MDC_SPACE_KEY});
                throw throwable;
            }
            LoggingContext.remove((String[])new String[]{MDC_SPACE_ID, MDC_SPACE_KEY});
            return blockedSpace;
        }
        Person creator = this.personFactory.forUser(space.getCreator(), expansions.getSubExpansions("creator"), false);
        Person lastModifier = this.personFactory.forUser(space.getLastModifier(), expansions.getSubExpansions("lastModifier"), false);
        Reference<Icon> iconIfExpanded = this.getIconIfExpanded(space, expansions);
        Map<ContentRepresentation, FormattedBody> description = this.buildDescription(space, expansions);
        Reference<Content> homepageRef = this.getHomepageRef(space.getHomePage(), expansions);
        Map<String, Object> metadata = this.spaceMetadataFactory.makeMetadata(space, Fauxpansions.fauxpansions(expansions, "metadata"));
        Reference<SpaceRetentionPolicy> retentionPolicyIfExpanded = this.getRetentionPolicyIfExpanded(space, expansions);
        Reference<SpacePermissionContainer> spacePermissionIfExpanded = this.getSpacePermissionIfExpanded(space, expansions);
        com.atlassian.confluence.spaces.SpaceType dbSpaceType = space.getSpaceType();
        com.atlassian.confluence.api.model.content.Space space2 = com.atlassian.confluence.api.model.content.Space.builder().id(space.getId()).key(space.getKey()).name(space.getName()).status(space.getSpaceStatus() == null ? null : SpaceStatus.valueOf((String)space.getSpaceStatus().toString())).type(dbSpaceType == null ? null : SpaceType.forName((String)dbSpaceType.toString())).creator(creator).creationDate(OffsetDateTime.ofInstant(space.getCreationDate().toInstant(), ZoneId.systemDefault())).lastModifier(lastModifier).lastModificationDate(OffsetDateTime.ofInstant(space.getLastModificationDate().toInstant(), ZoneId.systemDefault())).icon(iconIfExpanded).description(description).homepage(homepageRef).metadata(metadata).addLink(LinkType.WEB_UI, space.getUrlPath()).retentionPolicy(retentionPolicyIfExpanded).permissions(spacePermissionIfExpanded).build();
        LoggingContext.remove((String[])new String[]{MDC_SPACE_ID, MDC_SPACE_KEY});
        return space2;
    }

    private Reference<Content> getHomepageRef(Page homepage, Expansions expansions) {
        if (homepage == null || !this.canView((ContentEntityObject)homepage)) {
            return Reference.empty(Content.class);
        }
        if (log.isDebugEnabled()) {
            log.debug("Building homepage for space");
        }
        if (!expansions.canExpand("homepage")) {
            return Content.buildReference((ContentSelector)homepage.getSelector());
        }
        ContentFactory contentFactory = this.contentFactorySupplier.get();
        Content homepageContent = contentFactory.buildFrom((ContentEntityObject)homepage, expansions.getSubExpansions("homepage"));
        return Reference.to((Object)homepageContent);
    }

    private Reference<Icon> getIconIfExpanded(Space space, Expansions expansions) {
        if (!expansions.canExpand("icon")) {
            return Reference.collapsed(Icon.class);
        }
        if (log.isDebugEnabled()) {
            log.debug("Building icon for space {}", (Object)space.getKey());
        }
        String path = this.spaceLogoManager.getLogoDownloadPath(space, (User)AuthenticatedUserThreadLocal.get());
        Icon icon = new Icon(path, 48, 48, false);
        return Reference.to((Object)icon);
    }

    private Reference<SpaceRetentionPolicy> getRetentionPolicyIfExpanded(Space space, Expansions expansions) {
        if (expansions.canExpand("retentionPolicy")) {
            Optional spaceRetentionPolicy;
            if (log.isDebugEnabled()) {
                log.debug("Building retention policy for space {}", (Object)space.getKey());
            }
            if ((spaceRetentionPolicy = this.spaceRetentionPolicyService.getPolicy(space.getKey())).isPresent()) {
                return Reference.to((Object)((SpaceRetentionPolicy)spaceRetentionPolicy.get()));
            }
        }
        return Reference.collapsed(SpaceRetentionPolicy.class);
    }

    private Reference<SpacePermissionContainer> getSpacePermissionIfExpanded(Space space, Expansions expansions) {
        List allPermissions;
        if (!expansions.canExpand("permissions")) {
            return Reference.collapsed(SpacePermissionContainer.class);
        }
        if (log.isDebugEnabled()) {
            log.debug("Building space permissions for space {}", (Object)space.getKey());
        }
        if (!(allPermissions = this.spacePermissionService.getAllPermissions(space.getKey())).isEmpty()) {
            SpaceDescription spaceDescription = space.getDescription();
            Optional permissionLastModifiedDate = spaceDescription == null ? Optional.empty() : spaceDescription.getPermissionLastModifiedDate();
            OffsetDateTime lastModifiedDate = permissionLastModifiedDate.map(instant -> OffsetDateTime.ofInstant(instant, ZoneId.systemDefault())).orElseGet(OffsetDateTime::now);
            SpacePermissionContainer spacePermissionContainer = new SpacePermissionContainer(space.getKey(), allPermissions, lastModifiedDate);
            return Reference.to((Object)spacePermissionContainer);
        }
        return Reference.empty(SpacePermissionContainer.class);
    }

    private Map<ContentRepresentation, FormattedBody> buildDescription(Space space, Expansions expansions) {
        if (!expansions.canExpand("description")) {
            return BuilderUtils.collapsedMap();
        }
        if (space.getDescription() == null) {
            return BuilderUtils.collapsedMap();
        }
        if (log.isDebugEnabled()) {
            log.debug("Building description for space {}", (Object)space.getKey());
        }
        String description = space.getDescription().getBodyAsString();
        Expansions subExpansions = expansions.getSubExpansions("description");
        ModelMapBuilder mapBuilder = ModelMapBuilder.newInstance();
        for (ContentRepresentation representation : DESCRIPTION_REPRESENTATIONS) {
            if (subExpansions.canExpand(representation.getRepresentation())) {
                mapBuilder.put((Object)representation, (Object)this.buildFormattedBody(representation, description));
                continue;
            }
            mapBuilder.addCollapsedEntry((Object)representation);
        }
        return mapBuilder.build();
    }

    private FormattedBody buildFormattedBody(ContentRepresentation representation, String value) {
        String formattedValue;
        if (representation == DEFAULT_DESCRIPTION_REPRESENTATION) {
            formattedValue = value;
        } else if (representation == ContentRepresentation.VIEW) {
            formattedValue = PlainTextToHtmlConverter.toHtml((String)value);
        } else {
            throw new BadRequestException("Only accepted representations for Space Description are: " + StringUtils.join(DESCRIPTION_REPRESENTATIONS, (String)","));
        }
        return ((FormattedBody.FormattedBodyBuilder)((FormattedBody.FormattedBodyBuilder)((FormattedBody.FormattedBodyBuilder)FormattedBody.builder().representation(representation)).value(formattedValue)).webresource(Reference.empty(WebResourceDependencies.class))).build();
    }

    private boolean canView(ContentEntityObject entity) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)entity);
    }

    private boolean shouldBlockForSpaceFilter(Space space, Expansions expansions) {
        return expansions.canExpand("respectSpaceFilter") && space != null && this.spaceFilteringService.isExcluded(space.getKey());
    }
}

