/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.people;

import com.atlassian.confluence.admin.criteria.DefaultWritableDirectoryForGroupsExistsCriteria;
import com.atlassian.confluence.api.impl.service.content.finder.AbstractFinder;
import com.atlassian.confluence.api.impl.service.people.GroupFactory;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.SimpleValidationResults;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.InternalServerException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.dmz.pagination.PagerToPageResponseHelper;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.dmz.service.content.finder.FinderProxyFactory;
import com.atlassian.confluence.dmz.user.UserAccessorInternal;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.security.ServiceAccountPermissionManager;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.atlassianuser.GroupManagerInternal;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.Pagers;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class GroupServiceImpl
implements GroupService {
    String PROPERTY_NAME_ANCESTOR_SEARCH_DEPTH_LIMIT = "confluence.rest.group.ancestor.search.depth.limit";
    String ANCESTOR_SEARCH_DEFAULT_DEPTH_LIMIT = "50";
    private final ConfluenceAccessManager confluenceAccessManager;
    private final GroupManagerInternal groupManager;
    private final UserAccessorInternal userAccessor;
    private final GroupFactory groupFactory;
    private final FinderProxyFactory finderProxyFactory;
    private final PermissionManager permissionManager;
    private final DefaultWritableDirectoryForGroupsExistsCriteria writableDirectoryForGroupsExistsCriteria;
    private final CrowdDirectoryEntityHelper crowdDirectoryEntityHelper;
    private final SpacePermissionManager spacePermissionManager;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final ServiceAccountPermissionManager serviceAccountPermissionManager;
    static final Function<com.atlassian.crowd.model.group.Group, Group> TO_ATLASSIAN_GROUP = from -> from == null ? null : new DefaultGroup(from.getName());

    public GroupServiceImpl(GroupManagerInternal groupManager, ConfluenceAccessManager confluenceAccessManager, UserAccessorInternal userAccessor, GroupFactory groupFactory, FinderProxyFactory finderProxyFactory, PermissionManager permissionManager, DefaultWritableDirectoryForGroupsExistsCriteria writableDirectoryForGroupsExistsCriteria, SpacePermissionManager spacePermissionManager, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, ScopesRequestCacheDelegate scopesRequestCacheDelegate, ServiceAccountPermissionManager serviceAccountPermissionManager) {
        this.groupManager = groupManager;
        this.confluenceAccessManager = confluenceAccessManager;
        this.userAccessor = userAccessor;
        this.groupFactory = groupFactory;
        this.finderProxyFactory = finderProxyFactory;
        this.permissionManager = permissionManager;
        this.writableDirectoryForGroupsExistsCriteria = writableDirectoryForGroupsExistsCriteria;
        this.spacePermissionManager = spacePermissionManager;
        this.crowdDirectoryEntityHelper = crowdDirectoryEntityHelper;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.serviceAccountPermissionManager = serviceAccountPermissionManager;
    }

    public GroupService.GroupFinder find(Expansion ... expansions) {
        this.validator().validateView().throwIfNotSuccessful("Unable to search for groups");
        return (GroupService.GroupFinder)this.finderProxyFactory.createProxy((Object)new GroupFinderImpl(expansions), GroupService.GroupFinder.class);
    }

    public com.atlassian.confluence.api.model.people.Group createGroup(String groupName) {
        this.validator().validateCreate(groupName).throwIfNotSuccessful("Unable to create groups");
        return this.groupFactory.buildFrom(this.userAccessor.addGroup(groupName), Expansions.EMPTY);
    }

    public void deleteGroup(String groupName) {
        this.validator().validateDelete(groupName).throwIfNotSuccessful("Unable to delete group: " + groupName);
        Group group = this.userAccessor.getGroup(groupName);
        this.userAccessor.removeGroup(group);
    }

    public GroupService.Validator validator() {
        return new GroupValidator();
    }

    private boolean canModifyGroups() {
        return this.permissionManager.isConfluenceAdministrator(this.getAuthenticatedUser()) && this.writableDirectoryForGroupsExistsCriteria.isMet();
    }

    private ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public class GroupFinderImpl
    extends AbstractFinder<com.atlassian.confluence.api.model.people.Group>
    implements GroupService.GroupFinder {
        private String groupName;
        private com.atlassian.confluence.api.model.people.User member;
        private com.atlassian.confluence.api.model.people.Group memberOfGroup;
        private com.atlassian.confluence.api.model.people.Group parentOfGroup;
        private com.atlassian.confluence.api.model.people.Group ancestorOfGroup;

        public GroupFinderImpl(Expansion[] expansions) {
            super(expansions);
        }

        public PageResponse<com.atlassian.confluence.api.model.people.Group> fetchMany(PageRequest pageRequest) {
            try {
                return this.fetchGroups(LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.groups()));
            }
            catch (EntityException e) {
                throw new InternalServerException("Error fetching groups", (Throwable)e);
            }
            catch (ApplicationNotFoundException e) {
                throw new InternalServerException("Error fetching application", (Throwable)e);
            }
        }

        public GroupService.GroupFinder withName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public GroupService.GroupFinder withMember(com.atlassian.confluence.api.model.people.User person) {
            GroupServiceImpl.this.validator().validateBrowseAllGroupMembers().throwIfNotSuccessful("Unable to search for groups");
            this.member = person;
            return this;
        }

        public GroupService.GroupFinder withMembershipOf(com.atlassian.confluence.api.model.people.Group group) {
            GroupServiceImpl.this.validator().validateBrowseAllGroupMembersForGroup(group).throwIfNotSuccessful("Unable to search for groups");
            this.memberOfGroup = group;
            return this;
        }

        public GroupService.GroupFinder withParentOf(com.atlassian.confluence.api.model.people.Group group) {
            GroupServiceImpl.this.validator().validateBrowseAllGroupMembersForGroup(group).throwIfNotSuccessful("Unable to search for groups");
            this.parentOfGroup = group;
            return this;
        }

        public GroupService.GroupFinder withAncestorOf(com.atlassian.confluence.api.model.people.Group group) {
            GroupServiceImpl.this.validator().validateBrowseAllGroupMembersForGroup(group).throwIfNotSuccessful("Unable to search for groups");
            this.ancestorOfGroup = group;
            return this;
        }

        private PageResponse<com.atlassian.confluence.api.model.people.Group> fetchGroups(LimitedRequest limitedRequest) throws EntityException, ApplicationNotFoundException {
            if (!Strings.isNullOrEmpty((String)this.groupName)) {
                return PageResponseImpl.from(this.fetchGroupByName(this.groupName), (boolean)false).build();
            }
            Pager<Group> groupPager = null;
            if (this.member == null && this.memberOfGroup == null && this.parentOfGroup == null && this.ancestorOfGroup == null) {
                groupPager = GroupServiceImpl.this.groupManager.getGroups();
            } else if (this.memberOfGroup == null && this.member != null && this.parentOfGroup == null && this.ancestorOfGroup == null) {
                groupPager = this.fetchGroupsByMembership();
            } else if (this.memberOfGroup != null && this.parentOfGroup == null && this.ancestorOfGroup == null) {
                groupPager = this.fetchGroupsByGroupMembership(this.memberOfGroup);
            } else if (this.parentOfGroup != null && this.ancestorOfGroup == null) {
                groupPager = this.fetchParentGroupsByGroup(this.parentOfGroup);
            } else if (this.ancestorOfGroup != null && this.parentOfGroup == null) {
                groupPager = this.fetchAncestorGroupsByGroup(this.ancestorOfGroup);
            }
            if (groupPager == null) {
                return PageResponseImpl.empty((boolean)false);
            }
            return PagerToPageResponseHelper.createFromPager(groupPager, (LimitedRequest)limitedRequest, group -> GroupServiceImpl.this.groupFactory.buildFrom((Group)group, this.getExpansions()));
        }

        private Pager<Group> fetchGroupsByMembership() {
            ConfluenceUser user = this.fetchMemberUser();
            return GroupServiceImpl.this.userAccessor.getGroups((User)user);
        }

        private Pager<Group> fetchGroupsByGroupMembership(com.atlassian.confluence.api.model.people.Group group) throws EntityException {
            if (group == null) {
                return DefaultPager.emptyPager();
            }
            return GroupServiceImpl.this.groupManager.getNestedGroupMember((Group)new DefaultGroup(group.getName()));
        }

        private Pager<Group> fetchParentGroupsByGroup(com.atlassian.confluence.api.model.people.Group group) throws ApplicationNotFoundException {
            if (group == null) {
                return DefaultPager.emptyPager();
            }
            List directParents = GroupServiceImpl.this.crowdDirectoryEntityHelper.getDirectParent((Group)new DefaultGroup(group.getName()));
            return Pagers.newDefaultPager((Iterable)Iterables.transform((Iterable)directParents, TO_ATLASSIAN_GROUP));
        }

        private Pager<Group> fetchAncestorGroupsByGroup(com.atlassian.confluence.api.model.people.Group group) throws ApplicationNotFoundException {
            if (group == null) {
                return DefaultPager.emptyPager();
            }
            return this.getAncestorGroup((Group)new DefaultGroup(group.getName()));
        }

        private Pager<Group> getAncestorGroup(Group group) throws ApplicationNotFoundException {
            int maxDepth = Integer.parseInt(System.getProperty(GroupServiceImpl.this.PROPERTY_NAME_ANCESTOR_SEARCH_DEPTH_LIMIT, GroupServiceImpl.this.ANCESTOR_SEARCH_DEFAULT_DEPTH_LIMIT));
            HashSet<com.atlassian.crowd.model.group.Group> ancestors = new HashSet<com.atlassian.crowd.model.group.Group>();
            LinkedList<GroupInfo> parentQueue = new LinkedList<GroupInfo>();
            parentQueue.push(new GroupInfo(group, 0));
            while (!parentQueue.isEmpty()) {
                GroupInfo currentGroup = (GroupInfo)parentQueue.pop();
                int currentDepth = currentGroup.getDepth();
                if (currentDepth >= maxDepth) continue;
                Group childGroup = currentGroup.getGroup();
                List parentGroups = GroupServiceImpl.this.crowdDirectoryEntityHelper.getDirectParent(childGroup);
                for (com.atlassian.crowd.model.group.Group parent : parentGroups) {
                    if (!ancestors.stream().noneMatch(a -> a.getName().equals(parent.getName()))) continue;
                    ancestors.add(parent);
                    parentQueue.push(new GroupInfo((Group)TO_ATLASSIAN_GROUP.apply((Object)parent), currentDepth + 1));
                }
            }
            return Pagers.newDefaultPager((Iterable)Iterables.transform(ancestors, TO_ATLASSIAN_GROUP));
        }

        private Option<com.atlassian.confluence.api.model.people.Group> fetchGroupByName(String groupName) throws EntityException {
            Group group = GroupServiceImpl.this.groupManager.getGroup(groupName);
            if (group != null && (this.member == null || GroupServiceImpl.this.userAccessor.hasMembership(group, (User)this.fetchMemberUser()))) {
                return Option.option((Object)GroupServiceImpl.this.groupFactory.buildFrom(group, this.getExpansions()));
            }
            return Option.none();
        }

        private ConfluenceUser fetchMemberUser() {
            if (this.member.optionalUserKey().isEmpty() && this.member.optionalUsername().isEmpty()) {
                throw new BadRequestException("One of username or userkey must be defined on the member");
            }
            return (ConfluenceUser)GroupServiceImpl.this.userAccessor.getExistingByApiUser(this.member).orElseThrow(() -> new NotFoundException("Could not find user to check membership of : " + String.valueOf(this.member)));
        }

        public Optional<com.atlassian.confluence.api.model.people.Group> fetch() {
            try {
                if (Strings.isNullOrEmpty((String)this.groupName)) {
                    return io.atlassian.fugue.Iterables.first(this.fetchGroups(LimitedRequestImpl.create((int)1))).toOptional();
                }
                return this.fetchGroupByName(this.groupName).toOptional();
            }
            catch (EntityException ex) {
                throw new InternalServerException("Could not fetch group", (Throwable)ex);
            }
            catch (ApplicationNotFoundException e) {
                throw new InternalServerException("Could not fetch application", (Throwable)e);
            }
        }
    }

    public class GroupValidator
    implements GroupService.Validator {
        public ValidationResult validateView() {
            if (GroupServiceImpl.this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL") || GroupServiceImpl.this.serviceAccountPermissionManager.isServiceAccount(GroupServiceImpl.this.getAuthenticatedUser())) {
                return SimpleValidationResult.builder().authorized(true).build();
            }
            AccessStatus userAccessStatus = GroupServiceImpl.this.confluenceAccessManager.getUserAccessStatus(GroupServiceImpl.this.getAuthenticatedUser());
            return SimpleValidationResult.builder().authorized(userAccessStatus.hasLicensedAccess()).build();
        }

        public ValidationResult validateBrowseAllGroupMembers() {
            return SimpleValidationResult.builder().authorized(GroupServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, com.atlassian.confluence.api.model.people.Group.class)).build();
        }

        public ValidationResult validateBrowseAllGroupMembersForGroup(com.atlassian.confluence.api.model.people.Group group) {
            return SimpleValidationResult.builder().authorized(GroupServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)new DefaultGroup(group.getName()))).build();
        }

        public ValidationResult validateCreate(String groupName) {
            if (!GroupServiceImpl.this.canModifyGroups()) {
                return SimpleValidationResult.FORBIDDEN;
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                return SimpleValidationResult.builder().authorized(true).addError("Group name cannot be empty.", new Object[0]).build();
            }
            if (GroupServiceImpl.this.userAccessor.getGroup(groupName) != null) {
                return SimpleValidationResults.conflictResult((String)"Group name already exists", (Object[])new Object[0]);
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateDelete(String groupName) {
            Group group = GroupServiceImpl.this.userAccessor.getGroup(groupName);
            if (group == null) {
                return SimpleValidationResults.notFoundResult((String)("Group not found: " + groupName), (Object[])new Object[0]);
            }
            if (!GroupServiceImpl.this.canModifyGroups()) {
                return SimpleValidationResult.FORBIDDEN;
            }
            if (!GroupServiceImpl.this.permissionManager.hasPermission(GroupServiceImpl.this.getAuthenticatedUser(), Permission.REMOVE, (Object)group)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            HashSet<String> adminGroups = new HashSet<String>();
            for (SpacePermission spacePermission : GroupServiceImpl.this.spacePermissionManager.getGlobalPermissions()) {
                if (!"SYSTEMADMINISTRATOR".equals(spacePermission.getType()) || !spacePermission.isGroupPermission()) continue;
                adminGroups.add(spacePermission.getGroup());
            }
            if (adminGroups.contains(groupName) && adminGroups.size() == 1) {
                return SimpleValidationResult.builder().authorized(true).addError("Last admin group cannot be deleted.", new Object[0]).build();
            }
            return SimpleValidationResult.VALID;
        }
    }

    private static final class GroupInfo {
        private Group group;
        private int depth;

        public GroupInfo(Group group, int depth) {
            this.group = group;
            this.depth = depth;
        }

        public Group getGroup() {
            return this.group;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

