/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.people;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.impl.service.content.finder.AbstractFinder;
import com.atlassian.confluence.api.impl.service.longtasks.LongTaskFactory;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.model.people.PasswordChangeDetails;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.UserDetailsForCreation;
import com.atlassian.confluence.api.model.people.UserDetailsForUpdate;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.SimpleValidationResults;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.InternalServerException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.api.service.settings.SettingsService;
import com.atlassian.confluence.dmz.pagination.PagerToPageResponseHelper;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.dmz.service.content.finder.FinderProxyFactory;
import com.atlassian.confluence.dmz.user.UserAccessorInternal;
import com.atlassian.confluence.event.events.user.AdminAddedUserEvent;
import com.atlassian.confluence.internal.security.ServiceAccountPermissionManager;
import com.atlassian.confluence.license.exception.LicenseUserLimitExceededException;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.search.v2.DefaultSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchIndexAccessor;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.ActiveUserInfoQuery;
import com.atlassian.confluence.search.v2.sort.FieldSort;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.actions.DeleteUserLongRunningTask;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.Credential;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonServiceImpl
implements PersonService {
    private static final Logger log = LoggerFactory.getLogger(PersonServiceImpl.class);
    private final PermissionManager permissionManager;
    private final PersonFactory personFactory;
    private final UserAccessorInternal userAccessorInternal;
    private final GroupManager groupManager;
    private final FinderProxyFactory finderProxyFactory;
    private final LongRunningTaskManager longRunningTaskManager;
    private final LongTaskFactory longTaskFactory;
    private final I18NBeanFactory i18NBeanFactory;
    private final SettingsService settingsService;
    private final EventPublisher eventPublisher;
    private final SpacePermissionManager spacePermissionManager;
    private final ConfluenceUserResolver confluenceUserResolver;
    private final LoginManager loginManager;
    private final PaginationService paginationService;
    private final SearchIndexAccessor searchIndexAccessor;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final ServiceAccountPermissionManager serviceAccountPermissionManager;

    public PersonServiceImpl(PermissionManager permissionManager, PersonFactory personFactory, UserAccessorInternal userAccessorInternal, GroupManager groupManager, FinderProxyFactory finderProxyFactory, LongRunningTaskManager longRunningTaskManager, LongTaskFactory longTaskFactory, I18NBeanFactory i18NBeanFactory, SettingsService settingsService, EventPublisher eventPublisher, SpacePermissionManager spacePermissionManager, ConfluenceUserResolver confluenceUserResolver, LoginManager loginManager, PaginationService paginationService, SearchIndexAccessor contentSearchIndexAccessor, ScopesRequestCacheDelegate scopesRequestCacheDelegate, ServiceAccountPermissionManager serviceAccountPermissionManager) {
        this.permissionManager = permissionManager;
        this.personFactory = personFactory;
        this.userAccessorInternal = userAccessorInternal;
        this.groupManager = groupManager;
        this.finderProxyFactory = finderProxyFactory;
        this.longRunningTaskManager = longRunningTaskManager;
        this.longTaskFactory = longTaskFactory;
        this.i18NBeanFactory = i18NBeanFactory;
        this.settingsService = settingsService;
        this.eventPublisher = eventPublisher;
        this.spacePermissionManager = spacePermissionManager;
        this.confluenceUserResolver = confluenceUserResolver;
        this.loginManager = loginManager;
        this.paginationService = paginationService;
        this.searchIndexAccessor = contentSearchIndexAccessor;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.serviceAccountPermissionManager = serviceAccountPermissionManager;
    }

    public com.atlassian.confluence.api.model.people.UserKey create(UserDetailsForCreation userDetailsForCreation) {
        this.validator().validateUserCreate(userDetailsForCreation).throwIfNotSuccessful("Unable to create user");
        String password = userDetailsForCreation.getPassword();
        if (Boolean.TRUE.equals(userDetailsForCreation.isNotifyViaEmail())) {
            password = UUID.randomUUID().toString();
        }
        DefaultUser user = new DefaultUser(userDetailsForCreation.getUserName(), userDetailsForCreation.getFullName(), userDetailsForCreation.getEmail());
        try {
            ConfluenceUser newlyCreatedUser = this.userAccessorInternal.createUser((User)user, Credential.unencrypted((String)password));
            this.userAccessorInternal.addMembership(this.userAccessorInternal.getNewUserDefaultGroupName(), userDetailsForCreation.getUserName());
            this.sendNotificationViaEmail(userDetailsForCreation, (User)newlyCreatedUser);
            com.atlassian.confluence.api.model.people.UserKey userKey = new com.atlassian.confluence.api.model.people.UserKey();
            userKey.setUserKey(newlyCreatedUser.getKey().getStringValue());
            return userKey;
        }
        catch (LicenseUserLimitExceededException e) {
            SimpleValidationResults.paymentRequiredResult((String)"License check failed", (Object[])new Object[0]).throwIfNotSuccessful();
        }
        catch (RuntimeException e) {
            log.error("Failed to create user: {}", (Object)user, (Object)e);
            SimpleValidationResults.invalidResult((String)("Failed to create the user " + userDetailsForCreation.getUserName() + ". Check your server logs for more information"), (Object[])new Object[0]).throwIfNotSuccessful();
        }
        return null;
    }

    private void sendNotificationViaEmail(UserDetailsForCreation userDetailsForCreation, User newlyCreatedUser) {
        if (Boolean.TRUE.equals(userDetailsForCreation.isNotifyViaEmail())) {
            AdminAddedUserEvent addedUserEvent = new AdminAddedUserEvent(newlyCreatedUser);
            this.eventPublisher.publish((Object)addedUserEvent);
        }
    }

    public void setCurrentUser(String userName) {
        AuthenticatedUserThreadLocal.setUser((User)this.userAccessorInternal.getUserByName(userName));
    }

    public Person getCurrentUser(Expansion ... expansions) {
        return this.personFactory.forCurrentUser(new Expansions(expansions));
    }

    public PersonService.PersonFinder find(Expansion ... expansions) {
        this.validator().validateView().throwIfNotSuccessful("User not permitted to view user profiles");
        PersonFinderImpl finder = new PersonFinderImpl(expansions);
        return (PersonService.PersonFinder)this.finderProxyFactory.createProxy((Object)finder, PersonService.PersonFinder.class);
    }

    public PageResponse<Person> fetchActiveUsers(PageRequest request) {
        this.validator().validateConfluenceAdmin().throwIfNotSuccessful("This endpoint is only available to Confluence administrators");
        SearchQuery activeUserQuery = ActiveUserInfoQuery.getInstance().expand();
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)PaginationLimits.users());
        DefaultSearch defaultSearch = ((DefaultSearch.Builder)((DefaultSearch.Builder)((DefaultSearch.Builder)((DefaultSearch.Builder)((DefaultSearch.Builder)DefaultSearch.builder().indices(List.of(Index.CONTENT))).query(activeUserQuery)).sort((SearchSort)new FieldSort("lastLogin", SearchSort.Type.STRING, SearchSort.Order.ASCENDING))).startOffset(limitedRequest.getStart())).limit(limitedRequest.getLimit() + 1)).build();
        try {
            SearchResults results = this.searchIndexAccessor.search((ISearch)defaultSearch, null);
            LinkedList personList = new LinkedList();
            LinkedList<UserKey> userKeys = new LinkedList<UserKey>();
            for (SearchResult result : results.getAll()) {
                userKeys.add(new UserKey(result.getField("userKey")));
            }
            List foundUsers = this.userAccessorInternal.getUsersByUserKeys(userKeys);
            userKeys.forEach(userKey -> foundUsers.stream().filter(u -> u.getKey().equals(userKey)).findFirst().ifPresent(user -> personList.add(this.personFactory.forUserWithLoginInfo((ConfluenceUser)user, ExpansionsParser.parseAsExpansions((String)"lastLogin")))));
            return PageResponseImpl.filteredResponse((LimitedRequest)limitedRequest, personList, null);
        }
        catch (InvalidSearchException ex) {
            throw new InternalServerException("Error fetching users", (Throwable)ex);
        }
    }

    public void disable(String username) {
        this.validator().validateDisable(username).throwIfNotSuccessful();
        ConfluenceUser user = this.userAccessorInternal.getUserByName(username);
        this.userAccessorInternal.deactivateUser((User)user);
    }

    public void enable(String username) {
        this.validator().validateEnable(username).throwIfNotSuccessful();
        ConfluenceUser user = this.userAccessorInternal.getUserByName(username);
        this.userAccessorInternal.reactivateUser((User)user);
    }

    public void update(UserDetailsForUpdate userDetailsForUpdate) {
        this.validator().validateUpdateUser(userDetailsForUpdate).throwIfNotSuccessful();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ConfluenceUser givenUser = this.userAccessorInternal.getUserByName(currentUser.getName());
        this.updateUser(givenUser, userDetailsForUpdate);
    }

    private void updateUser(ConfluenceUser givenUser, UserDetailsForUpdate userDetailsForUpdate) {
        DefaultUser userTemplate = new DefaultUser((User)givenUser);
        boolean needUpdate = false;
        if (userDetailsForUpdate.getFullName() != null && !userDetailsForUpdate.getFullName().equals(givenUser.getFullName())) {
            userTemplate.setFullName(userDetailsForUpdate.getFullName());
            needUpdate = true;
        }
        if (userDetailsForUpdate.getEmail() != null && !userDetailsForUpdate.getEmail().equals(givenUser.getEmail())) {
            userTemplate.setEmail(userDetailsForUpdate.getEmail());
            needUpdate = true;
        }
        if (needUpdate) {
            try {
                this.userAccessorInternal.saveUser((User)userTemplate);
            }
            catch (RuntimeException e) {
                log.error("Error occurred when updating user", (Throwable)e);
                SimpleValidationResults.invalidResult((String)("Error updating user " + givenUser.getName() + ". Check your server logs for more information"), (Object[])new Object[0]).throwIfNotSuccessful();
            }
        }
    }

    public void update(String username, UserDetailsForUpdate userDetailsForUpdate) {
        this.validator().validateUpdateUser(username, userDetailsForUpdate).throwIfNotSuccessful();
        ConfluenceUser givenUser = this.userAccessorInternal.getUserByName(username);
        this.updateUser(givenUser, userDetailsForUpdate);
    }

    public LongTaskSubmission delete(Person personToDelete) {
        this.validator().validateDelete(personToDelete).throwIfNotSuccessful();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ConfluenceUser userToDelete = Objects.requireNonNull(this.userAccessorInternal.getUserByKey((UserKey)personToDelete.optionalUserKey().orElse(null)));
        DeleteUserLongRunningTask deleteUserLongRunningTask = new DeleteUserLongRunningTask(this.i18NBeanFactory.getI18NBean(), this.settingsService.getGlobalSettings(), this.userAccessorInternal, userToDelete, this.eventPublisher);
        LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask(currentUser, (LongRunningTask)deleteUserLongRunningTask);
        LongTaskId taskId = longRunningTaskId.asLongTaskId();
        return this.longTaskFactory.buildSubmission(taskId);
    }

    public PersonService.PersonSearcher search() {
        this.validator().validateView().throwIfNotSuccessful("User not permitted to view user profiles");
        PersonSearcherImpl searcher = new PersonSearcherImpl();
        return (PersonService.PersonSearcher)this.finderProxyFactory.createProxy((Object)searcher, PersonService.PersonSearcher.class);
    }

    public void addMembership(String username, String groupName) {
        this.validator().validateAddMembership(username, groupName).throwIfNotSuccessful();
        ConfluenceUser user = this.userAccessorInternal.getUserByName(username);
        Group group = this.userAccessorInternal.getGroup(groupName);
        this.userAccessorInternal.addMembership(group, (User)user);
    }

    public void removeMembership(String username, String groupName) {
        this.validator().validateRemoveMembership(username, groupName).throwIfNotSuccessful();
        ConfluenceUser user = this.userAccessorInternal.getUserByName(username);
        Group group = this.userAccessorInternal.getGroup(groupName);
        this.userAccessorInternal.removeMembership(group, (User)user);
    }

    public void changeUserPassword(String userName, String newPass) {
        this.validator().validateChangePassword(userName, newPass).throwIfNotSuccessful("Unable to change user password");
        ConfluenceUser givenUser = this.userAccessorInternal.getUserByName(userName);
        try {
            this.userAccessorInternal.alterPassword((User)givenUser, newPass);
        }
        catch (EntityException | RuntimeException e) {
            log.error("Error occurred when changing current user's password", e);
            SimpleValidationResults.invalidResult((String)("Error changing password for user " + userName + ". Check your server logs for more information"), (Object[])new Object[0]).throwIfNotSuccessful();
        }
    }

    public void changeMyPassword(PasswordChangeDetails passwordChangeDetails) {
        this.validator().validateChangeMyPassword(passwordChangeDetails).throwIfNotSuccessful("Unable to change current user's password");
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            this.userAccessorInternal.alterPassword((User)currentUser, passwordChangeDetails.getNewPassword());
        }
        catch (EntityException | RuntimeException e) {
            log.error("Error occurred when changing current user's password", e);
            SimpleValidationResults.invalidResult((String)("Error changing password for user " + currentUser.getName() + ". Check your server logs for more information"), (Object[])new Object[0]).throwIfNotSuccessful();
        }
    }

    public PersonService.Validator validator() {
        return new ValidatorImpl();
    }

    private Optional<ValidationResult> performMandatoryFieldChecks(User user, Group group, String username, String groupName) {
        if (null == user && null == group) {
            return Optional.of(SimpleValidationResults.notFoundResult((String)String.format("User %s and group %s not found", username, groupName), (Object[])new Object[0]));
        }
        if (null == user) {
            return Optional.of(SimpleValidationResults.notFoundResult((String)String.format("User %s not found", username), (Object[])new Object[0]));
        }
        if (null == group) {
            return Optional.of(SimpleValidationResults.notFoundResult((String)String.format("Group %s not found", groupName), (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public class PersonFinderImpl
    extends AbstractFinder<Person>
    implements PersonService.PersonFinder {
        private UserKey userKey;
        private String username;
        private com.atlassian.confluence.api.model.people.Group memberOfGroup;
        private boolean hasUserKeyOrUsername;

        public PersonFinderImpl(Expansion ... expansions) {
            super(expansions);
            this.hasUserKeyOrUsername = false;
        }

        public PersonService.PersonFinder withUserKey(UserKey userKey) {
            this.userKey = userKey;
            this.hasUserKeyOrUsername = true;
            return this;
        }

        public PersonService.PersonFinder withUsername(String username) {
            if (this.userKey != null) {
                throw new BadRequestException("Only one of username or userkey can be provided");
            }
            this.username = username;
            this.hasUserKeyOrUsername = true;
            return this;
        }

        public PersonService.PersonFinder withMembershipOf(com.atlassian.confluence.api.model.people.Group group) {
            PersonServiceImpl.this.validator().validateBrowseAllGroupMembers().throwIfNotSuccessful();
            this.memberOfGroup = group;
            return this;
        }

        public PageResponse<Person> fetchMany(PageRequest request) {
            try {
                LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)PaginationLimits.users());
                if (this.memberOfGroup == null) {
                    return PersonServiceImpl.this.paginationService.performPaginationRequest(limitedRequest, (PaginationBatch)new PaginationBatch<ConfluenceUser>(){

                        public PageResponse<ConfluenceUser> apply(LimitedRequest batchLimitedRequest) {
                            return PersonServiceImpl.this.userAccessorInternal.getUsers(batchLimitedRequest);
                        }

                        public boolean performsFiltering() {
                            return false;
                        }
                    }, item -> PersonServiceImpl.this.personFactory.buildFrom((ConfluenceUser)item, this.getExpansions()));
                }
                Pager userNames = PersonServiceImpl.this.groupManager.getMemberNames((Group)new DefaultGroup(this.memberOfGroup.getName()));
                return PagerToPageResponseHelper.createFromPager((Pager)userNames, (LimitedRequest)limitedRequest, username -> PersonServiceImpl.this.personFactory.buildFrom(PersonServiceImpl.this.userAccessorInternal.getUserByName(username), this.getExpansions()));
            }
            catch (EntityException ex) {
                throw new InternalServerException("Error fetching users", (Throwable)ex);
            }
        }

        public Optional<Person> fetch() {
            if (this.hasUserKeyOrUsername) {
                ConfluenceUser user = null;
                if (this.userKey == null && this.username == null) {
                    return Optional.ofNullable(PersonServiceImpl.this.personFactory.anonymous());
                }
                if (this.userKey != null) {
                    user = PersonServiceImpl.this.userAccessorInternal.getUserByKey(this.userKey);
                } else if (this.username != null) {
                    user = PersonServiceImpl.this.userAccessorInternal.getUserByName(this.username);
                }
                if (user == null || this.memberOfGroup != null && !PersonServiceImpl.this.userAccessorInternal.hasMembership(this.memberOfGroup.getName(), user.getName())) {
                    return Optional.empty();
                }
                return Optional.ofNullable(PersonServiceImpl.this.personFactory.forUser(user, this.getExpansions()));
            }
            return Optional.empty();
        }
    }

    public class PersonSearcherImpl
    implements PersonService.PersonSearcher {
        private String username;
        private boolean searchingUnsyncedUsers = false;

        public PersonService.PersonSearcher forUnsyncedUsers(String username) {
            this.username = username;
            this.searchingUnsyncedUsers = true;
            return this;
        }

        public PageResponse<Person> fetchMany(PageRequest request) {
            LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)PaginationLimits.users());
            try {
                if (this.username != null && this.searchingUnsyncedUsers) {
                    return PagerToPageResponseHelper.createFromPager((Pager)PersonServiceImpl.this.userAccessorInternal.searchUnsyncedUsers(this.username), (LimitedRequest)limitedRequest, PersonServiceImpl.this.personFactory::forUser);
                }
            }
            catch (EntityException ex) {
                throw new InternalServerException("Error fetching users", (Throwable)ex);
            }
            return PageResponseImpl.empty((boolean)false);
        }
    }

    private class ValidatorImpl
    implements PersonService.Validator {
        private static final String ENGLISH_ANONYMOUS_USER = "anonymous";

        private ValidatorImpl() {
        }

        public ValidationResult validateView() {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (!(PersonServiceImpl.this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL") || PersonServiceImpl.this.permissionManager.hasPermission(currentUser, Permission.VIEW, User.class) || PersonServiceImpl.this.serviceAccountPermissionManager.isServiceAccount(currentUser))) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateBrowseAllGroupMembers() {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (!PersonServiceImpl.this.permissionManager.hasPermission(currentUser, Permission.VIEW, com.atlassian.confluence.api.model.people.Group.class)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateDisable(String username) {
            ConfluenceUser user = PersonServiceImpl.this.userAccessorInternal.getUserByName(username);
            if (null == user) {
                return SimpleValidationResults.notFoundResult((String)("User not found :" + username), (Object[])new Object[0]);
            }
            if (AuthenticatedUserThreadLocal.get() == user) {
                return SimpleValidationResult.FORBIDDEN;
            }
            if (!PersonServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.SET_PERMISSIONS, (Object)user)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateEnable(String username) {
            ConfluenceUser user = PersonServiceImpl.this.userAccessorInternal.getUserByName(username);
            if (null == user) {
                return SimpleValidationResults.notFoundResult((String)("User not found :" + username), (Object[])new Object[0]);
            }
            if (!PersonServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.SET_PERMISSIONS, (Object)user)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateDelete(Person personToDelete) {
            if (personToDelete == null) {
                throw new NotFoundException();
            }
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            ConfluenceUser userToDelete = PersonServiceImpl.this.userAccessorInternal.getUserByKey((UserKey)personToDelete.optionalUserKey().orElse(null));
            try {
                if (currentUser != null && currentUser.equals((Object)userToDelete) || !PersonServiceImpl.this.permissionManager.hasPermission(currentUser, Permission.REMOVE, (Object)userToDelete)) {
                    return SimpleValidationResult.FORBIDDEN;
                }
                if (!PersonServiceImpl.this.userAccessorInternal.isUnsyncedUser(userToDelete) && !PersonServiceImpl.this.userAccessorInternal.isUserRemovable((User)userToDelete)) {
                    return SimpleValidationResult.builder().authorized(true).addError("User is not removable.", new Object[0]).build();
                }
                return SimpleValidationResult.VALID;
            }
            catch (EntityException e) {
                log.error("Error determining whether or not user is removable", (Throwable)e);
                return SimpleValidationResult.builder().addError(e.getMessage(), new Object[0]).build();
            }
        }

        public ValidationResult validateAddMembership(String username, String groupName) {
            Group group;
            ConfluenceUser user = PersonServiceImpl.this.userAccessorInternal.getUserByName(username);
            Optional<ValidationResult> mandatoryFieldValidation = PersonServiceImpl.this.performMandatoryFieldChecks((User)user, group = PersonServiceImpl.this.userAccessorInternal.getGroup(groupName), username, groupName);
            if (mandatoryFieldValidation.isPresent()) {
                return mandatoryFieldValidation.get();
            }
            if (!PersonServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)group)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateRemoveMembership(String username, String groupName) {
            Group group;
            ConfluenceUser user = PersonServiceImpl.this.userAccessorInternal.getUserByName(username);
            Optional<ValidationResult> mandatoryFieldValidation = PersonServiceImpl.this.performMandatoryFieldChecks((User)user, group = PersonServiceImpl.this.userAccessorInternal.getGroup(groupName), username, groupName);
            if (mandatoryFieldValidation.isPresent()) {
                return mandatoryFieldValidation.get();
            }
            if (!PersonServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)group)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            HashSet<String> adminGroups = new HashSet<String>();
            for (SpacePermission spacePermission : PersonServiceImpl.this.spacePermissionManager.getGlobalPermissions()) {
                if (!"SYSTEMADMINISTRATOR".equals(spacePermission.getType()) || !spacePermission.isGroupPermission()) continue;
                adminGroups.add(spacePermission.getGroup());
            }
            if (adminGroups.contains(groupName) && adminGroups.size() == 1 && AuthenticatedUserThreadLocal.get() == user) {
                return SimpleValidationResult.builder().addError("To prevent Confluence being left without any administrators, you cannot remove yourself from the last remaining group(s) that allow you to ADMINISTER or USE confluence. If you wish to revoke your administrator access, have another administrator remove you.", new Object[0]).build();
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateConfluenceAdmin() {
            if (!PersonServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateUserCreate(UserDetailsForCreation userDetailsForCreation) {
            if (!PersonServiceImpl.this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), PermissionManager.TARGET_APPLICATION, User.class)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            ValidationResult userNameValidationResult = this.validateUserName(userDetailsForCreation);
            if (!SimpleValidationResult.VALID.equals((Object)userNameValidationResult)) {
                return userNameValidationResult;
            }
            ValidationResult fullNameValidationResult = this.validateFullName(userDetailsForCreation.getFullName());
            if (!SimpleValidationResult.VALID.equals((Object)fullNameValidationResult)) {
                return fullNameValidationResult;
            }
            ValidationResult emailValidationResult = this.validateEmail(userDetailsForCreation.getEmail());
            if (!SimpleValidationResult.VALID.equals((Object)emailValidationResult)) {
                return emailValidationResult;
            }
            ValidationResult passwordValidationResult = this.validatePassword(userDetailsForCreation);
            if (!SimpleValidationResult.VALID.equals((Object)passwordValidationResult)) {
                return passwordValidationResult;
            }
            return SimpleValidationResult.VALID;
        }

        private ValidationResult validateUserName(UserDetailsForCreation userDetailsForCreation) {
            String userName = userDetailsForCreation.getUserName();
            if (StringUtils.isBlank((CharSequence)userName)) {
                return SimpleValidationResults.invalidResult((String)"userName cannot be null or blank", (Object[])new Object[0]);
            }
            if (StringUtils.containsAny((CharSequence)userName, (CharSequence)"\\,+<>'\"")) {
                return SimpleValidationResults.invalidResult((String)"userName cannot contain the characters \\ or , or + or < or > or quotes", (Object[])new Object[0]);
            }
            if (!userName.matches("[^\\s]+")) {
                return SimpleValidationResults.invalidResult((String)"userName cannot contain any whitespace characters", (Object[])new Object[0]);
            }
            if (ENGLISH_ANONYMOUS_USER.equalsIgnoreCase(userName) || PersonServiceImpl.this.i18NBeanFactory.getI18NBean().getText("anonymous.name").equalsIgnoreCase(userName)) {
                return SimpleValidationResults.invalidResult((String)"This userName is reserved for use by Confluence", (Object[])new Object[0]);
            }
            if (!userName.equals(userName.toLowerCase())) {
                return SimpleValidationResults.invalidResult((String)"The userName must be in lower case", (Object[])new Object[0]);
            }
            if (PersonServiceImpl.this.confluenceUserResolver.getUserByName(userName) != null) {
                return SimpleValidationResults.conflictResult((String)"A user with this userName already exists.", (Object[])new Object[0]);
            }
            return SimpleValidationResult.VALID;
        }

        private ValidationResult validateFullName(String fullName) {
            if (StringUtils.isBlank((CharSequence)fullName)) {
                return SimpleValidationResults.invalidResult((String)"fullName cannot be null or blank", (Object[])new Object[0]);
            }
            if (StringUtils.containsAny((CharSequence)fullName, (CharSequence)"<>")) {
                return SimpleValidationResults.invalidResult((String)"fullName cannot contain characters < or >", (Object[])new Object[0]);
            }
            if (PersonServiceImpl.this.i18NBeanFactory.getI18NBean().getText("anonymous.name").equalsIgnoreCase(fullName) || ENGLISH_ANONYMOUS_USER.equalsIgnoreCase(fullName)) {
                return SimpleValidationResults.invalidResult((String)"This fullName is reserved for use by Confluence", (Object[])new Object[0]);
            }
            return SimpleValidationResult.VALID;
        }

        private ValidationResult validateEmail(String email) {
            if (StringUtils.isBlank((CharSequence)email) || !EmailValidator.getInstance().isValid(email)) {
                return SimpleValidationResults.invalidResult((String)"Invalid email address", (Object[])new Object[0]);
            }
            return SimpleValidationResult.VALID;
        }

        private ValidationResult validatePassword(UserDetailsForCreation userDetailsForCreation) {
            String password = userDetailsForCreation.getPassword();
            if (Boolean.TRUE.equals(userDetailsForCreation.isNotifyViaEmail()) && !StringUtils.isBlank((CharSequence)password)) {
                return SimpleValidationResults.invalidResult((String)"Cannot specify a password if notifyViaEmail is chosen", (Object[])new Object[0]);
            }
            if (Boolean.FALSE.equals(userDetailsForCreation.isNotifyViaEmail()) && StringUtils.isBlank((CharSequence)password)) {
                return SimpleValidationResults.invalidResult((String)"password cannot be null or empty", (Object[])new Object[0]);
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateChangePassword(String userName, String password) {
            if (StringUtils.isBlank((CharSequence)userName)) {
                return SimpleValidationResults.invalidResult((String)"User name cannot be null or empty.", (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)password)) {
                return SimpleValidationResults.invalidResult((String)"newPassword cannot be null or empty.", (Object[])new Object[0]);
            }
            ConfluenceUser givenUser = PersonServiceImpl.this.userAccessorInternal.getUserByName(userName);
            if (givenUser == null) {
                return SimpleValidationResults.notFoundResult((String)("User " + userName + " not found"), (Object[])new Object[0]);
            }
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (!PersonServiceImpl.this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)givenUser)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateChangeMyPassword(PasswordChangeDetails passwordChangeDetails) {
            if (StringUtils.isBlank((CharSequence)passwordChangeDetails.getNewPassword())) {
                return SimpleValidationResults.invalidResult((String)"newPassword cannot be null or empty.", (Object[])new Object[0]);
            }
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (currentUser == null) {
                return SimpleValidationResults.notAuthenticatedResult((String)"User not authenticated", (Object[])new Object[0]);
            }
            if (PersonServiceImpl.this.loginManager.requiresElevatedSecurityCheck(currentUser.getName())) {
                return SimpleValidationResults.forbiddenResult((String)"User has exceeded the number of allowed failed logins. Please ask your administrator to reset the failed login count", (Object[])new Object[0]);
            }
            if (!PersonServiceImpl.this.userAccessorInternal.authenticate(currentUser.getName(), passwordChangeDetails.getOldPassword())) {
                PersonServiceImpl.this.loginManager.onFailedLoginAttempt(currentUser.getName(), (HttpServletRequest)null);
                return SimpleValidationResults.forbiddenResult((String)"The oldPassword was incorrect. Please try again.", (Object[])new Object[0]);
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateUpdateUser(UserDetailsForUpdate userDetailsForUpdate) {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            ValidationResult validatorResult = this.validateUpdateUserImpl(currentUser, userDetailsForUpdate);
            if (validatorResult != SimpleValidationResult.VALID) {
                return validatorResult;
            }
            if (userDetailsForUpdate.getEmail() != null) {
                if (userDetailsForUpdate.getCurrentPassword() == null) {
                    return SimpleValidationResults.invalidResult((String)"currentPassword cannot be null or empty.", (Object[])new Object[0]);
                }
                if (!PersonServiceImpl.this.userAccessorInternal.authenticate(currentUser.getName(), userDetailsForUpdate.getCurrentPassword())) {
                    PersonServiceImpl.this.loginManager.onFailedLoginAttempt(currentUser.getName(), (HttpServletRequest)null);
                    return SimpleValidationResults.forbiddenResult((String)"The currentPassword was incorrect. Please try again.", (Object[])new Object[0]);
                }
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateUpdateUser(String username, UserDetailsForUpdate userDetailsForUpdate) {
            if (StringUtils.isBlank((CharSequence)username)) {
                return SimpleValidationResults.invalidResult((String)"username cannot be null or empty.", (Object[])new Object[0]);
            }
            ConfluenceUser givenUser = PersonServiceImpl.this.userAccessorInternal.getUserByName(username);
            return this.validateUpdateUserImpl(givenUser, userDetailsForUpdate);
        }

        private ValidationResult validateUpdateUserImpl(ConfluenceUser user, UserDetailsForUpdate userDetailsForUpdate) {
            ValidationResult fullNameValidationResult;
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (currentUser == null) {
                return SimpleValidationResults.notAuthenticatedResult((String)"User not authenticated", (Object[])new Object[0]);
            }
            if (userDetailsForUpdate == null) {
                return SimpleValidationResults.invalidResult((String)"Body required", (Object[])new Object[0]);
            }
            if (user == null) {
                return SimpleValidationResults.notFoundResult((String)"Given user not found", (Object[])new Object[0]);
            }
            if (user != currentUser && !PersonServiceImpl.this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)user)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            if (userDetailsForUpdate.getFullName() != null && !SimpleValidationResult.VALID.equals((Object)(fullNameValidationResult = this.validateFullName(userDetailsForUpdate.getFullName())))) {
                return fullNameValidationResult;
            }
            if (userDetailsForUpdate.getEmail() != null) {
                ValidationResult emailValidationResult = this.validateEmail(userDetailsForUpdate.getEmail());
                if (!SimpleValidationResult.VALID.equals((Object)emailValidationResult)) {
                    return emailValidationResult;
                }
                if (PersonServiceImpl.this.loginManager.requiresElevatedSecurityCheck(user.getName())) {
                    return SimpleValidationResults.forbiddenResult((String)"User has exceeded the number of allowed failed logins. Please ask your administrator to reset the failed login count", (Object[])new Object[0]);
                }
            }
            return SimpleValidationResult.VALID;
        }
    }
}

