/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.factory.Fauxpansions;
import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.ModelFactory;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentSelector;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.NavigablePageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.SubjectType;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.ContentConvertible;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContentRestrictionFactory
implements ModelFactory<ContentPermissionSet, ContentRestriction> {
    private final PersonFactory personFactory;
    private final Supplier<ContentFactory> contentFactorySupplier;
    private final NavigationService navigationService;
    private static final ImmutableBiMap<OperationKey, String> opKeyToPermissionBiMap = ImmutableBiMap.of((Object)OperationKey.READ, (Object)"View", (Object)OperationKey.UPDATE, (Object)"Edit");

    public ContentRestrictionFactory(PersonFactory personFactory, Supplier<ContentFactory> contentFactorySupplier, NavigationService navigationService) {
        this.personFactory = personFactory;
        this.contentFactorySupplier = contentFactorySupplier;
        this.navigationService = navigationService;
    }

    public ContentRestriction buildFrom(@NonNull ContentPermissionSet set, LimitedRequest limitedRequest, Expansions expansions) {
        Preconditions.checkNotNull((Object)set);
        OperationKey operationKey = ContentRestrictionFactory.determineOpKey(set.getType());
        Fauxpansions contentExpansions = Fauxpansions.fauxpansions(expansions, "content");
        Fauxpansions restrictionsExpansions = Fauxpansions.fauxpansions(expansions, "restrictions");
        Fauxpansions inheritedViewRestrictionsExpansions = Fauxpansions.fauxpansions(expansions, "relevantViewRestrictions");
        ContentEntityObject ceo = set.getOwningContent();
        Reference contentRef = contentExpansions.canExpand() ? Reference.to((Object)this.contentFactorySupplier.get().buildFrom(ceo, contentExpansions.getSubExpansions())) : (ceo instanceof ContentConvertible && ((ContentConvertible)ceo).shouldConvertToContent() ? Content.buildReference((ContentSelector)ceo.getSelector()) : Content.buildReference((ContentSelector)ContentSelector.from((Content)Content.builder().id(ceo.getContentId()).build())));
        ContentRestriction.ContentRestrictionBuilder restrictionBuilder = ContentRestriction.builder().content(contentRef).operation(operationKey);
        if (set.getLastModificationDate() != null) {
            restrictionBuilder.latestModificationDate(OffsetDateTime.ofInstant(set.getLastModificationDate().toInstant(), ZoneId.systemDefault()));
        }
        if (restrictionsExpansions.canExpand()) {
            Navigation.Builder navBuilder = this.navigationService.createNavigation().content(contentRef).restrictionByOperation().operation(operationKey);
            restrictionBuilder.restrictions(this.buildRestrictions(set, limitedRequest, restrictionsExpansions.getSubExpansions(), navBuilder));
        } else if (inheritedViewRestrictionsExpansions.canExpand()) {
            Navigation.Builder navBuilder = this.navigationService.createNavigation().content(contentRef).restrictionByOperation().operation(operationKey);
            restrictionBuilder.restrictions(this.buildRestrictionsForRelevantViewRestrictions(set, limitedRequest, inheritedViewRestrictionsExpansions.getSubExpansions(), navBuilder));
        } else {
            restrictionBuilder.restrictions(BuilderUtils.collapsedMap());
        }
        return restrictionBuilder.build();
    }

    private Map<SubjectType, PageResponse<Subject>> buildRestrictionsForRelevantViewRestrictions(ContentPermissionSet set, LimitedRequest limitedRequest, Expansions expansions, Navigation.Builder navBuilder) {
        int limit = Math.min(limitedRequest.getLimit(), PaginationLimits.relevantViewRestrictionsExpansion());
        int start = 0;
        ModelMapBuilder restrictionsModelMapBuilder = ModelMapBuilder.newInstance();
        HashMap<SubjectType, List> rawRestrictions = new HashMap<SubjectType, List>();
        for (ContentPermission contentPermission : set) {
            SubjectType subjectType = contentPermission.isUserPermission() ? SubjectType.USER : SubjectType.GROUP;
            List subjects = rawRestrictions.computeIfAbsent(subjectType, st -> new ArrayList());
            if (subjects.size() == limit + 1) continue;
            if (SubjectType.USER.equals((Object)subjectType) && contentPermission.getUserSubject() != null) {
                subjects.add(this.personFactory.forUser(contentPermission.getUserSubject(), Expansions.EMPTY, false));
                continue;
            }
            if (SubjectType.GROUP.equals((Object)subjectType) && contentPermission.getGroupName() != null) {
                subjects.add(new Group(contentPermission.getGroupName()));
                continue;
            }
            String err = "unsupported SubjectType or malformed contentPermissionObject";
            throw new ServiceException("unsupported SubjectType or malformed contentPermissionObject", (Throwable)new IllegalArgumentException("unsupported SubjectType or malformed contentPermissionObject"));
        }
        for (Map.Entry mapEntry : rawRestrictions.entrySet()) {
            List subjects = (List)mapEntry.getValue();
            NavigablePageResponseImpl.Builder<Subject, PageResponse<Subject>> navigablePageResponseBuilder = ContentRestrictionFactory.getNewSubjectNavigablePageResponseBuilder(limitedRequest, navBuilder, subjects, start, limit);
            restrictionsModelMapBuilder.put((Object)((SubjectType)mapEntry.getKey()), (Object)navigablePageResponseBuilder.build());
        }
        return restrictionsModelMapBuilder.build();
    }

    private Map<SubjectType, PageResponse<Subject>> buildRestrictions(ContentPermissionSet set, LimitedRequest limitedRequest, Expansions expansions, Navigation.Builder navBuilder) {
        List subjects;
        int limit = limitedRequest.getLimit();
        int start = limitedRequest.getStart();
        HashMap<SubjectType, List> rawRestrictions = new HashMap<SubjectType, List>();
        for (ContentPermission contentPermission : set) {
            SubjectType subjectType = contentPermission.isUserPermission() ? SubjectType.USER : SubjectType.GROUP;
            if (!expansions.canExpand(subjectType.toString()) || (subjects = rawRestrictions.computeIfAbsent(subjectType, st -> new ArrayList())).size() == limit + 1) continue;
            if (SubjectType.USER.equals((Object)subjectType) && contentPermission.getUserSubject() != null) {
                subjects.add(this.personFactory.forUser(contentPermission.getUserSubject()));
                continue;
            }
            if (SubjectType.GROUP.equals((Object)subjectType) && contentPermission.getGroupName() != null) {
                subjects.add(new Group(contentPermission.getGroupName()));
                continue;
            }
            String err = "unsupported SubjectType or malformed contentPermissionObject";
            throw new ServiceException("unsupported SubjectType or malformed contentPermissionObject", (Throwable)new IllegalArgumentException("unsupported SubjectType or malformed contentPermissionObject"));
        }
        ModelMapBuilder restrictionsModelMapBuilder = ModelMapBuilder.newInstance();
        for (SubjectType subjectType : SubjectType.VALUES) {
            if (expansions.canExpand(subjectType.toString())) {
                subjects = (List)rawRestrictions.get(subjectType);
                NavigablePageResponseImpl.Builder<Subject, PageResponse<Subject>> pageResponseBuilder = ContentRestrictionFactory.getNewSubjectNavigablePageResponseBuilder(limitedRequest, navBuilder, subjects, start, limit);
                restrictionsModelMapBuilder.put((Object)subjectType, (Object)pageResponseBuilder.build());
                continue;
            }
            restrictionsModelMapBuilder.addCollapsedEntry((Object)subjectType);
        }
        return restrictionsModelMapBuilder.build();
    }

    private static RestList.Builder<Subject> getNewSubjectRestListBuilder(LimitedRequest limitedRequest, Navigation.Builder navBuilder, List<Subject> subjects, int start, int limit) {
        RestList.Builder pageResponseBuilder = RestList.newRestList();
        pageResponseBuilder.pageRequest((PageRequest)new SimplePageRequest(limitedRequest)).navigationAware(navBuilder);
        if (subjects != null && start < subjects.size()) {
            List<Subject> subList = subjects.subList(start, Math.min(start + limit, subjects.size()));
            boolean hasMore = subjects.size() > start + limit;
            pageResponseBuilder.results(subList, hasMore);
        }
        return pageResponseBuilder;
    }

    private static NavigablePageResponseImpl.Builder<Subject, PageResponse<Subject>> getNewSubjectNavigablePageResponseBuilder(LimitedRequest limitedRequest, Navigation.Builder navBuilder, List<Subject> subjects, int start, int limit) {
        NavigablePageResponseImpl.Builder navigablePageResponseBuilder = new NavigablePageResponseImpl.Builder();
        LimitedRequest newLimitedRequest = LimitedRequestImpl.create((int)limitedRequest.getStart(), (int)limitedRequest.getLimit(), (int)limit);
        navigablePageResponseBuilder.pageRequest(newLimitedRequest);
        navigablePageResponseBuilder.navigationBuilder(navBuilder);
        if (subjects != null && start < subjects.size()) {
            List<Subject> subList = subjects.subList(start, Math.min(start + limit, subjects.size()));
            boolean hasMore = subjects.size() > start + limit;
            navigablePageResponseBuilder.addAll(subList);
            navigablePageResponseBuilder.hasMore(hasMore);
        }
        return navigablePageResponseBuilder;
    }

    public ContentRestriction buildFrom(ContentPermissionSet hibernateObject, Expansions expansions) {
        return this.buildFrom(hibernateObject, LimitedRequestImpl.create((int)PaginationLimits.restrictionSubjects()), expansions);
    }

    public static OperationKey determineOpKey(String permissionType) {
        OperationKey opKeyFromPreDefinedMap = (OperationKey)opKeyToPermissionBiMap.inverse().get((Object)permissionType);
        if (opKeyFromPreDefinedMap != null) {
            return opKeyFromPreDefinedMap;
        }
        return OperationKey.valueOf((String)permissionType);
    }

    public static Optional<String> extractPermissionType(OperationKey key) {
        return Optional.ofNullable((String)opKeyToPermissionBiMap.get((Object)key));
    }

    public static ImmutableSet<OperationKey> getSupportedOperationKeys() {
        return opKeyToPermissionBiMap.keySet();
    }
}

