/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.TargetType;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.google.common.collect.ImmutableBiMap;
import org.apache.commons.lang3.StringUtils;

public class DefaultGlobalPermissionOperationKeyConverter
implements SpacePermissionOperationKeyConverter {
    private final ImmutableBiMap<OperationDescription, String> opKeyToPermissionBiMap = new ImmutableBiMap.Builder().put((Object)OperationDescription.builder().operationKey(OperationKey.USE).targetType(TargetType.APPLICATION).build(), (Object)"USECONFLUENCE").put((Object)OperationDescription.builder().operationKey(OperationKey.CREATE).targetType(TargetType.PERSONAL_SPACE).build(), (Object)"PERSONALSPACE").put((Object)OperationDescription.builder().operationKey(OperationKey.CREATE).targetType(TargetType.SPACE).build(), (Object)"CREATESPACE").put((Object)OperationDescription.builder().operationKey(OperationKey.ADMINISTER).targetType(TargetType.APPLICATION).build(), (Object)"ADMINISTRATECONFLUENCE").put((Object)OperationDescription.builder().operationKey(OperationKey.ADMINISTER).targetType(TargetType.SYSTEM).build(), (Object)"SYSTEMADMINISTRATOR").put((Object)OperationDescription.builder().operationKey(OperationKey.READ).targetType(TargetType.USER).build(), (Object)"VIEWUSERPROFILES").put((Object)OperationDescription.builder().operationKey(OperationKey.USE_UNLICENSED).targetType(TargetType.APPLICATION).build(), (Object)"LIMITEDUSECONFLUENCE").put((Object)OperationDescription.builder().operationKey(OperationKey.BROWSE_ALL_GROUP).targetType(TargetType.APPLICATION).build(), (Object)"BROWSEALLGROUPMEMBERS").build();

    private String tryConvertBuiltIn(OperationDescription operation) {
        return (String)this.opKeyToPermissionBiMap.get((Object)operation);
    }

    public OperationDescription toOperation(String spacePermission) {
        OperationDescription builtIn = (OperationDescription)this.opKeyToPermissionBiMap.inverse().get((Object)spacePermission.toUpperCase());
        if (builtIn != null) {
            return builtIn;
        }
        if (StringUtils.isBlank((CharSequence)spacePermission)) {
            throw new IllegalArgumentException("Cannot convert empty permission to operation");
        }
        return OperationDescription.builder().operationKey(OperationKey.valueOf((String)spacePermission)).targetType(TargetType.PLUGIN).build();
    }

    public String toPermissionType(OperationDescription operation) {
        String builtInPermission = this.tryConvertBuiltIn(operation);
        if (builtInPermission == null) {
            throw new IllegalArgumentException("Cannot convert " + String.valueOf(operation) + " to permission");
        }
        return builtInPermission;
    }
}

