/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.TargetType;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.google.common.collect.ImmutableBiMap;
import org.apache.commons.lang3.StringUtils;

public class DefaultSpacePermissionOperationKeyConverter
implements SpacePermissionOperationKeyConverter {
    private final ImmutableBiMap<OperationDescription, String> opKeyToPermissionBiMap = new ImmutableBiMap.Builder().put((Object)OperationDescription.builder().operationKey(OperationKey.READ).targetType(TargetType.SPACE).build(), (Object)"VIEWSPACE").put((Object)OperationDescription.builder().operationKey(OperationKey.CREATE).targetType(TargetType.PAGE).build(), (Object)"EDITSPACE").put((Object)OperationDescription.builder().operationKey(OperationKey.CREATE).targetType(TargetType.COMMENT).build(), (Object)"COMMENT").put((Object)OperationDescription.builder().operationKey(OperationKey.CREATE).targetType(TargetType.ATTACHMENT).build(), (Object)"CREATEATTACHMENT").put((Object)OperationDescription.builder().operationKey(OperationKey.CREATE).targetType(TargetType.BLOG_POST).build(), (Object)"EDITBLOG").put((Object)OperationDescription.builder().operationKey(OperationKey.DELETE).targetType(TargetType.PAGE).build(), (Object)"REMOVEPAGE").put((Object)OperationDescription.builder().operationKey(OperationKey.DELETE).targetType(TargetType.COMMENT).build(), (Object)"REMOVECOMMENT").put((Object)OperationDescription.builder().operationKey(OperationKey.DELETE).targetType(TargetType.BLOG_POST).build(), (Object)"REMOVEBLOG").put((Object)OperationDescription.builder().operationKey(OperationKey.DELETE).targetType(TargetType.ATTACHMENT).build(), (Object)"REMOVEATTACHMENT").put((Object)OperationDescription.builder().operationKey(OperationKey.ADMINISTER).targetType(TargetType.SPACE).build(), (Object)"SETSPACEPERMISSIONS").put((Object)OperationDescription.builder().operationKey(OperationKey.EXPORT).targetType(TargetType.SPACE).build(), (Object)"EXPORTSPACE").put((Object)OperationDescription.builder().operationKey(OperationKey.RESTRICT).targetType(TargetType.SPACE).build(), (Object)"SETPAGEPERMISSIONS").put((Object)OperationDescription.builder().operationKey(OperationKey.DELETE_OWN).targetType(TargetType.SPACE).build(), (Object)"REMOVEOWNCONTENT").put((Object)OperationDescription.builder().operationKey(OperationKey.DELETE_MAIL).targetType(TargetType.SPACE).build(), (Object)"REMOVEMAIL").build();

    private String tryConvertBuiltIn(OperationDescription operation) {
        return (String)this.opKeyToPermissionBiMap.get((Object)operation);
    }

    public OperationDescription toOperation(String spacePermission) {
        OperationDescription builtIn = (OperationDescription)this.opKeyToPermissionBiMap.inverse().get((Object)spacePermission.toUpperCase());
        if (builtIn != null) {
            return builtIn;
        }
        if (StringUtils.isBlank((CharSequence)spacePermission)) {
            throw new IllegalArgumentException("Cannot convert empty permission to operation");
        }
        return OperationDescription.builder().operationKey(OperationKey.valueOf((String)spacePermission)).targetType(TargetType.PLUGIN).build();
    }

    public String toPermissionType(OperationDescription operation) {
        String builtInPermission = this.tryConvertBuiltIn(operation);
        if (builtInPermission == null) {
            throw new IllegalArgumentException("Cannot convert " + String.valueOf(operation) + " to permission");
        }
        return builtInPermission;
    }
}

