/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.confluence.api.impl.service.permissions.validation.GlobalPermissionsValidator;
import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.GlobalPermission;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.SpacePermissionsForSubject;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.permissions.GlobalPermissionService;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.internal.security.SpacePermissionContext;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPermissionServiceImpl
implements GlobalPermissionService {
    private static final Logger log = LoggerFactory.getLogger(GlobalPermissionServiceImpl.class);
    public static final String SET_PERMISSIONS_MAX_LIMIT = "confluence.set.global.permissions.max.entries";
    private final SpacePermissionOperationKeyConverter globalPermissionOperationKeyConverter;
    private final PermissionManager permissionManager;
    private final SpacePermissionManagerInternal spacePermissionManager;
    private final GlobalPermissionsValidator globalPermissionsValidator;
    private final UserAccessor userAccessor;
    private final UserChecker userChecker;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    public GlobalPermissionServiceImpl(SpacePermissionOperationKeyConverter globalPermissionOperationKeyConverter, PermissionManager permissionManager, SpacePermissionManagerInternal spacePermissionManager, GlobalPermissionsValidator globalPermissionsValidator, UserAccessor userAccessor, UserChecker userChecker, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.globalPermissionOperationKeyConverter = globalPermissionOperationKeyConverter;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.globalPermissionsValidator = globalPermissionsValidator;
        this.userAccessor = userAccessor;
        this.userChecker = userChecker;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    public List<GlobalPermission> getAllPermissions() {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        return this.convertPermissions(globalPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToUser(User user) {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        ConfluenceUser confluenceUser = this.getConfluenceUser(user);
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(permission -> permission.isUserPermission() && confluenceUser.getKey().equals(permission.getUserSubject() == null ? null : permission.getUserSubject().getKey())).toList();
        return this.convertPermissions(userPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToGroup(String groupName) {
        this.validateGroup(groupName);
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(permission -> permission.isGroupPermission() && groupName.equals(permission.getGroup())).toList();
        return this.convertPermissions(userPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToAnonymousUsers() {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(SpacePermission::isAnonymousPermission).toList();
        return this.convertPermissions(userPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToUnlicensedUsers() {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(SpacePermission::isAuthenticatedUsersPermission).toList();
        return this.convertPermissions(userPermissions);
    }

    public void grantPermissionsToGroup(String groupName, Set<OperationDescription> permissions) {
        this.validateGroup(groupName);
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToAdd = this.convertToGroupPermissions(groupName, permissions);
        List existingPermissions = this.spacePermissionManager.getGlobalPermissions();
        this.globalPermissionsValidator.validateUseConfluencePermissionExistsForGroup(permissionsToAdd, existingPermissions, groupName).throwIfNotSuccessful();
        this.addPermissions(permissionsToAdd);
    }

    public void grantPermissionsToUser(User user, Set<OperationDescription> permissions) {
        ConfluenceUser confluenceUser = this.getConfluenceUser(user);
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToAdd = this.convertToUserPermissions(confluenceUser, permissions);
        List existingPermissions = this.spacePermissionManager.getGlobalPermissions();
        this.globalPermissionsValidator.validateUseConfluencePermissionExistsForUser(permissionsToAdd, existingPermissions, confluenceUser).throwIfNotSuccessful();
        this.addPermissions(permissionsToAdd);
    }

    public void grantPermissionsToAnonymousUsers(Set<OperationDescription> permissions) {
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToAdd = this.convertToAnonymousPermissions(permissions);
        this.globalPermissionsValidator.validateAnonymousPermissions(permissionsToAdd).throwIfNotSuccessful();
        List existingPermissions = this.spacePermissionManager.getGlobalPermissions();
        this.globalPermissionsValidator.validateUseConfluencePermissionExistsForAnonymousUser(permissionsToAdd, existingPermissions).throwIfNotSuccessful();
        this.addPermissions(permissionsToAdd);
    }

    public void grantPermissionsToUnlicensedUsers(Set<OperationDescription> permissions) {
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToAdd = this.convertToUnlicensedPermissions(permissions);
        this.globalPermissionsValidator.validateUnlicensedUsersPermissions(permissionsToAdd).throwIfNotSuccessful();
        List existingPermissions = this.spacePermissionManager.getGlobalPermissions();
        this.globalPermissionsValidator.validateLimitedUseConfluencePermissionExistsForUnlicensedUsers(permissionsToAdd, existingPermissions).throwIfNotSuccessful();
        this.addPermissions(permissionsToAdd);
    }

    public void revokePermissionsFromGroup(String groupName, Set<OperationDescription> permissions) {
        this.validateConfluenceAdministratorsPermissionsNotBeSet(groupName);
        this.validateGroup(groupName);
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToRemove = this.convertToGroupPermissions(groupName, permissions);
        Set<SpacePermission> hibernatePermissionsToRemove = this.calculateHibernatePermissionsToRemove(permissionsToRemove, "USECONFLUENCE", this.getPermissionSubjectFilterForGroup(groupName), groupName);
        this.removePermissions(hibernatePermissionsToRemove);
    }

    public void revokePermissionsFromUser(User user, Set<OperationDescription> permissions) {
        ConfluenceUser confluenceUser = this.getConfluenceUser(user);
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToRemove = this.convertToUserPermissions(confluenceUser, permissions);
        Set<SpacePermission> hibernatePermissionsToRemove = this.calculateHibernatePermissionsToRemove(permissionsToRemove, "USECONFLUENCE", this.getPermissionSubjectFilterForUser(confluenceUser), confluenceUser.getName());
        this.removePermissions(hibernatePermissionsToRemove);
    }

    public void revokePermissionsFromAnonymousUsers(Set<OperationDescription> permissions) {
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToRemove = this.convertToAnonymousPermissions(permissions);
        this.globalPermissionsValidator.validateAnonymousPermissions(permissionsToRemove).throwIfNotSuccessful();
        Set<SpacePermission> hibernatePermissionsToRemove = this.calculateHibernatePermissionsToRemove(permissionsToRemove, "USECONFLUENCE", SpacePermission::isAnonymousPermission, "anonymous users");
        this.removePermissions(hibernatePermissionsToRemove);
    }

    public void revokePermissionsFromUnlicensedUsers(Set<OperationDescription> permissions) {
        this.validateApplicationAdministerPermission();
        Set<SpacePermission> permissionsToRemove = this.convertToUnlicensedPermissions(permissions);
        this.globalPermissionsValidator.validateUnlicensedUsersPermissions(permissionsToRemove).throwIfNotSuccessful();
        Set<SpacePermission> hibernatePermissionsToRemove = this.calculateHibernatePermissionsToRemove(permissionsToRemove, "LIMITEDUSECONFLUENCE", SpacePermission::isAuthenticatedUsersPermission, "unlicensed users");
        this.removePermissions(hibernatePermissionsToRemove);
    }

    public void setPermissions(Set<SpacePermissionsForSubject> permissionsForSubjects) {
        this.validateApplicationAdministerPermission();
        this.validateSetPermissionSubjectsLimit(permissionsForSubjects);
        HashSet<SpacePermission> existingPermissions = new HashSet<SpacePermission>(this.spacePermissionManager.getGlobalPermissions());
        HashSet<SpacePermission> permissionsToAdd = new HashSet<SpacePermission>();
        HashSet<SpacePermission> permissionsToRemove = new HashSet<SpacePermission>();
        for (SpacePermissionsForSubject permission : permissionsForSubjects) {
            this.validateSetPermissionSubjectNotConflict(permission);
            if (this.isPermissionForGroup(permission)) {
                this.preparePermissionsToSetForGroup(permission.getGroupName(), permission.getOperations(), existingPermissions, permissionsToAdd, permissionsToRemove);
                continue;
            }
            if (!this.isPermissionForUser(permission)) continue;
            this.preparePermissionsToSetForUser(permission.getUserKey(), permission.getOperations(), existingPermissions, permissionsToAdd, permissionsToRemove);
        }
        this.addPermissions(permissionsToAdd);
        this.removePermissions(permissionsToRemove);
    }

    private int getSetPermissionsLimit() {
        return Integer.getInteger(SET_PERMISSIONS_MAX_LIMIT, 40);
    }

    private void preparePermissionsToSetForGroup(String groupName, Set<OperationDescription> operationDescriptions, Set<SpacePermission> existingPermissions, Set<SpacePermission> permissionsToAdd, Set<SpacePermission> permissionsToRemove) {
        this.validateConfluenceAdministratorsPermissionsNotBeSet(groupName);
        this.validateGroup(groupName);
        Set<SpacePermission> groupPermissionsToAdd = this.convertToGroupPermissions(groupName, operationDescriptions);
        if (!groupPermissionsToAdd.isEmpty()) {
            this.globalPermissionsValidator.validateUseConfluencePermissionWillBeAdded(groupPermissionsToAdd).throwIfNotSuccessful();
        }
        Function<SpacePermission, Boolean> permissionSubjectFilter = this.getPermissionSubjectFilterForGroup(groupName);
        Set groupPermissionsToRemove = existingPermissions.stream().filter(permissionSubjectFilter::apply).filter(p -> !groupPermissionsToAdd.contains(p)).collect(Collectors.toSet());
        permissionsToAdd.addAll(groupPermissionsToAdd);
        permissionsToRemove.addAll(groupPermissionsToRemove);
    }

    private void preparePermissionsToSetForUser(String userKey, Set<OperationDescription> operations, Set<SpacePermission> existingPermissions, Set<SpacePermission> permissionsToAdd, Set<SpacePermission> permissionsToRemove) {
        ConfluenceUser confluenceUser = this.getConfluenceUser(new User(userKey));
        Set<SpacePermission> userPermissionsToAdd = this.convertToUserPermissions(confluenceUser, operations);
        if (!userPermissionsToAdd.isEmpty()) {
            this.globalPermissionsValidator.validateUseConfluencePermissionWillBeAdded(userPermissionsToAdd).throwIfNotSuccessful();
        }
        Function<SpacePermission, Boolean> permissionSubjectFilter = this.getPermissionSubjectFilterForUser(confluenceUser);
        Set userPermissionsToRemove = existingPermissions.stream().filter(permissionSubjectFilter::apply).filter(p -> !userPermissionsToAdd.contains(p)).collect(Collectors.toSet());
        permissionsToAdd.addAll(userPermissionsToAdd);
        permissionsToRemove.addAll(userPermissionsToRemove);
    }

    private void validateSetPermissionSubjectsLimit(Set<SpacePermissionsForSubject> permissionsForSubjects) {
        if (permissionsForSubjects.size() > this.getSetPermissionsLimit()) {
            throw new BadRequestException(String.format("You tried to set global permissions to %s different subjects. You can only set global permissions to %s different subjects at a time.", permissionsForSubjects.size(), this.getSetPermissionsLimit()));
        }
    }

    private ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    private void validateGroup(String groupName) {
        Group groupEntity = this.userAccessor.getGroup(groupName);
        if (groupEntity == null) {
            throw new NotFoundException("Group with the given name is not found. name: " + groupName);
        }
    }

    private List<GlobalPermission> convertPermissions(List<SpacePermission> spacePermissions) {
        return spacePermissions.stream().map(this::convertPermission).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private GlobalPermission convertPermission(SpacePermission spacePermission) {
        try {
            GlobalPermission permission = new GlobalPermission();
            permission.setSubject(this.getSubjectFromSpacePermission(spacePermission));
            permission.setOperation(this.globalPermissionOperationKeyConverter.toOperation(spacePermission.getType()));
            if (spacePermission.getSpace() != null) {
                throw new IllegalArgumentException("Global permission should not have a space.");
            }
            return permission;
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to convert SpacePermission {}", (Object)spacePermission, (Object)e);
            return null;
        }
    }

    private ConfluenceUser getConfluenceUser(User user) {
        ConfluenceUser confluenceUser = null;
        if (user.optionalUserKey().isPresent()) {
            confluenceUser = this.userAccessor.getUserByKey((UserKey)user.optionalUserKey().get());
        }
        if (confluenceUser == null && user.optionalUsername().isPresent()) {
            confluenceUser = this.userAccessor.getUserByName((String)user.optionalUsername().get());
        }
        if (confluenceUser == null) {
            throw new NotFoundException("User not found: " + String.valueOf(user));
        }
        return confluenceUser;
    }

    private Subject getSubjectFromSpacePermission(SpacePermission permission) {
        if (permission.isGroupPermission()) {
            return com.atlassian.confluence.api.model.people.Group.builder().name(permission.getGroup()).build();
        }
        if (permission.isAnonymousPermission()) {
            return Anonymous.ANONYMOUS_USER;
        }
        if (permission.isAuthenticatedUsersPermission()) {
            return new UnknownUser(null, null);
        }
        ConfluenceUser user = permission.getUserSubject();
        if (permission.isUserPermission() && user != null) {
            return User.fromUserkey((UserKey)user.getKey());
        }
        throw new IllegalArgumentException("Unknown subject for permission " + String.valueOf(permission));
    }

    private Set<SpacePermission> convertToGroupPermissions(String groupName, Set<OperationDescription> operationDescriptions) {
        return this.convertToPermissions(operationDescriptions, permissionType -> SpacePermission.createGroupSpacePermission((String)permissionType, null, (String)groupName));
    }

    private Set<SpacePermission> convertToUserPermissions(ConfluenceUser confluenceUser, Set<OperationDescription> operationDescriptions) {
        return this.convertToPermissions(operationDescriptions, permissionType -> SpacePermission.createUserSpacePermission((String)permissionType, null, (ConfluenceUser)confluenceUser));
    }

    private Set<SpacePermission> convertToAnonymousPermissions(Set<OperationDescription> operationDescriptions) {
        return this.convertToPermissions(operationDescriptions, permissionType -> SpacePermission.createAnonymousSpacePermission((String)permissionType, null));
    }

    private Set<SpacePermission> convertToUnlicensedPermissions(Set<OperationDescription> operationDescriptions) {
        return this.convertToPermissions(operationDescriptions, permissionType -> SpacePermission.createAuthenticatedUsersSpacePermission((String)permissionType, null));
    }

    private Set<SpacePermission> convertToPermissions(Set<OperationDescription> operationDescriptions, Function<String, SpacePermission> permissionMapper) {
        try {
            return operationDescriptions.stream().map(arg_0 -> ((SpacePermissionOperationKeyConverter)this.globalPermissionOperationKeyConverter).toPermissionType(arg_0)).map(permissionMapper::apply).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private void addPermissions(Set<SpacePermission> spacePermissionsToAdd) {
        if (spacePermissionsToAdd.isEmpty()) {
            return;
        }
        try {
            this.spacePermissionManager.saveGlobalPermissions(spacePermissionsToAdd, SpacePermissionContext.createDefault());
            this.userChecker.resetResult();
        }
        catch (InsufficientPrivilegeException e) {
            throw new PermissionException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private void removePermissions(Set<SpacePermission> hibernateSpacePermissionsToRemove) {
        if (hibernateSpacePermissionsToRemove.isEmpty()) {
            return;
        }
        try {
            this.spacePermissionManager.removePermissions(hibernateSpacePermissionsToRemove, SpacePermissionContext.createDefault());
            this.userChecker.resetResult();
        }
        catch (InsufficientPrivilegeException e) {
            throw new PermissionException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<SpacePermission> calculateHibernatePermissionsToRemove(Set<SpacePermission> spacePermissionsToRemove, String guardPermission, Function<SpacePermission, Boolean> subjectFilter, String subject) {
        if (this.guardPermissionWillBeRemoved(spacePermissionsToRemove, guardPermission)) {
            return this.spacePermissionManager.getGlobalPermissions().stream().filter(subjectFilter::apply).collect(Collectors.toSet());
        }
        return this.convertToHibernatePermissions(spacePermissionsToRemove, subject);
    }

    private Set<SpacePermission> convertToHibernatePermissions(Set<SpacePermission> constructedPermissions, String subject) {
        List allPermissions = this.spacePermissionManager.getGlobalPermissions();
        HashSet<SpacePermission> hibernatePermissions = new HashSet<SpacePermission>();
        for (SpacePermission spacePermission : constructedPermissions) {
            allPermissions.stream().filter(arg_0 -> ((SpacePermission)spacePermission).equals(arg_0)).findFirst().ifPresent(hibernatePermissions::add);
        }
        return hibernatePermissions;
    }

    private void validateApplicationAdministerPermission() {
        if (!this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new PermissionException("User does not have sufficient permission");
        }
    }

    private void validateApplicationAdministerPermissionOrReadAllScope() {
        if (!this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) && !this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            throw new PermissionException("User does not have sufficient permission");
        }
    }

    private void validateConfluenceAdministratorsPermissionsNotBeSet(String groupName) {
        if ("confluence-administrators".equalsIgnoreCase(groupName)) {
            throw new BadRequestException("Changes confluence-administrators group permissions is not allowed");
        }
    }

    private void validateSetPermissionSubjectNotConflict(SpacePermissionsForSubject permission) {
        if (this.isPermissionForGroup(permission) && this.isPermissionForUser(permission)) {
            throw new BadRequestException(String.format("Only groupName or userKey should be set, but both are populated. groupName: %s, userKey: %s", permission.getGroupName(), permission.getUserKey()));
        }
    }

    private boolean isPermissionForGroup(SpacePermissionsForSubject permission) {
        return !StringUtils.isEmpty((CharSequence)permission.getGroupName());
    }

    private boolean isPermissionForUser(SpacePermissionsForSubject permission) {
        return !StringUtils.isEmpty((CharSequence)permission.getUserKey());
    }

    private boolean guardPermissionWillBeRemoved(Collection<SpacePermission> permissionsToRemove, String guardPermission) {
        return permissionsToRemove.stream().anyMatch(spacePermission -> guardPermission.equals(spacePermission.getType()));
    }

    public Function<SpacePermission, Boolean> getPermissionSubjectFilterForGroup(String groupName) {
        return permission -> permission.isGroupPermission() && Objects.equals(permission.getGroup(), groupName);
    }

    public Function<SpacePermission, Boolean> getPermissionSubjectFilterForUser(ConfluenceUser user) {
        return permission -> permission.isUserPermission() && user.equals((Object)permission.getUserSubject());
    }
}

