/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.confluence.api.impl.service.permissions.validation.SpacePermissionsValidator;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.SpacePermission;
import com.atlassian.confluence.api.model.permissions.SpacePermissionsForSubject;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.atlassian.confluence.api.service.permissions.SpacePermissionService;
import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.internal.security.ServiceAccountPermissionManager;
import com.atlassian.confluence.internal.security.SpacePermissionContext;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.security.SetSpacePermissionChecker;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.sal.api.user.UserKey;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacePermissionServiceImpl
implements SpacePermissionService {
    private static final Logger log = LoggerFactory.getLogger(SpacePermissionServiceImpl.class);
    public static final Integer MAX_ENTRIES = Integer.getInteger("confluence.set.space.permissions.max.entries", 40);
    private final SpacePermissionManagerInternal spacePermissionManager;
    private final SpaceManagerInternal spaceManager;
    private final SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter;
    private final UserAccessor userAccessor;
    private final SpacePermissionsValidator spacePermissionsValidator;
    private final SetSpacePermissionChecker setSpacePermissionChecker;
    private final UserChecker userChecker;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final ServiceAccountPermissionManager serviceAccountPermissionManager;

    public SpacePermissionServiceImpl(SpacePermissionManagerInternal spacePermissionManager, SpaceManagerInternal spaceManager, SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter, UserAccessor userAccessor, SpacePermissionsValidator spacePermissionsValidator, SetSpacePermissionChecker setSpacePermissionChecker, UserChecker userChecker, ScopesRequestCacheDelegate scopesRequestCacheDelegate, ServiceAccountPermissionManager serviceAccountPermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
        this.spaceManager = spaceManager;
        this.spacePermissionOperationKeyConverter = spacePermissionOperationKeyConverter;
        this.userAccessor = userAccessor;
        this.spacePermissionsValidator = spacePermissionsValidator;
        this.setSpacePermissionChecker = setSpacePermissionChecker;
        this.userChecker = userChecker;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.serviceAccountPermissionManager = serviceAccountPermissionManager;
    }

    public void grantPermissionsToUser(String spaceKey, String userKey, Set<OperationDescription> permissions) {
        Space entitySpace = this.getSpace(spaceKey);
        this.validateSpacePermissions(entitySpace);
        ConfluenceUser confluenceUser = this.getConfluenceUser(userKey);
        Set<com.atlassian.confluence.security.SpacePermission> permissionsToAdd = this.convertToUserSpacePermissions(entitySpace, confluenceUser, permissions);
        this.spacePermissionsValidator.validateViewSpacePermissionExistsForUser(entitySpace, permissionsToAdd, confluenceUser).throwIfNotSuccessful();
        this.addPermissions(entitySpace, permissionsToAdd);
    }

    public void grantPermissionsToAnonymousUser(String spaceKey, Set<OperationDescription> permissions) {
        Space entitySpace = this.getSpace(spaceKey);
        this.validateSpacePermissions(entitySpace);
        Set<com.atlassian.confluence.security.SpacePermission> permissionsToAdd = this.convertToAnonymousSpacePermissions(entitySpace, permissions);
        this.spacePermissionsValidator.validateViewSpacePermissionExistsForAnonymousUser(entitySpace, permissionsToAdd).throwIfNotSuccessful();
        this.addPermissions(entitySpace, permissionsToAdd);
    }

    public void grantPermissionsToGroup(String spaceKey, String groupName, Set<OperationDescription> permissions) {
        Space entitySpace = this.getSpace(spaceKey);
        this.validateSpacePermissions(entitySpace);
        this.validateGroup(groupName);
        Set<com.atlassian.confluence.security.SpacePermission> permissionsToAdd = this.convertToGroupSpacePermissions(entitySpace, groupName, permissions);
        this.spacePermissionsValidator.validateViewSpacePermissionExistsForGroup(entitySpace, permissionsToAdd, groupName).throwIfNotSuccessful();
        this.addPermissions(entitySpace, permissionsToAdd);
    }

    public void removePermissionsFromUser(String spaceKey, String userKey, Set<OperationDescription> permissions) {
        Space entitySpace = this.getSpace(spaceKey);
        this.validateSpacePermissions(entitySpace);
        ConfluenceUser confluenceUser = this.getConfluenceUser(userKey);
        this.validatePersonalSpaceOwnerPermissionsNotRemoved(entitySpace, confluenceUser);
        List existingPermissions = this.spacePermissionManager.getPermissionsForUser(confluenceUser, entitySpace);
        this.removePermissions(entitySpace, permissions, existingPermissions);
    }

    public void removePermissionsFromAnonymousUser(String spaceKey, Set<OperationDescription> permissions) {
        Space entitySpace = this.getSpace(spaceKey);
        this.validateSpacePermissions(entitySpace);
        List existingPermissions = this.spacePermissionManager.getPermissionsForAnonymousUsers(entitySpace);
        this.removePermissions(entitySpace, permissions, existingPermissions);
    }

    public void removePermissionsFromGroup(String spaceKey, String groupName, Set<OperationDescription> permissions) {
        Space entitySpace = this.getSpace(spaceKey);
        this.validateSpacePermissions(entitySpace);
        this.validateGroup(groupName);
        List existingPermissions = this.spacePermissionManager.getPermissionsForGroup(groupName, entitySpace);
        this.removePermissions(entitySpace, permissions, existingPermissions);
    }

    public List<SpacePermission> getPermissionsGrantedToUser(String spaceKey, String userKey) {
        Space space = this.getSpace(spaceKey);
        this.validateSpacePermissionsOrReadAllScope(space);
        ConfluenceUser confluenceUser = this.getConfluenceUser(userKey);
        List spacePermissionEntities = this.spacePermissionManager.getPermissionsForUser(confluenceUser, space);
        return this.convertPermissions(spacePermissionEntities);
    }

    public List<SpacePermission> getPermissionsGrantedToAnonymousUsers(String spaceKey) {
        Space space = this.getSpace(spaceKey);
        this.validateSpacePermissionsOrReadAllScope(space);
        List spacePermissionEntities = this.spacePermissionManager.getPermissionsForAnonymousUsers(space);
        return this.convertPermissions(spacePermissionEntities);
    }

    public List<SpacePermission> getPermissionsGrantedToGroup(String spaceKey, String groupName) {
        Space space = this.getSpace(spaceKey);
        this.validateSpacePermissionsOrReadAllScope(space);
        this.validateGroup(groupName);
        List spacePermissionEntities = this.spacePermissionManager.getPermissionsForGroup(groupName, space);
        return this.convertPermissions(spacePermissionEntities);
    }

    public List<SpacePermission> getAllPermissions(String spaceKey) {
        Space space = this.getSpace(spaceKey);
        this.validateSpacePermissionsOrReadAllScope(space);
        return this.convertPermissions(space.getPermissions());
    }

    public void setPermissions(String spaceKey, Set<SpacePermissionsForSubject> spacePermissionsForSubjects) {
        this.validateSubjectsLimit(spacePermissionsForSubjects);
        Space space = this.getSpace(spaceKey);
        this.validateSpacePermissions(space);
        HashSet<com.atlassian.confluence.security.SpacePermission> existingPermissions = new HashSet<com.atlassian.confluence.security.SpacePermission>(space.getPermissions());
        HashSet<com.atlassian.confluence.security.SpacePermission> permissionsToAdd = new HashSet<com.atlassian.confluence.security.SpacePermission>();
        HashSet<com.atlassian.confluence.security.SpacePermission> permissionsToRemove = new HashSet<com.atlassian.confluence.security.SpacePermission>();
        for (SpacePermissionsForSubject spacePermissionsForSubject : spacePermissionsForSubjects) {
            if (!StringUtils.isEmpty((CharSequence)spacePermissionsForSubject.getGroupName()) && !StringUtils.isEmpty((CharSequence)spacePermissionsForSubject.getUserKey())) {
                throw new BadRequestException(String.format("Only groupName or userKey should be set, but both are populated. groupName: %s, userKey: %s", spacePermissionsForSubject.getGroupName(), spacePermissionsForSubject.getUserKey()));
            }
            if (!StringUtils.isEmpty((CharSequence)spacePermissionsForSubject.getGroupName())) {
                this.prepareGroupPermissions(space, spacePermissionsForSubject.getGroupName(), spacePermissionsForSubject.getOperations(), existingPermissions, permissionsToAdd, permissionsToRemove);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)spacePermissionsForSubject.getUserKey())) {
                this.prepareUserPermissions(space, spacePermissionsForSubject.getUserKey(), spacePermissionsForSubject.getOperations(), existingPermissions, permissionsToAdd, permissionsToRemove);
                continue;
            }
            this.prepareAnonymousUserPermissions(space, spacePermissionsForSubject.getOperations(), existingPermissions, permissionsToAdd, permissionsToRemove);
        }
        this.addPermissions(space, permissionsToAdd);
        this.removePermissions(space, permissionsToRemove);
    }

    private void validateSubjectsLimit(Set<SpacePermissionsForSubject> spacePermissionsForSubjects) {
        if (spacePermissionsForSubjects.size() > MAX_ENTRIES) {
            throw new BadRequestException(String.format("You tried to set space permissions to %s different subjects. You can only set space permissions to %s different subjects at a time.", spacePermissionsForSubjects.size(), MAX_ENTRIES));
        }
    }

    private void prepareAnonymousUserPermissions(Space space, Set<OperationDescription> operations, HashSet<com.atlassian.confluence.security.SpacePermission> existingPermissions, Set<com.atlassian.confluence.security.SpacePermission> permissionsToAdd, Set<com.atlassian.confluence.security.SpacePermission> permissionsToRemove) {
        Set<com.atlassian.confluence.security.SpacePermission> anonymousPermissionsToAdd = this.convertToAnonymousSpacePermissions(space, operations);
        if (!anonymousPermissionsToAdd.isEmpty()) {
            this.spacePermissionsValidator.validateViewSpacePermissionWillBeAdded(anonymousPermissionsToAdd).throwIfNotSuccessful();
        }
        Set anonymousPermissionsToRemove = existingPermissions.stream().filter(com.atlassian.confluence.security.SpacePermission::isAnonymousPermission).filter(s -> !anonymousPermissionsToAdd.contains(s)).collect(Collectors.toSet());
        permissionsToAdd.addAll(anonymousPermissionsToAdd);
        permissionsToRemove.addAll(anonymousPermissionsToRemove);
    }

    private void prepareUserPermissions(Space space, String userKey, Set<OperationDescription> operations, Set<com.atlassian.confluence.security.SpacePermission> existingPermissions, Set<com.atlassian.confluence.security.SpacePermission> permissionsToAdd, Set<com.atlassian.confluence.security.SpacePermission> permissionsToRemove) {
        Set userPermissionsToRemove;
        ConfluenceUser confluenceUser = this.getConfluenceUser(userKey);
        Set<com.atlassian.confluence.security.SpacePermission> userPermissionsToAdd = this.convertToUserSpacePermissions(space, confluenceUser, operations);
        if (!userPermissionsToAdd.isEmpty()) {
            this.spacePermissionsValidator.validateViewSpacePermissionWillBeAdded(userPermissionsToAdd).throwIfNotSuccessful();
        }
        if (!(userPermissionsToRemove = existingPermissions.stream().filter(com.atlassian.confluence.security.SpacePermission::isUserPermission).filter(s -> confluenceUser.equals((Object)s.getUserSubject())).filter(s -> !userPermissionsToAdd.contains(s)).collect(Collectors.toSet())).isEmpty()) {
            this.validatePersonalSpaceOwnerPermissionsNotRemoved(space, confluenceUser);
        }
        permissionsToAdd.addAll(userPermissionsToAdd);
        permissionsToRemove.addAll(userPermissionsToRemove);
    }

    private void prepareGroupPermissions(Space space, String groupName, Set<OperationDescription> operationDescriptions, Set<com.atlassian.confluence.security.SpacePermission> existingPermissions, Set<com.atlassian.confluence.security.SpacePermission> permissionsToAdd, Set<com.atlassian.confluence.security.SpacePermission> permissionsToRemove) {
        this.validateGroup(groupName);
        Set<com.atlassian.confluence.security.SpacePermission> groupPermissionsToAdd = this.convertToGroupSpacePermissions(space, groupName, operationDescriptions);
        if (!groupPermissionsToAdd.isEmpty()) {
            this.spacePermissionsValidator.validateViewSpacePermissionWillBeAdded(groupPermissionsToAdd).throwIfNotSuccessful();
        }
        Set groupPermissionsToRemove = existingPermissions.stream().filter(com.atlassian.confluence.security.SpacePermission::isGroupPermission).filter(s -> groupName.equals(s.getGroup())).filter(s -> !groupPermissionsToAdd.contains(s)).collect(Collectors.toSet());
        permissionsToAdd.addAll(groupPermissionsToAdd);
        permissionsToRemove.addAll(groupPermissionsToRemove);
    }

    private Set<com.atlassian.confluence.security.SpacePermission> convertToUserSpacePermissions(Space space, ConfluenceUser confluenceUser, Set<OperationDescription> operationDescriptions) {
        try {
            return operationDescriptions.stream().map(arg_0 -> ((SpacePermissionOperationKeyConverter)this.spacePermissionOperationKeyConverter).toPermissionType(arg_0)).map(permissionType -> com.atlassian.confluence.security.SpacePermission.createUserSpacePermission((String)permissionType, (Space)space, (ConfluenceUser)confluenceUser)).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<com.atlassian.confluence.security.SpacePermission> convertToAnonymousSpacePermissions(Space space, Set<OperationDescription> operationDescriptions) {
        try {
            return operationDescriptions.stream().map(arg_0 -> ((SpacePermissionOperationKeyConverter)this.spacePermissionOperationKeyConverter).toPermissionType(arg_0)).map(permissionType -> com.atlassian.confluence.security.SpacePermission.createAnonymousSpacePermission((String)permissionType, (Space)space)).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<com.atlassian.confluence.security.SpacePermission> convertToGroupSpacePermissions(Space space, String groupName, Set<OperationDescription> operationDescriptions) {
        try {
            return operationDescriptions.stream().map(arg_0 -> ((SpacePermissionOperationKeyConverter)this.spacePermissionOperationKeyConverter).toPermissionType(arg_0)).map(permissionType -> com.atlassian.confluence.security.SpacePermission.createGroupSpacePermission((String)permissionType, (Space)space, (String)groupName)).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private List<SpacePermission> convertPermissions(List<com.atlassian.confluence.security.SpacePermission> spacePermissions) {
        return spacePermissions.stream().map(this::convertPermission).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SpacePermission convertPermission(com.atlassian.confluence.security.SpacePermission spacePermission) {
        SpacePermission permission = new SpacePermission();
        permission.setSubject(this.getSubjectFromSpacePermission(spacePermission));
        try {
            permission.setOperation(this.spacePermissionOperationKeyConverter.toOperation(spacePermission.getType()));
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to convert SpacePermission {}", (Object)spacePermission, (Object)e);
            return null;
        }
        if (spacePermission.getSpace() == null) {
            log.error("Space permission does not have a space: {}", (Object)spacePermission);
            return null;
        }
        Space space = spacePermission.getSpace();
        permission.setSpaceKey(space.getKey());
        permission.setSpaceId(space.getId());
        return permission;
    }

    private Subject getSubjectFromSpacePermission(com.atlassian.confluence.security.SpacePermission permission) {
        if (permission.isGroupPermission()) {
            return Group.builder().name(permission.getGroup()).build();
        }
        if (permission.isAnonymousPermission()) {
            return Anonymous.ANONYMOUS_USER;
        }
        ConfluenceUser user = permission.getUserSubject();
        if (permission.isUserPermission() && user != null) {
            return User.fromUserkey((UserKey)user.getKey());
        }
        if (permission.isAuthenticatedUsersPermission()) {
            return new UnknownUser(null, null);
        }
        throw new IllegalArgumentException("Unknown subject for permission " + String.valueOf(permission));
    }

    private void removePermissions(Space space, Set<OperationDescription> operationDescriptions, List<com.atlassian.confluence.security.SpacePermission> existingPermissions) {
        Set<com.atlassian.confluence.security.SpacePermission> permissionsToRemove = this.getAllPermissionsToRemove(operationDescriptions, existingPermissions);
        this.removePermissions(space, permissionsToRemove);
    }

    private void removePermissions(Space space, Set<com.atlassian.confluence.security.SpacePermission> permissionsToRemove) {
        if (permissionsToRemove.isEmpty()) {
            return;
        }
        this.spacePermissionsValidator.validateAtLeastOneAdminPermissionExists(space, permissionsToRemove).throwIfNotSuccessful();
        try {
            this.spacePermissionManager.removePermissions(permissionsToRemove, SpacePermissionContext.createDefault());
            this.userChecker.resetResult();
        }
        catch (InsufficientPrivilegeException e) {
            throw new PermissionException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<com.atlassian.confluence.security.SpacePermission> getAllPermissionsToRemove(Set<OperationDescription> operationDescriptions, List<com.atlassian.confluence.security.SpacePermission> existingPermissions) {
        HashSet<com.atlassian.confluence.security.SpacePermission> permissionsToRemove = new HashSet<com.atlassian.confluence.security.SpacePermission>();
        try {
            for (OperationDescription operation : operationDescriptions) {
                String permissionType = this.spacePermissionOperationKeyConverter.toPermissionType(operation);
                Optional<com.atlassian.confluence.security.SpacePermission> spacePermission = existingPermissions.stream().filter(p -> p.getType().equals(permissionType)).findFirst();
                spacePermission.ifPresent(permissionsToRemove::add);
            }
            permissionsToRemove.addAll(this.getDependentPermissions(permissionsToRemove, existingPermissions));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        return permissionsToRemove;
    }

    private Set<com.atlassian.confluence.security.SpacePermission> getDependentPermissions(Set<com.atlassian.confluence.security.SpacePermission> permissionsToRemove, List<com.atlassian.confluence.security.SpacePermission> existingPermissions) {
        HashSet<com.atlassian.confluence.security.SpacePermission> dependentPermissions = new HashSet<com.atlassian.confluence.security.SpacePermission>();
        for (com.atlassian.confluence.security.SpacePermission permissionToRemove : permissionsToRemove) {
            for (com.atlassian.confluence.security.SpacePermission existingPermission : existingPermissions) {
                if (!existingPermission.isDependentOn(permissionToRemove)) continue;
                dependentPermissions.add(existingPermission);
            }
        }
        return dependentPermissions;
    }

    private void addPermissions(Space space, Set<com.atlassian.confluence.security.SpacePermission> spacePermissionsToAdd) {
        if (spacePermissionsToAdd.isEmpty()) {
            return;
        }
        try {
            this.spacePermissionManager.saveSpacePermissions(space, spacePermissionsToAdd, SpacePermissionContext.createDefault());
            this.userChecker.resetResult();
        }
        catch (InsufficientPrivilegeException e) {
            throw new PermissionException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private Space getSpace(String spaceKey) {
        List spaces = this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceKeys(Set.of(spaceKey)).build(), LimitedRequestImpl.create((int)1), new Predicate[0]).getResults();
        if (spaces.isEmpty()) {
            throw new PermissionException("Access to space with spaceKey='" + spaceKey + "' is denied or the space does not exists.");
        }
        Space space = (Space)spaces.get(0);
        return space;
    }

    private void validateSpacePermissions(Space space) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (this.serviceAccountPermissionManager.isServiceAccount(currentUser)) {
            if (!this.serviceAccountPermissionManager.hasSpacePermission(space, currentUser)) {
                throw new PermissionException(String.format("ServiceAccount [%s] does not have the required privileges for space [%s].", currentUser.getName(), space.getName()));
            }
        } else if (!this.setSpacePermissionChecker.canSetPermission(currentUser, com.atlassian.confluence.security.SpacePermission.createAnonymousSpacePermission((String)"VIEWSPACE", (Space)space))) {
            String name = currentUser == null ? "Anonymous" : currentUser.getName();
            throw new PermissionException(String.format("User [%s] does not have the required privileges.", name));
        }
    }

    private void validateSpacePermissionsOrReadAllScope(Space space) {
        if (!this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            this.validateSpacePermissions(space);
        }
    }

    private ConfluenceUser getConfluenceUser(String userKey) {
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (user == null) {
            throw new NotFoundException("User with the given key is not found. userKey: " + userKey);
        }
        return user;
    }

    private void validateGroup(String groupName) {
        com.atlassian.user.Group groupEntity = this.userAccessor.getGroup(groupName);
        if (groupEntity == null) {
            throw new NotFoundException("Group with the given name is not found. name: " + groupName);
        }
    }

    private void validatePersonalSpaceOwnerPermissionsNotRemoved(Space space, ConfluenceUser user) {
        if (space.isPersonal() && user.equals((Object)space.getCreator())) {
            throw new BadRequestException(String.format("Couldn't revoke permissions from user %s because space %s is their personal space", user.getKey(), space.getKey()));
        }
    }
}

