/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions.validation;

import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractPermissionsValidator {
    protected ValidationResult validateGuardPermissionExistsForUser(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, String guardPermission, ConfluenceUser user) {
        return this.validateGuardPermissionExistsForSubject(permissionsToAdd, existingPermissions, guardPermission, permission -> permission.isUserPermission() && user.equals((Object)permission.getUserSubject()));
    }

    protected ValidationResult validateGuardPermissionExistsForGroup(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, String guardPermission, String groupName) {
        return this.validateGuardPermissionExistsForSubject(permissionsToAdd, existingPermissions, guardPermission, permission -> permission.isGroupPermission() && Objects.equals(permission.getGroup(), groupName));
    }

    protected ValidationResult validateGuardPermissionExistsForAnonymousUsers(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, String guardPermission) {
        return this.validateGuardPermissionExistsForSubject(permissionsToAdd, existingPermissions, guardPermission, SpacePermission::isAnonymousPermission);
    }

    protected ValidationResult validateGuardPermissionExistsForUnlicensedUsers(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, String guardPermission) {
        return this.validateGuardPermissionExistsForSubject(permissionsToAdd, existingPermissions, guardPermission, SpacePermission::isAuthenticatedUsersPermission);
    }

    protected ValidationResult validateGuardPermissionExistsForSubject(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, String guardPermission, Function<SpacePermission, Boolean> subjectFilter) {
        if (this.guardPermissionWillBeAdded(permissionsToAdd, guardPermission)) {
            return SimpleValidationResult.VALID;
        }
        boolean permissionExist = existingPermissions.stream().filter(subjectFilter::apply).anyMatch(permission -> Objects.equals(permission.getType(), guardPermission));
        return this.createGuardPermissionValidationResult(permissionExist, guardPermission);
    }

    protected boolean guardPermissionWillBeAdded(Collection<SpacePermission> permissionsToAdd, String guardPermission) {
        return permissionsToAdd.stream().anyMatch(spacePermission -> guardPermission.equals(spacePermission.getType()));
    }

    protected ValidationResult createGuardPermissionValidationResult(boolean permissionExist, String guardPermission) {
        return permissionExist ? SimpleValidationResult.VALID : this.createValidationResultWithError(String.format("'%s' permission has to exist before adding any other permissions for a subject. ", guardPermission));
    }

    protected ValidationResult createValidationResultWithError(String message) {
        return SimpleValidationResult.builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)message)).build();
    }
}

