/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions.validation;

import com.atlassian.confluence.api.impl.service.permissions.validation.AbstractPermissionsValidator;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

public class GlobalPermissionsValidator
extends AbstractPermissionsValidator {
    public ValidationResult validateUseConfluencePermissionWillBeAdded(Collection<SpacePermission> permissionsToAdd) {
        boolean permissionExist = this.guardPermissionWillBeAdded(permissionsToAdd, "USECONFLUENCE");
        return this.createGuardPermissionValidationResult(permissionExist, "USECONFLUENCE");
    }

    public ValidationResult validateUseConfluencePermissionExistsForUser(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, ConfluenceUser user) {
        return this.validateGuardPermissionExistsForUser(permissionsToAdd, existingPermissions, "USECONFLUENCE", user);
    }

    public ValidationResult validateUseConfluencePermissionExistsForGroup(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions, String groupName) {
        return this.validateGuardPermissionExistsForGroup(permissionsToAdd, existingPermissions, "USECONFLUENCE", groupName);
    }

    public ValidationResult validateUseConfluencePermissionExistsForAnonymousUser(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions) {
        return this.validateGuardPermissionExistsForAnonymousUsers(permissionsToAdd, existingPermissions, "USECONFLUENCE");
    }

    public ValidationResult validateLimitedUseConfluencePermissionExistsForUnlicensedUsers(Collection<SpacePermission> permissionsToAdd, Collection<SpacePermission> existingPermissions) {
        return this.validateGuardPermissionExistsForUnlicensedUsers(permissionsToAdd, existingPermissions, "LIMITEDUSECONFLUENCE");
    }

    public ValidationResult validateAnonymousPermissions(Collection<SpacePermission> spacePermissions) {
        return this.validatePermissionsCanBeSet(spacePermissions, SpacePermission::isInvalidAnonymousPermission, "anonymous users");
    }

    public ValidationResult validateUnlicensedUsersPermissions(Collection<SpacePermission> spacePermissions) {
        return this.validatePermissionsCanBeSet(spacePermissions, SpacePermission::isInvalidAuthenticatedUsersPermission, "unlicensed users");
    }

    private ValidationResult validatePermissionsCanBeSet(Collection<SpacePermission> spacePermissions, Function<SpacePermission, Boolean> invalidPermissionChecker, String subject) {
        ArrayList<String> invalidPermissionTypes = new ArrayList<String>();
        for (SpacePermission spacePermission : spacePermissions) {
            if (!invalidPermissionChecker.apply(spacePermission).booleanValue()) continue;
            invalidPermissionTypes.add(spacePermission.getType());
        }
        if (invalidPermissionTypes.isEmpty()) {
            return SimpleValidationResult.VALID;
        }
        String errorMessage = String.format("The following permissions couldn't be set to %s: %s", subject, String.join((CharSequence)", ", invalidPermissionTypes));
        return this.createValidationResultWithError(errorMessage);
    }
}

