/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions.validation;

import com.atlassian.confluence.api.impl.service.permissions.validation.AbstractPermissionsValidator;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class SpacePermissionsValidator
extends AbstractPermissionsValidator {
    public ValidationResult validateViewSpacePermissionExistsForUser(Space entitySpace, Collection<SpacePermission> permissionsToAdd, ConfluenceUser user) {
        return this.validateGuardPermissionExistsForUser(permissionsToAdd, entitySpace.getPermissions(), "VIEWSPACE", user);
    }

    public ValidationResult validateViewSpacePermissionExistsForGroup(Space entitySpace, Collection<SpacePermission> permissionsToAdd, String groupName) {
        return this.validateGuardPermissionExistsForGroup(permissionsToAdd, entitySpace.getPermissions(), "VIEWSPACE", groupName);
    }

    public ValidationResult validateViewSpacePermissionExistsForAnonymousUser(Space entitySpace, Collection<SpacePermission> permissionsToAdd) {
        return this.validateGuardPermissionExistsForAnonymousUsers(permissionsToAdd, entitySpace.getPermissions(), "VIEWSPACE");
    }

    public ValidationResult validateAtLeastOneAdminPermissionExists(Space entitySpace, Set<SpacePermission> permissionsToRemove) {
        if (permissionsToRemove.isEmpty()) {
            return SimpleValidationResult.VALID;
        }
        Set existingAdminPermission = entitySpace.getPermissions().stream().filter(perm -> "SETSPACEPERMISSIONS".equals(perm.getType())).collect(Collectors.toSet());
        Set removedAdminPermission = permissionsToRemove.stream().filter(perm -> "SETSPACEPERMISSIONS".equals(perm.getType())).collect(Collectors.toSet());
        return existingAdminPermission.size() > removedAdminPermission.size() ? SimpleValidationResult.VALID : this.createValidationResultWithError("You are not allowed to remove all the Administration Permissions for this space.");
    }

    public ValidationResult validateViewSpacePermissionWillBeAdded(Collection<SpacePermission> permissionsToAdd) {
        return this.createGuardPermissionValidationResult(this.guardPermissionWillBeAdded(permissionsToAdd, "VIEWSPACE"), "VIEWSPACE");
    }
}

