/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.settings;

import com.atlassian.bandana.dmz.BandanaManagerInternal;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.settings.BandanaPluginSettings;
import com.atlassian.confluence.impl.settings.ConfluencePluginSettings;
import com.atlassian.confluence.impl.settings.DelegatingPluginSettings;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ConfluencePluginSettingsFactory
implements ExtendedPluginSettingsFactory {
    private static final String GLOBAL_NAMESPACE = ConfluenceBandanaContext.GLOBAL_CONTEXT.getContextKey();
    private final PluginSettingRepository repository;
    private final BandanaManagerInternal bandanaManager;
    private final BooleanSupplier isUpgraded;

    public ConfluencePluginSettingsFactory(PluginSettingRepository repository, BandanaManagerInternal bandanaManager, BooleanSupplier isPluginSettingsCreatedRef) {
        this.repository = repository;
        this.bandanaManager = bandanaManager;
        this.isUpgraded = isPluginSettingsCreatedRef;
    }

    public ExtendedPluginSettings createSettingsForKey(String namespace) {
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return this.createGlobalSettings();
        }
        Validate.inclusiveBetween((long)1L, (long)255L, (long)namespace.length());
        ConfluencePluginSettings pluginSettings = new ConfluencePluginSettings(this.repository, namespace);
        if (!this.isUpgraded.getAsBoolean()) {
            BandanaPluginSettings legacySettings = new BandanaPluginSettings(this.bandanaManager, namespace);
            return new DelegatingPluginSettings(() -> this.lambda$createSettingsForKey$0((ExtendedPluginSettings)pluginSettings, legacySettings));
        }
        return pluginSettings;
    }

    public ExtendedPluginSettings createGlobalSettings() {
        return this.createSettingsForKey(GLOBAL_NAMESPACE);
    }

    private /* synthetic */ ExtendedPluginSettings lambda$createSettingsForKey$0(ExtendedPluginSettings pluginSettings, BandanaPluginSettings legacySettings) {
        return this.isUpgraded.getAsBoolean() ? pluginSettings : legacySettings;
    }
}

