/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.settings;

import com.atlassian.confluence.api.model.people.UserSettings;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotAuthenticatedException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.settings.UserSettingsService;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.user.User;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettingsServiceImpl
implements UserSettingsService {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsServiceImpl.class);
    private final LanguageManager languageManager;
    private final LocaleManager localeManager;
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    protected static final String DEFAULT_KEY = "None";

    public UserSettingsServiceImpl(UserAccessor userAccessor, LanguageManager languageManager, LocaleManager localeManager, PermissionManager permissionManager) {
        this.languageManager = languageManager;
        this.localeManager = localeManager;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
    }

    private void updateLocaleSetting(ConfluenceUser updateUser, String locale) {
        try {
            UserPreferences userPreferences = this.userAccessor.getUserPreferences(updateUser);
            if (DEFAULT_KEY.equals(locale)) {
                userPreferences.remove("confluence.user.locale");
            } else {
                Language language = this.languageManager.getLanguage(locale);
                if (language == null) {
                    throw new BadRequestException("Invalid or unsupported locale: " + locale);
                }
                userPreferences.setString("confluence.user.locale", locale);
            }
            this.localeManager.invalidateLocaleInfoCache((User)updateUser);
        }
        catch (UserPreferences.PreferenceException e) {
            throw new BadRequestException("Unable to save locale for " + updateUser.getName(), (Throwable)e);
        }
    }

    public void updateUserSettings(UserSettings userSettings) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null) {
            throw new NotAuthenticatedException("User not authenticated");
        }
        if (StringUtils.isBlank((CharSequence)userSettings.getUsername())) {
            throw new BadRequestException("Username is required");
        }
        ConfluenceUser targetUser = this.userAccessor.getUserByName(userSettings.getUsername());
        if (targetUser == null) {
            throw new BadRequestException("User not found: " + userSettings.getUsername());
        }
        if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)targetUser)) {
            throw new PermissionException("User does not have permission to update settings");
        }
        if (userSettings.getLocale() != null && !StringUtils.isBlank((CharSequence)userSettings.getLocale())) {
            this.updateLocaleSetting(targetUser, userSettings.getLocale().trim());
        }
    }
}

