/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.watch;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.model.watch.ContentWatch;
import com.atlassian.confluence.api.model.watch.SpaceWatch;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.api.service.watch.WatchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class WatchServiceImpl
implements WatchService {
    private static final Logger logger = LoggerFactory.getLogger(WatchServiceImpl.class);
    private final ConfluenceUserResolver confluenceUserResolver;
    private final PermissionManager permissionManager;
    private final NotificationManager notificationManager;
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final ContentEntityManager contentEntityManager;
    private final ContentService contentService;
    private final AccessModeService accessModeService;
    private final PersonFactory personFactory;
    private final PaginationService paginationService;

    public WatchServiceImpl(ConfluenceUserResolver confluenceUserResolver, PermissionManager permissionManager, NotificationManager notificationManager, SpaceManager spaceManager, SpaceService spaceService, ContentEntityManager contentEntityManager, ContentService contentService, AccessModeService accessModeService, PersonFactory personFactory, PaginationService paginationService) {
        this.confluenceUserResolver = confluenceUserResolver;
        this.permissionManager = permissionManager;
        this.notificationManager = notificationManager;
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.contentEntityManager = contentEntityManager;
        this.contentService = contentService;
        this.accessModeService = accessModeService;
        this.personFactory = personFactory;
        this.paginationService = paginationService;
    }

    public boolean isWatchingSpace(UserKey userKey, String spaceKey, ContentType contentType) {
        logger.debug("isWatchingContentInSpace: space: {} contentType: {}", (Object)spaceKey, (Object)contentType);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        if (user == null) {
            return false;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new NotFoundException();
        }
        this.canView(user, space).throwIfNotSuccessful("User not permitted to view space");
        Notification notification = this.notificationManager.getNotificationByUserAndSpaceAndType((User)user, space, ContentTypeEnum.getByRepresentation((String)contentType.getType()));
        return notification != null;
    }

    public final @NonNull SpaceWatch watchSpace(UserKey userKey, String spaceKey, List<ContentType> contentTypes) {
        logger.debug("watchSpace: space: {}", (Object)spaceKey);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        Space space = this.spaceManager.getSpace(spaceKey);
        this.enforceReadOnlyAccess();
        if (space == null) {
            throw new NotFoundException();
        }
        this.canView(user, space).throwIfNotSuccessful("User not permitted to view space");
        if (contentTypes.isEmpty()) {
            this.notificationManager.addSpaceNotification((User)user, space);
        } else if (contentTypes.contains(ContentType.BLOG_POST)) {
            this.notificationManager.addSpaceNotification((User)user, space, ContentTypeEnum.getByRepresentation((String)ContentType.BLOG_POST.getType()));
        } else {
            throw new ServiceException("The list must contain ContentType.BLOG_POST");
        }
        return new SpaceWatch(KnownUser.fromUserkey((UserKey)userKey), spaceKey, contentTypes);
    }

    public final @NonNull SpaceWatch watchSpace(UserKey userKey, String spaceKey) {
        return this.watchSpace(userKey, spaceKey, new ArrayList<ContentType>());
    }

    public final void unwatchSpace(UserKey userKey, String spaceKey, List<ContentType> contentTypes) {
        logger.debug("unwatchSpace: space: {}", (Object)spaceKey);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        Space space = this.spaceManager.getSpace(spaceKey);
        this.enforceReadOnlyAccess();
        if (space == null) {
            throw new NotFoundException();
        }
        this.canView(user, space).throwIfNotSuccessful("User not permitted to view space");
        if (contentTypes.isEmpty()) {
            this.notificationManager.removeSpaceNotification((User)user, space);
        } else if (contentTypes.contains(ContentType.BLOG_POST)) {
            Notification notification = this.notificationManager.getNotificationByUserAndSpaceAndType((User)user, space, ContentTypeEnum.getByRepresentation((String)ContentType.BLOG_POST.getType()));
            if (notification != null) {
                this.notificationManager.removeNotification(notification);
            }
        } else {
            throw new ServiceException("The list must contain ContentType.BLOG_POST");
        }
    }

    public final void unwatchSpace(UserKey userKey, String spaceKey) {
        this.unwatchSpace(userKey, spaceKey, new ArrayList<ContentType>());
    }

    public final boolean isWatchingSpace(UserKey userKey, String spaceKey) {
        logger.debug("isWatchingSpace: space: {}", (Object)spaceKey);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        if (user == null) {
            return false;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new NotFoundException();
        }
        this.canView(user, space).throwIfNotSuccessful("User not permitted to view space");
        return this.notificationManager.isUserWatchingPageOrSpace((User)user, space, null);
    }

    public final ContentWatch watchContent(UserKey userKey, ContentId contentId) {
        logger.debug("watchContent: content: {}", (Object)contentId);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        ContentEntityObject content = this.contentEntityManager.getById(contentId.asLong());
        this.enforceReadOnlyAccess();
        if (content == null) {
            throw new NotFoundException();
        }
        this.canView(user, content).throwIfNotSuccessful("User not permitted to view content");
        this.notificationManager.addContentNotification((User)user, content);
        return new ContentWatch(KnownUser.fromUserkey((UserKey)userKey), contentId);
    }

    public final void unwatchContent(UserKey userKey, ContentId contentId) {
        logger.debug("unwatchContent: content: {}", (Object)contentId);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        ContentEntityObject content = this.contentEntityManager.getById(contentId.asLong());
        this.enforceReadOnlyAccess();
        if (content == null) {
            throw new NotFoundException();
        }
        this.canView(user, content).throwIfNotSuccessful("User not permitted to view content");
        this.notificationManager.removeContentNotification((User)user, content);
    }

    public final boolean isWatchingContent(UserKey userKey, ContentId contentId) {
        logger.debug("isWatchingContent: content: {}", (Object)contentId);
        ConfluenceUser user = this.findUserByUserKey(userKey);
        if (user == null) {
            return false;
        }
        ContentEntityObject content = this.contentEntityManager.getById(contentId.asLong());
        if (content == null) {
            throw new NotFoundException();
        }
        this.canView(user, content).throwIfNotSuccessful("User not permitted to view content");
        return this.notificationManager.isWatchingContent((User)user, content);
    }

    public PageResponse<com.atlassian.confluence.api.model.people.User> findUsersWatchingSpacePaginated(String spaceKey, PageRequest pageRequest) {
        this.validator().validateFindUsersWatchingSpacePaginated(spaceKey).throwIfNotSuccessful();
        Space space = this.spaceManager.getSpace(spaceKey);
        Set users = this.notificationManager.getNotificationsBySpaceAndType(space, null).stream().map(Notification::getReceiver).collect(Collectors.toSet());
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.users());
        return this.paginationService.performPaginationListRequest(limitedRequest, request -> PageResponseImpl.from((Iterable)users, (users.size() > limitedRequest.getLimit() ? 1 : 0) != 0).pageRequest(limitedRequest).build(), confluenceUsers -> users.stream().map(this.personFactory::fromUser).collect(Collectors.toList()));
    }

    public PageResponse<com.atlassian.confluence.api.model.people.User> findUsersWatchingContentPaginated(ContentId contentId, PageRequest pageRequest) {
        this.validator().validateFindUsersWatchingContentPaginated(contentId).throwIfNotSuccessful();
        ContentEntityObject content = this.contentEntityManager.getById(contentId.asLong());
        Set users = this.notificationManager.getNotificationsByContent(content).stream().map(Notification::getReceiver).collect(Collectors.toSet());
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.users());
        return this.paginationService.performPaginationListRequest(limitedRequest, request -> PageResponseImpl.from((Iterable)users, (users.size() > limitedRequest.getLimit() ? 1 : 0) != 0).pageRequest(limitedRequest).build(), confluenceUsers -> users.stream().map(this.personFactory::fromUser).collect(Collectors.toList()));
    }

    private @Nullable ConfluenceUser findUserByUserKey(UserKey userKey) {
        return this.confluenceUserResolver.getExistingUserByKey(userKey);
    }

    private ValidationResult canView(ConfluenceUser user, Object target) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null || !confluenceUser.equals((Object)user) && !this.permissionManager.isConfluenceAdministrator(confluenceUser) || !this.permissionManager.hasPermission(user, Permission.VIEW, target)) {
            return SimpleValidationResult.FORBIDDEN;
        }
        return SimpleValidationResult.VALID;
    }

    private void enforceReadOnlyAccess() {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            throw new ReadOnlyException();
        }
    }

    public WatchService.Validator validator() {
        return new ValidatorImpl();
    }

    public class ValidatorImpl
    implements WatchService.Validator {
        public final ValidationResult validateWatchSpace(UserKey userKey, String spaceKey) {
            return (ValidationResult)WatchServiceImpl.this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().flatMap(item -> this.checkPermissions((User)WatchServiceImpl.this.findUserByUserKey(userKey))).orElseThrow(NotFoundException::new);
        }

        public final ValidationResult validateWatchContent(UserKey userKey, ContentId contentId) {
            return (ValidationResult)WatchServiceImpl.this.contentService.find(new Expansion[0]).withId(contentId).fetch().flatMap(item -> this.checkPermissions((User)WatchServiceImpl.this.findUserByUserKey(userKey))).orElseThrow(NotFoundException::new);
        }

        public ValidationResult validateFindUsersWatchingSpacePaginated(String spaceKey) {
            if (WatchServiceImpl.this.accessModeService.shouldEnforceReadOnlyAccess()) {
                return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
            }
            Space space = WatchServiceImpl.this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new NotFoundException();
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (!WatchServiceImpl.this.permissionManager.isConfluenceAdministrator(user) && !WatchServiceImpl.this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space)) {
                return SimpleValidationResult.FORBIDDEN;
            }
            return SimpleValidationResult.VALID;
        }

        public ValidationResult validateFindUsersWatchingContentPaginated(ContentId contentId) {
            ConfluenceUser user;
            if (WatchServiceImpl.this.accessModeService.shouldEnforceReadOnlyAccess()) {
                return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
            }
            ContentEntityObject content = WatchServiceImpl.this.contentEntityManager.getById(contentId.asLong());
            if (content == null) {
                throw new NotFoundException();
            }
            if (content instanceof SpaceContentEntityObject && !WatchServiceImpl.this.permissionManager.isConfluenceAdministrator(user = AuthenticatedUserThreadLocal.get()) && !WatchServiceImpl.this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)((SpaceContentEntityObject)content).getSpace())) {
                return SimpleValidationResult.FORBIDDEN;
            }
            if (!(content instanceof BlogPost) && !(content instanceof Page)) {
                return SimpleValidationResult.builder().authorized(true).addError("Only BlogPost and Page are supported Content.", new Object[0]).build();
            }
            return SimpleValidationResult.VALID;
        }

        private Optional<ValidationResult> checkPermissions(User user) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            if (confluenceUser == null || !confluenceUser.equals((Object)user) && !WatchServiceImpl.this.permissionManager.isConfluenceAdministrator(confluenceUser)) {
                return Optional.of(SimpleValidationResult.FORBIDDEN);
            }
            if (WatchServiceImpl.this.accessModeService.shouldEnforceReadOnlyAccess()) {
                return Optional.of(SimpleValidationResult.builder().authorized(true).allowedInReadOnlyMode(false).build());
            }
            return Optional.of(SimpleValidationResult.VALID);
        }
    }
}

