/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.GlobalPermissionCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.SpaceJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SubscriptionJournalStateStore;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupMembershipJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.IncrementalSyncUtil;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncSubscription;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionEventType;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.atlassian.crowd.model.membership.MembershipType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class CommandSupport
implements ContentCommandSupport,
UserGroupCommandSupport,
GlobalPermissionCommandSupport {
    private static final Logger logger = LoggerFactory.getLogger(CommandSupport.class);
    private final JournalService journalService;
    private final ObjectMapper objectMapper;
    private final SubscriptionJournalStateStore subscriptionJournalStateStore;
    private static Map<ContentType, SubscriptionEventType> mapContentTypeToSubscriptionType = Map.of(ContentType.PAGE, SubscriptionEventType.PAGE_EVENT, ContentType.BLOG_POST, SubscriptionEventType.BLOGPOST_EVENT, ContentType.COMMENT, SubscriptionEventType.COMMENT_EVENT, ContentType.ATTACHMENT, SubscriptionEventType.ATTACHMENT_EVENT);

    public CommandSupport(JournalService journalService) {
        this(journalService, null);
    }

    public CommandSupport(JournalService journalService, @Nullable SubscriptionJournalStateStore subscriptionJournalStateStore) {
        this.journalService = journalService;
        this.subscriptionJournalStateStore = subscriptionJournalStateStore;
        this.objectMapper = new DefaultObjectMapperProvider().getObjectMapper();
    }

    @Override
    public boolean validateContentManagementCommandParam(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            logger.error("No subscription id found");
            return false;
        }
        if (!(parameters[0] instanceof SubscriptionId)) {
            logger.error("No subscription id found");
            return false;
        }
        return true;
    }

    @Override
    public long enqueueForUserManagement(String journalType, JournalMessage journalMessage) {
        if (journalMessage != null) {
            return this.enqueue("u_g_inc_sync", journalType, journalMessage);
        }
        return -1L;
    }

    @Override
    public long enqueueForContentManagement(SingleSubscriptionPerJournalIdentifier singleSubscriptionPerJournalIdentifier, String journalType, JournalMessage journalMessage) {
        if (this.subscriptionJournalStateStore == null) {
            throw new UnsupportedOperationException("enqueueForContentManagement is not supported when subscription state store is null");
        }
        Optional<IncrementalSyncSubscription> subscriptionJournalStateStoreOptional = this.subscriptionJournalStateStore.getSubscriptionStateData(singleSubscriptionPerJournalIdentifier);
        if (subscriptionJournalStateStoreOptional.isEmpty()) {
            logger.error("No subscription state found for {}. Cannot enqueue for content {}", (Object)singleSubscriptionPerJournalIdentifier, (Object)journalMessage);
            return -1L;
        }
        IncrementalSyncSubscription subscription = subscriptionJournalStateStoreOptional.get();
        List<SubscriptionEventType> subscribeEventTypes = IncrementalSyncUtil.convertStringToEnumList(subscription.getSubscriptionData());
        if (journalMessage instanceof ContentJournalMessage) {
            ContentJournalMessage contentJournalMessage = (ContentJournalMessage)journalMessage;
            if (!subscribeEventTypes.contains(mapContentTypeToSubscriptionType.get(contentJournalMessage.getContentType()))) {
                logger.debug("Don't support content type {} for subscription {}", (Object)contentJournalMessage.getContentType(), (Object)singleSubscriptionPerJournalIdentifier.getSubscriptionId());
                return -1L;
            }
        } else if (journalMessage instanceof SpaceJournalMessage) {
            SpaceJournalMessage spaceJournalMessage = (SpaceJournalMessage)journalMessage;
            if (!subscribeEventTypes.contains(SubscriptionEventType.SPACE_EVENT)) {
                logger.debug("Don't supports space content type with id {} for subscription {}", (Object)spaceJournalMessage.getSpaceId(), (Object)singleSubscriptionPerJournalIdentifier.getSubscriptionId());
                return -1L;
            }
        }
        return this.enqueue(singleSubscriptionPerJournalIdentifier.getJournalName(), journalType, journalMessage);
    }

    public long enqueue(String journalName, String journalType, JournalMessage journalMessage) {
        try {
            String messageStr = this.objectMapper.writeValueAsString((Object)journalMessage);
            return this.journalService.enqueue(new JournalEntry(new JournalIdentifier(journalName), journalType, messageStr));
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to serialize event journal message", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public <T> Optional<T> deserializeJournalMessage(Class<T> clazz, JournalEntry entry) {
        try {
            Object journalMessage = this.objectMapper.readerFor(clazz).readValue(entry.getMessage());
            return Optional.of(journalMessage);
        }
        catch (Exception e) {
            logger.error("Failed to deserialize journal message for UserCreatedCommand", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void addGroupMembershipForUser(String groupName, long timestamp, String userKey) {
        GroupMembershipJournalMessage userMembershipAddedJournalMessage = new GroupMembershipJournalMessage(timestamp, groupName, List.of(userKey), MembershipType.GROUP_USER);
        this.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.GROUP_MEMBERSHIPS_CREATED_ENTRY), userMembershipAddedJournalMessage);
    }

    @Override
    public void removeGroupMembershipForUser(String groupName, long timestamp, String userKey) {
        GroupMembershipJournalMessage userMembershipRemovedJournalMessage = new GroupMembershipJournalMessage(timestamp, groupName, List.of(userKey), MembershipType.GROUP_USER);
        this.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.GROUP_MEMBERSHIPS_DELETED_ENTRY), userMembershipRemovedJournalMessage);
    }

    @Override
    public void removeGroupMembershipForGroup(String childGroupName, long timestamp, String parentGroupName) {
        GroupMembershipJournalMessage groupMembershipRemovedJournalMessage = new GroupMembershipJournalMessage(timestamp, parentGroupName, List.of(childGroupName), MembershipType.GROUP_GROUP);
        this.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.GROUP_MEMBERSHIPS_DELETED_ENTRY), groupMembershipRemovedJournalMessage);
    }

    @Override
    public long enqueueForGlobalPermission(String journalType, JournalMessage journalMessage) {
        if (journalMessage != null) {
            return this.enqueue("g_perm_inc_sync", journalType, journalMessage);
        }
        return -1L;
    }
}

