/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.like.AbstractLikeEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.ContentFilteringUtils;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLikeCommand<E extends AbstractLikeEvent>
implements Command<E, ContentManagementIncSyncModel>,
CommandCreator<E, ContentManagementIncSyncModel> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ContentCommandSupport commandSupport;
    protected final ContentService contentService;
    protected final SpaceFilteringService spaceFilteringService;

    protected AbstractLikeCommand(ContentCommandSupport commandSupport, ContentService contentService, SpaceFilteringService spaceFilteringService) {
        this.commandSupport = commandSupport;
        this.contentService = contentService;
        this.spaceFilteringService = spaceFilteringService;
    }

    public void processEvent(E event, Object ... parameters) {
        SubscriptionId subscriptionId = (SubscriptionId)parameters[0];
        SingleSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = new SingleSubscriptionPerJournalIdentifier("c_g_inc_sync", subscriptionId);
        ContentEntityObject ceo = event.getContent();
        ContentJournalMessage message = new ContentJournalMessage(Instant.now().toEpochMilli(), ceo.getId(), ContentType.valueOf((String)ceo.getType()));
        this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)ContentJournalEntryTypes.CONTENT_UPDATED_ENTRY), message);
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        this.logger.error("{} does not support processing journal entries. Journal entries should be processed by ContentUpdateCommand", (Object)this.getClass().getSimpleName());
        return List.of();
    }

    public Predicate<E> shouldProcess() {
        return ContentFilteringUtils.errorSwallowingPredicate(likeEvent -> ContentFilteringUtils.isAllowed(likeEvent.getContent(), this.spaceFilteringService));
    }

    public Optional<Command<E, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return Optional.empty();
    }
}

