/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.event.events.space.SpaceArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.space.SpaceLogoUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceUnArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentExpansions;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands.ContentManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.SpaceJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.SpaceModel;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.ContentFilteringUtils;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class SpaceEventsCommand
extends ContentManagementMultiEventsCommand<SpaceEvent> {
    private final SpaceService spaceService;
    private final SpaceFilteringService spaceFilteringService;

    public SpaceEventsCommand(ContentCommandSupport commandSupport, SpaceService spaceService, SpaceFilteringService spaceFilteringService) {
        super(commandSupport);
        this.spaceService = spaceService;
        this.spaceFilteringService = spaceFilteringService;
    }

    @Override
    protected Map<Class<? extends SpaceEvent>, ContentJournalEntryTypes> getSupportedEventEntryTypesMap() {
        if (this.supportedEventEntryTypesMap == null) {
            this.supportedEventEntryTypesMap = Map.of(SpaceCreateEvent.class, ContentJournalEntryTypes.SPACE_CREATED_ENTRY, SpaceArchivedEvent.class, ContentJournalEntryTypes.SPACE_ARCHIVED_ENTRY, SpaceUnArchivedEvent.class, ContentJournalEntryTypes.SPACE_UNARCHIVED_ENTRY, SpaceLogoUpdateEvent.class, ContentJournalEntryTypes.SPACE_LOGO_UPDATED_ENTRY, SpaceUpdateEvent.class, ContentJournalEntryTypes.SPACE_UPDATED_ENTRY);
        }
        return this.supportedEventEntryTypesMap;
    }

    @Override
    protected List<JournalMessage> createMessages(SpaceEvent event) {
        Space space = event.getSpace();
        return List.of(new SpaceJournalMessage(space.getId(), space.getKey()));
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<ContentManagementIncSyncModel> spaceCreateModels = new ArrayList<ContentManagementIncSyncModel>();
        HashMap<Long, JournalEntry> spaceWithIcons = new HashMap<Long, JournalEntry>();
        HashMap<Long, JournalEntry> spaceWithoutIcons = new HashMap<Long, JournalEntry>();
        for (JournalEntry journalEntry : journalEntries) {
            this.commandSupport.deserializeJournalMessage(SpaceJournalMessage.class, journalEntry).ifPresent(spaceCreateJournalMessage -> {
                if (journalEntry.getType().equals(ContentJournalEntryTypes.SPACE_LOGO_UPDATED_ENTRY.name())) {
                    spaceWithIcons.put(spaceCreateJournalMessage.getSpaceId(), journalEntry);
                } else {
                    spaceWithoutIcons.put(spaceCreateJournalMessage.getSpaceId(), journalEntry);
                }
            });
        }
        spaceCreateModels.addAll(this.loadSpaces(spaceWithIcons, ContentExpansions.spaceExpansionsWithIcon()));
        spaceCreateModels.addAll(this.loadSpaces(spaceWithoutIcons, ContentExpansions.spaceExpansions()));
        spaceCreateModels.sort(Comparator.comparing(ContentManagementIncSyncModel::getJournalEntryId));
        return spaceCreateModels;
    }

    private Collection<ContentManagementIncSyncModel> loadSpaces(Map<Long, JournalEntry> spaceIdToJournalEntry, Expansion ... expansions) {
        if (spaceIdToJournalEntry == null || spaceIdToJournalEntry.isEmpty()) {
            return new ArrayList<ContentManagementIncSyncModel>();
        }
        PageResponse spaceModels = this.spaceService.find(expansions).withIds(spaceIdToJournalEntry.keySet()).fetchMany((PageRequest)new SimplePageRequest(0, spaceIdToJournalEntry.size()));
        return spaceModels.getResults().stream().map(space -> {
            JournalEntry journalEntry = (JournalEntry)spaceIdToJournalEntry.get(space.getId());
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            if (entryType == ContentJournalEntryTypes.SPACE_CREATED_ENTRY) {
                return ContentFilteringUtils.createSpaceModel(journalEntry, ContentModelType.CONTENT_MANAGEMENT_SPACE, entryType, space, this.spaceFilteringService);
            }
            return new SpaceModel(journalEntry.getId(), ContentModelType.CONTENT_MANAGEMENT_SPACE.getName(), entryType.getJsonModelOperation().getName(), (com.atlassian.confluence.api.model.content.Space)space);
        }).toList();
    }

    public Predicate<SpaceEvent> shouldProcess() {
        return event -> {
            if (event instanceof SpaceCreateEvent) {
                return true;
            }
            return !this.spaceFilteringService.isExcluded(event.getSpace().getKey());
        };
    }

    public Optional<Command<SpaceEvent, ContentManagementIncSyncModel>> newCommand(SpaceEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new SpaceEventsCommand(this.commandSupport, this.spaceService, this.spaceFilteringService)) : Optional.empty();
    }

    public Optional<Command<SpaceEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new SpaceEventsCommand(this.commandSupport, this.spaceService, this.spaceFilteringService));
    }
}

