/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.SpaceJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.ContentFilteringUtils;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceImportCommand
implements Command<AsyncImportFinishedEvent, ContentManagementIncSyncModel>,
CommandCreator<AsyncImportFinishedEvent, ContentManagementIncSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(SpaceImportCommand.class);
    private final SpaceManagerInternal spaceManager;
    private final SpaceService spaceService;
    private final SpaceFilteringService spaceFilteringService;
    private ContentCommandSupport commandSupport;

    public SpaceImportCommand(ContentCommandSupport commandSupport, SpaceManagerInternal spaceManager, SpaceService spaceService, SpaceFilteringService spaceFilteringService) {
        this.commandSupport = commandSupport;
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.spaceFilteringService = spaceFilteringService;
    }

    public void processEvent(AsyncImportFinishedEvent event, Object ... parameters) {
        if (event == null || event.isSiteImport() || event.getImportContext() == null) {
            logger.debug("AsyncImportFinishedEvent is not valid");
            return;
        }
        if (!this.commandSupport.validateContentManagementCommandParam(parameters)) {
            logger.debug("Validate parameters failed when processing event {}", (Object)event);
            return;
        }
        SubscriptionId subscriptionId = (SubscriptionId)parameters[0];
        SingleSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = new SingleSubscriptionPerJournalIdentifier("c_g_inc_sync", subscriptionId);
        String spaceKeyOfSpaceImport = event.getImportContext().getSpaceKeyOfSpaceImport();
        Space space = this.spaceManager.getSpace(spaceKeyOfSpaceImport);
        if (space == null) {
            return;
        }
        SpaceJournalMessage journalMessage = new SpaceJournalMessage(space.getId(), space.getKey());
        this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)ContentJournalEntryTypes.SPACE_RESTORED_ENTRY), journalMessage);
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<ContentManagementIncSyncModel> result = new ArrayList<ContentManagementIncSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<SpaceJournalMessage> journalMessage = this.commandSupport.deserializeJournalMessage(SpaceJournalMessage.class, journalEntry);
            if (journalMessage.isEmpty()) {
                logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                continue;
            }
            SpaceJournalMessage spaceImportJournalMessage = journalMessage.orElseThrow();
            ContentManagementIncSyncModel spaceModel = this.loadSpace(spaceImportJournalMessage.getSpaceId(), journalEntry);
            if (spaceModel == null) {
                logger.error("Could not found space with Id [{}]", (Object)spaceImportJournalMessage.getSpaceId());
                continue;
            }
            result.add(spaceModel);
        }
        return result;
    }

    private ContentManagementIncSyncModel loadSpace(long spaceId, JournalEntry journalEntry) {
        Optional space = this.spaceService.find(new Expansion[0]).withIds(Collections.singleton(spaceId)).fetch();
        ContentJournalEntryTypes contentJournalEntryTypes = ContentJournalEntryTypes.valueOf(journalEntry.getType());
        return space.map(value -> ContentFilteringUtils.createSpaceModel(journalEntry, ContentModelType.CONTENT_MANAGEMENT_SPACE_RESTORE, contentJournalEntryTypes, value, this.spaceFilteringService)).orElse(null);
    }

    public Predicate<AsyncImportFinishedEvent> shouldProcess() {
        return ContentFilteringUtils.alwaysAllowed();
    }

    public Optional<Command<AsyncImportFinishedEvent, ContentManagementIncSyncModel>> newCommand(AsyncImportFinishedEvent event) {
        return Optional.of(new SpaceImportCommand(this.commandSupport, this.spaceManager, this.spaceService, this.spaceFilteringService));
    }

    public Optional<Command<AsyncImportFinishedEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        if (!ContentJournalEntryTypes.SPACE_RESTORED_ENTRY.name().equals(journalEntry.getType())) {
            return Optional.empty();
        }
        return Optional.of(new SpaceImportCommand(this.commandSupport, this.spaceManager, this.spaceService, this.spaceFilteringService));
    }
}

