/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.SpacePermission;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.atlassian.confluence.event.events.permission.SpacePermissionChangeEvent;
import com.atlassian.confluence.event.events.permission.SpacePermissionRemoveEvent;
import com.atlassian.confluence.event.events.permission.SpacePermissionSaveEvent;
import com.atlassian.confluence.impl.security.access.SpacePermissionSubjectType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands.ContentManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.SpacePermissionJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.SpacePermissionModel;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.ContentFilteringUtils;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class SpacePermissionChangeCommand
extends ContentManagementMultiEventsCommand<SpacePermissionChangeEvent> {
    private static final String SPACE_PERMISSION_EVENT = "spacePermissionEvent";
    private final SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter;
    private final SpaceService spaceService;
    private final SpaceFilteringService spaceFilteringService;

    public SpacePermissionChangeCommand(ContentCommandSupport commandSupport, SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter, SpaceService spaceService, SpaceFilteringService spaceFilteringService) {
        super(commandSupport);
        this.spacePermissionOperationKeyConverter = spacePermissionOperationKeyConverter;
        this.spaceService = spaceService;
        this.spaceFilteringService = spaceFilteringService;
    }

    @Override
    protected Map<Class<? extends SpacePermissionChangeEvent>, ContentJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return Map.of(SpacePermissionSaveEvent.class, ContentJournalEntryTypes.SPACE_PERMISSION_CREATED_ENTRY, SpacePermissionRemoveEvent.class, ContentJournalEntryTypes.SPACE_PERMISSION_DELETED_ENTRY);
    }

    @Override
    protected List<JournalMessage> createMessages(SpacePermissionChangeEvent event) {
        long spaceId;
        if (!this.getSupportedEventEntryTypesMap().containsKey(event.getClass())) {
            return Collections.emptyList();
        }
        com.atlassian.confluence.security.SpacePermission permission = (com.atlassian.confluence.security.SpacePermission)event.getPermissions().iterator().next();
        if (event instanceof SpacePermissionRemoveEvent) {
            SpacePermissionRemoveEvent spacePermissionRemoveEvent = (SpacePermissionRemoveEvent)event;
            v0 = spacePermissionRemoveEvent.getSpace().getId();
        } else {
            v0 = spaceId = permission.getSpaceId();
        }
        if (permission.isUserPermission()) {
            return Optional.ofNullable(permission.getUserSubject()).map(ConfluenceUser::getKey).map(userKey -> List.of(new SpacePermissionJournalMessage(permission.getType(), userKey.getStringValue(), SpacePermissionSubjectType.USER, spaceId))).orElse(Collections.emptyList());
        }
        if (permission.isGroupPermission()) {
            return List.of(new SpacePermissionJournalMessage(permission.getType(), permission.getGroup(), SpacePermissionSubjectType.GROUP, spaceId));
        }
        if (permission.isAnonymousPermission()) {
            return List.of(new SpacePermissionJournalMessage(permission.getType(), null, SpacePermissionSubjectType.ANONYMOUS, spaceId));
        }
        if (permission.isAuthenticatedUsersPermission()) {
            return List.of(new SpacePermissionJournalMessage(permission.getType(), null, SpacePermissionSubjectType.ALL_AUTHENTICATED_USERS, spaceId));
        }
        this.logger.debug("Failed to convert permission to journal message {}", (Object)permission);
        return Collections.emptyList();
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<ContentManagementIncSyncModel> result = new ArrayList<ContentManagementIncSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<SpacePermissionJournalMessage> journalMessage = this.commandSupport.deserializeJournalMessage(SpacePermissionJournalMessage.class, journalEntry);
            if (journalMessage.isEmpty()) {
                this.logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                continue;
            }
            SpacePermissionJournalMessage spacePermissionJournalMessage = journalMessage.orElseThrow();
            SpacePermissionModel spacePermissionModel = this.getSpacePermissionModel(journalEntry, spacePermissionJournalMessage);
            result.add(spacePermissionModel);
        }
        return result;
    }

    private SpacePermissionModel getSpacePermissionModel(JournalEntry journalEntry, SpacePermissionJournalMessage journalMessage) {
        OperationDescription operationDescription = this.spacePermissionOperationKeyConverter.toOperation(journalMessage.getPermissionType());
        SpacePermission spacePermission = new SpacePermission();
        spacePermission.setOperation(operationDescription);
        spacePermission.setSpaceId(journalMessage.getSpaceId());
        Subject subject = this.getSubjectFromJournalMessage(journalMessage);
        spacePermission.setSubject(subject);
        Space space = this.getSpace(journalMessage.getSpaceId());
        spacePermission.setSpaceKey(space.getKey());
        ContentJournalEntryTypes contentJournalEntryTypes = ContentJournalEntryTypes.valueOf(journalEntry.getType());
        return new SpacePermissionModel(journalEntry.getId(), SPACE_PERMISSION_EVENT, contentJournalEntryTypes.getJsonModelOperation().getName(), spacePermission);
    }

    private Subject getSubjectFromJournalMessage(SpacePermissionJournalMessage journalMessage) {
        return switch (journalMessage.getSubjectType()) {
            default -> throw new MatchException(null, null);
            case SpacePermissionSubjectType.GROUP -> new Group(journalMessage.getSubject());
            case SpacePermissionSubjectType.USER -> User.fromUserkey((UserKey)new UserKey(journalMessage.getSubject()));
            case SpacePermissionSubjectType.ALL_AUTHENTICATED_USERS -> new UnknownUser(null, null);
            case SpacePermissionSubjectType.ANONYMOUS -> Anonymous.builder().build();
        };
    }

    private Space getSpace(long spaceId) {
        return (Space)this.spaceService.find(new Expansion[0]).withIds(Set.of(Long.valueOf(spaceId))).fetch().orElseThrow();
    }

    public Predicate<SpacePermissionChangeEvent> shouldProcess() {
        return ContentFilteringUtils.errorSwallowingPredicate(spacePermissionChangeEvent -> {
            String string;
            com.atlassian.confluence.security.SpacePermission permission = (com.atlassian.confluence.security.SpacePermission)spacePermissionChangeEvent.getPermissions().iterator().next();
            if (spacePermissionChangeEvent instanceof SpacePermissionRemoveEvent) {
                SpacePermissionRemoveEvent spacePermissionRemoveEvent = (SpacePermissionRemoveEvent)spacePermissionChangeEvent;
                string = spacePermissionRemoveEvent.getSpace().getKey();
            } else {
                string = permission.getSpace().getKey();
            }
            String spaceKey = string;
            return !this.spaceFilteringService.isExcluded(spaceKey);
        });
    }

    public Optional<Command<SpacePermissionChangeEvent, ContentManagementIncSyncModel>> newCommand(SpacePermissionChangeEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new SpacePermissionChangeCommand(this.commandSupport, this.spacePermissionOperationKeyConverter, this.spaceService, this.spaceFilteringService)) : Optional.empty();
    }

    public Optional<Command<SpacePermissionChangeEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new SpacePermissionChangeCommand(this.commandSupport, this.spacePermissionOperationKeyConverter, this.spaceService, this.spaceFilteringService));
    }
}

