/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.SpaceJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.ContentFilteringUtils;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceRemoveCommand
implements Command<SpaceRemoveEvent, ContentManagementIncSyncModel>,
CommandCreator<SpaceRemoveEvent, ContentManagementIncSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(SpaceRemoveCommand.class);
    private final ContentCommandSupport commandSupport;
    private final SpaceFilteringService spaceFilteringService;

    public SpaceRemoveCommand(ContentCommandSupport commandSupport, SpaceFilteringService spaceFilteringService) {
        this.commandSupport = commandSupport;
        this.spaceFilteringService = spaceFilteringService;
    }

    public void processEvent(SpaceRemoveEvent event, Object ... parameters) {
        if (!this.commandSupport.validateContentManagementCommandParam(parameters)) {
            logger.debug("Validate parameters failed when processing event {}", (Object)event);
            return;
        }
        SubscriptionId subscriptionId = (SubscriptionId)parameters[0];
        SingleSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = new SingleSubscriptionPerJournalIdentifier("c_g_inc_sync", subscriptionId);
        Space space = event.getSpace();
        SpaceJournalMessage journalMessage = new SpaceJournalMessage(space.getId(), space.getKey());
        this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)ContentJournalEntryTypes.SPACE_DELETED_ENTRY), journalMessage);
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<ContentManagementIncSyncModel> spaceDeletedModels = new ArrayList<ContentManagementIncSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            this.commandSupport.deserializeJournalMessage(SpaceJournalMessage.class, journalEntry).ifPresent(spaceRemoveJournalMessage -> {
                com.atlassian.confluence.api.model.content.Space space = com.atlassian.confluence.api.model.content.Space.builder().id(spaceRemoveJournalMessage.getSpaceId()).key(spaceRemoveJournalMessage.getSpaceKey()).build();
                spaceDeletedModels.add(ContentFilteringUtils.createSpaceModel(journalEntry, ContentModelType.CONTENT_MANAGEMENT_SPACE, entryType, space, this.spaceFilteringService));
            });
        }
        return spaceDeletedModels;
    }

    public Predicate<SpaceRemoveEvent> shouldProcess() {
        return ContentFilteringUtils.alwaysAllowed();
    }

    public Optional<Command<SpaceRemoveEvent, ContentManagementIncSyncModel>> newCommand(SpaceRemoveEvent event) {
        return Optional.of(new SpaceRemoveCommand(this.commandSupport, this.spaceFilteringService));
    }

    public Optional<Command<SpaceRemoveEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        if (!ContentJournalEntryTypes.SPACE_DELETED_ENTRY.name().equals(journalEntry.getType())) {
            return Optional.empty();
        }
        return Optional.of(new SpaceRemoveCommand(this.commandSupport, this.spaceFilteringService));
    }
}

