/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.GlobalPermission;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.atlassian.confluence.event.events.permission.GlobalPermissionChangeEvent;
import com.atlassian.confluence.event.events.permission.GlobalPermissionRemoveEvent;
import com.atlassian.confluence.event.events.permission.GlobalPermissionSaveEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.GlobalPermissionCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.MultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.GlobalPermissionJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.journalmessage.GlobalPermissionJournalMessage;
import com.atlassian.confluence.internal.api.incrementalsync.model.globalpermissionmanagement.GlobalPermissionManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class GlobalPermissionCommand
extends MultiEventsCommand<GlobalPermissionChangeEvent, GlobalPermissionManagementIncSyncModel, GlobalPermissionJournalEntryTypes> {
    private final GlobalPermissionCommandSupport commandSupport;
    private final SpacePermissionOperationKeyConverter globalPermissionOperationKeyConverter;
    private final SpaceFilteringService spaceFilteringService;

    public GlobalPermissionCommand(GlobalPermissionCommandSupport commandSupport, SpacePermissionOperationKeyConverter globalPermissionOperationKeyConverter, SpaceFilteringService spaceFilteringService) {
        this.commandSupport = commandSupport;
        this.globalPermissionOperationKeyConverter = globalPermissionOperationKeyConverter;
        this.spaceFilteringService = spaceFilteringService;
    }

    @Override
    protected Map<Class<? extends GlobalPermissionChangeEvent>, GlobalPermissionJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return Map.of(GlobalPermissionSaveEvent.class, GlobalPermissionJournalEntryTypes.PERMISSION_CREATED_ENTRY, GlobalPermissionRemoveEvent.class, GlobalPermissionJournalEntryTypes.PERMISSION_DELETED_ENTRY);
    }

    public void processEvent(GlobalPermissionChangeEvent event, Object ... parameters) {
        GlobalPermissionJournalEntryTypes entryType = this.getSupportedEventEntryTypesMap().get(event.getClass());
        if (entryType == null) {
            this.logger.debug("No entry type found for event {}", (Object)event.getClass().getName());
            return;
        }
        Optional<JournalMessage> message = this.createMessage(event);
        message.ifPresent(journalMessage -> this.commandSupport.enqueueForGlobalPermission(String.valueOf((Object)entryType), (JournalMessage)journalMessage));
    }

    public Collection<GlobalPermissionManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<GlobalPermissionManagementIncSyncModel> result = new ArrayList<GlobalPermissionManagementIncSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<GlobalPermissionJournalMessage> journalMessage = this.commandSupport.deserializeJournalMessage(GlobalPermissionJournalMessage.class, journalEntry);
            if (journalMessage.isEmpty()) {
                this.logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                continue;
            }
            GlobalPermissionJournalMessage globalPermissionJournalMessage = journalMessage.get();
            Optional<GlobalPermission> globalPermission = this.getGlobalPermission(globalPermissionJournalMessage);
            if (!globalPermission.isPresent()) continue;
            GlobalPermissionJournalEntryTypes entryType = GlobalPermissionJournalEntryTypes.valueOf(journalEntry.getType());
            result.add(new GlobalPermissionManagementIncSyncModel(journalEntry.getId(), globalPermissionJournalMessage.getSubjectType().getName(), entryType.getJsonModelOperation().getName(), globalPermission.get()));
        }
        return result;
    }

    public Optional<Command<GlobalPermissionChangeEvent, GlobalPermissionManagementIncSyncModel>> newCommand(GlobalPermissionChangeEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new GlobalPermissionCommand(this.commandSupport, this.globalPermissionOperationKeyConverter, this.spaceFilteringService)) : Optional.empty();
    }

    public Optional<Command<GlobalPermissionChangeEvent, GlobalPermissionManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        GlobalPermissionJournalEntryTypes entryType;
        try {
            entryType = GlobalPermissionJournalEntryTypes.valueOf(journalEntry.getType());
        }
        catch (IllegalArgumentException ex) {
            this.logger.debug("Invalid journal entry type {}", (Object)journalEntry.getType(), (Object)ex);
            return Optional.empty();
        }
        if (!this.getSupportedEventEntryTypesMap().containsValue((Object)entryType)) {
            this.logger.debug("Unsupported journal entry type {}", (Object)entryType);
            return Optional.empty();
        }
        return Optional.of(new GlobalPermissionCommand(this.commandSupport, this.globalPermissionOperationKeyConverter, this.spaceFilteringService));
    }

    private Optional<JournalMessage> createMessage(GlobalPermissionChangeEvent event) {
        SpacePermission permission = event.getPermission();
        if (permission.isUserPermission()) {
            ConfluenceUser userSubject = permission.getUserSubject();
            if (userSubject == null || userSubject.getKey() == null) {
                return Optional.empty();
            }
            return Optional.of(GlobalPermissionJournalMessage.createUserPermission(permission.getType(), userSubject.getKey().getStringValue()));
        }
        if (permission.isGroupPermission()) {
            return Optional.of(GlobalPermissionJournalMessage.createGroupPermission(permission.getType(), permission.getGroup()));
        }
        if (permission.isAnonymousPermission()) {
            return Optional.of(GlobalPermissionJournalMessage.createAnonymousPermission(permission.getType()));
        }
        if (permission.isAuthenticatedUsersPermission()) {
            return Optional.of(GlobalPermissionJournalMessage.createUnlicensedPermission(permission.getType()));
        }
        this.logger.debug("Failed to convert permission to journal message {}", (Object)permission);
        return Optional.empty();
    }

    private Optional<GlobalPermission> getGlobalPermission(GlobalPermissionJournalMessage journalMessage) {
        try {
            GlobalPermission globalPermission = new GlobalPermission();
            OperationDescription operationDescription = this.globalPermissionOperationKeyConverter.toOperation(journalMessage.getPermissionType());
            globalPermission.setOperation(operationDescription);
            globalPermission.setSubject(this.getSubjectFromJournalMessage(journalMessage));
            return Optional.of(globalPermission);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Failed to convert journal message to globalPermission", (Throwable)e);
            return Optional.empty();
        }
    }

    private Subject getSubjectFromJournalMessage(GlobalPermissionJournalMessage journalMessage) {
        switch (journalMessage.getSubjectType()) {
            case USER: {
                return User.fromUserkey((UserKey)new UserKey(journalMessage.getSubject()));
            }
            case GROUP: {
                return new Group(journalMessage.getSubject());
            }
            case ANONYMOUS: {
                return Anonymous.ANONYMOUS_USER;
            }
            case UNLICENSED: {
                return new UnknownUser(null, null);
            }
        }
        throw new IllegalArgumentException("Unsupported journal message type " + String.valueOf((Object)journalMessage.getSubjectType()));
    }
}

