/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.event.events.security.SpaceFilteringUpdatedEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.GlobalPermissionCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.MultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.GlobalPermissionJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.journalmessage.SpaceFilteringJournalMessage;
import com.atlassian.confluence.internal.api.incrementalsync.model.globalpermissionmanagement.GlobalPermissionManagementIncSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.globalpermissionmanagement.SpaceFilteringUpdatedIncrementalSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class SpaceFilteringCommand
extends MultiEventsCommand<SpaceFilteringUpdatedEvent, GlobalPermissionManagementIncSyncModel, GlobalPermissionJournalEntryTypes> {
    public static final String SPACE_FILTERING_TYPE_PREFIX = "spaceFiltering_";
    private final GlobalPermissionCommandSupport commandSupport;

    public SpaceFilteringCommand(GlobalPermissionCommandSupport commandSupport) {
        this.commandSupport = commandSupport;
    }

    @Override
    protected Map<Class<? extends SpaceFilteringUpdatedEvent>, GlobalPermissionJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return Map.of(SpaceFilteringUpdatedEvent.class, GlobalPermissionJournalEntryTypes.SPACE_FILTERING_UPDATE_ENTRY);
    }

    public void processEvent(SpaceFilteringUpdatedEvent event, Object ... parameters) {
        GlobalPermissionJournalEntryTypes entryType = this.getSupportedEventEntryTypesMap().get(event.getClass());
        if (entryType == null) {
            this.logger.debug("No entry type found for event {}", (Object)event.getClass().getName());
            return;
        }
        if (event.updateType() == SpaceFilteringUpdatedEvent.UpdateType.NO_OP) {
            this.logger.debug("No event need to fire for {}", (Object)SpaceFilteringUpdatedEvent.UpdateType.NO_OP.name());
            return;
        }
        Optional<JournalMessage> message = this.createMessage(event);
        message.ifPresent(journalMessage -> this.commandSupport.enqueueForGlobalPermission(String.valueOf((Object)entryType), (JournalMessage)journalMessage));
    }

    public Collection<GlobalPermissionManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<GlobalPermissionManagementIncSyncModel> result = new ArrayList<GlobalPermissionManagementIncSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<SpaceFilteringJournalMessage> journalMessage = this.commandSupport.deserializeJournalMessage(SpaceFilteringJournalMessage.class, journalEntry);
            if (journalMessage.isEmpty()) {
                this.logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                continue;
            }
            SpaceFilteringJournalMessage spaceFilteringJournalMessage = journalMessage.get();
            GlobalPermissionJournalEntryTypes entryType = GlobalPermissionJournalEntryTypes.valueOf(journalEntry.getType());
            result.add((GlobalPermissionManagementIncSyncModel)new SpaceFilteringUpdatedIncrementalSyncModel(journalEntry.getId(), SPACE_FILTERING_TYPE_PREFIX + spaceFilteringJournalMessage.getUpdateType(), entryType.getJsonModelOperation().getName(), null, spaceFilteringJournalMessage.getSource()));
        }
        return result;
    }

    public Optional<Command<SpaceFilteringUpdatedEvent, GlobalPermissionManagementIncSyncModel>> newCommand(SpaceFilteringUpdatedEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new SpaceFilteringCommand(this.commandSupport)) : Optional.empty();
    }

    public Optional<Command<SpaceFilteringUpdatedEvent, GlobalPermissionManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        GlobalPermissionJournalEntryTypes entryType;
        try {
            entryType = GlobalPermissionJournalEntryTypes.valueOf(journalEntry.getType());
        }
        catch (IllegalArgumentException ex) {
            this.logger.debug("Invalid journal entry type {}", (Object)journalEntry.getType(), (Object)ex);
            return Optional.empty();
        }
        if (!this.getSupportedEventEntryTypesMap().containsValue((Object)entryType)) {
            this.logger.debug("Unsupported journal entry type {}", (Object)entryType);
            return Optional.empty();
        }
        return Optional.of(new SpaceFilteringCommand(this.commandSupport));
    }

    private Optional<JournalMessage> createMessage(SpaceFilteringUpdatedEvent event) {
        SpaceFilteringUpdatedEvent.UpdateType updateType = event.updateType();
        String source = event.source();
        return Optional.of(SpaceFilteringJournalMessage.create(source, String.valueOf(updateType)));
    }
}

