/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import java.util.Objects;

public class MultiSubscriptionPerJournalIdentifier
extends JournalIdentifier {
    private static final long serialVersionUID = -3583401077249433233L;
    public static final String JOURNAL_NAME_DELIMITER = "_";
    public static final String DELIMITER = "_";
    private final SubscriptionId subscriptionId;
    private final long mostRecentId;

    public MultiSubscriptionPerJournalIdentifier(String journalName, SubscriptionId subscriptionId) {
        super(journalName);
        this.subscriptionId = subscriptionId;
        this.mostRecentId = -1L;
    }

    public MultiSubscriptionPerJournalIdentifier(String journalName, SubscriptionId subscriptionId, long mostRecentId) {
        super(journalName);
        if (mostRecentId < 0L) {
            throw new IllegalArgumentException("Most recent id must be non-negative");
        }
        this.subscriptionId = subscriptionId;
        this.mostRecentId = mostRecentId;
    }

    public SubscriptionId getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getJournalNameWithSubscriptionId() {
        return super.getJournalName() + "_" + this.getSubscriptionId().getValue();
    }

    public String getJournalName() {
        return super.getJournalName();
    }

    public long getMostRecentId() {
        return this.mostRecentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiSubscriptionPerJournalIdentifier)) {
            return false;
        }
        MultiSubscriptionPerJournalIdentifier that = (MultiSubscriptionPerJournalIdentifier)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.mostRecentId == that.mostRecentId && Objects.equals(this.subscriptionId, that.subscriptionId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subscriptionId, this.mostRecentId);
    }
}

