/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.UserManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.events.DirectoryOrderUpdatedEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.DirectoryJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserGroupIncrementalSyncEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class DirectoryEventCommandUserManagement
extends UserManagementMultiEventsCommand<DirectoryEvent> {
    private final SpaceFilteringService spaceFilteringService;

    public DirectoryEventCommandUserManagement(UserGroupCommandSupport commandSupport, SpaceFilteringService spaceFilteringService) {
        super(commandSupport);
        this.spaceFilteringService = spaceFilteringService;
    }

    @Override
    protected Map<Class<? extends DirectoryEvent>, UserJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return Map.of(DirectoryCreatedEvent.class, UserJournalEntryTypes.DIRECTORY_CREATED_ENTRY, DirectoryUpdatedEvent.class, UserJournalEntryTypes.DIRECTORY_UPDATED_ENTRY, DirectoryOrderUpdatedEvent.class, UserJournalEntryTypes.DIRECTORY_UPDATED_ENTRY, DirectoryDeletedEvent.class, UserJournalEntryTypes.DIRECTORY_DELETED_ENTRY);
    }

    @Override
    protected Optional<JournalMessage> createMessage(DirectoryEvent event) {
        boolean isRepublishedEvent;
        boolean bl = isRepublishedEvent = event.getSource() == null;
        if (isRepublishedEvent) {
            return Optional.empty();
        }
        return Optional.of(new DirectoryJournalMessage(event.getTimestamp(), event.getDirectoryId()));
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<DirectoryJournalMessage> directoryJournalMessageOptional = this.commandSupport.deserializeJournalMessage(DirectoryJournalMessage.class, journalEntry);
            if (directoryJournalMessageOptional.isEmpty()) {
                this.logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                continue;
            }
            DirectoryJournalMessage directoryJournalMessage = directoryJournalMessageOptional.orElseThrow();
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            result.add(new UserGroupIncrementalSyncEventModel(journalEntry.getId(), directoryJournalMessage.getDirectoryId(), UserModelType.DIRECTORY_MANAGEMENT, entryType.getJsonModelOperation()));
        }
        return result;
    }

    public Optional<Command<DirectoryEvent, UserManagementInSyncModel>> newCommand(DirectoryEvent event) {
        return Optional.of(new DirectoryEventCommandUserManagement(this.commandSupport, this.spaceFilteringService));
    }

    public Optional<Command<DirectoryEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new DirectoryEventCommandUserManagement(this.commandSupport, this.spaceFilteringService));
    }
}

