/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.GroupMembershipsEventCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupMembershipJournalMessage;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GroupMembershipsCreatedEventCommand
extends GroupMembershipsEventCommand<GroupMembershipsCreatedEvent> {
    private final SpaceFilteringService spaceFilteringService;

    public GroupMembershipsCreatedEventCommand(UserGroupCommandSupport commandSupport, PersonFactory personFactory, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, CrowdUserDirectoryHelper crowdUserDirectoryHelper, SpaceFilteringService spaceFilteringService) {
        super(commandSupport, personFactory, crowdDirectoryEntityHelper, crowdUserDirectoryHelper);
        this.spaceFilteringService = spaceFilteringService;
    }

    private List<String> findEntitiesThatShouldBeProcessed(GroupMembershipsCreatedEvent event) {
        ArrayList<String> entitiesThatShouldBeProcessed = new ArrayList<String>();
        for (String entityName : event.getEntityNames()) {
            Optional childEntity;
            switch (event.getMembershipType()) {
                case GROUP_USER: {
                    childEntity = this.crowdDirectoryEntityHelper.findUserByName(event.getDirectoryId().longValue(), entityName);
                    break;
                }
                case GROUP_GROUP: {
                    childEntity = this.crowdDirectoryEntityHelper.findGroupByName(event.getDirectoryId().longValue(), entityName);
                    break;
                }
                default: {
                    this.logger.info("Unknown membership type {} encountered while processing group memberships created event in directory with ID [{}] ", (Object)event.getMembershipType(), (Object)event.getDirectoryId());
                    return entitiesThatShouldBeProcessed;
                }
            }
            if (childEntity.isPresent()) {
                if (!this.crowdDirectoryEntityHelper.isCanonical((DirectoryEntity)childEntity.get()) && (!this.crowdUserDirectoryHelper.isMembershipAggregationEnabled() || !this.isFirstOne(entityName, event))) continue;
                entitiesThatShouldBeProcessed.add(entityName);
                continue;
            }
            this.logger.warn("Could not find child entity while processing group memberships created event in directory with ID [{}]", (Object)event.getDirectoryId());
        }
        return entitiesThatShouldBeProcessed;
    }

    private boolean isFirstOne(String entityName, GroupMembershipsCreatedEvent event) {
        return event.getMembershipType().equals((Object)MembershipType.GROUP_USER) ? !this.crowdDirectoryEntityHelper.userExistsInAnyDirectoriesBesidesDirectory(entityName, event.getGroupName(), event.getDirectory().getName()) : !this.crowdDirectoryEntityHelper.groupExistsInAnyDirectoriesBesidesDirectory(entityName, event.getGroupName(), event.getDirectory().getName());
    }

    public void processEvent(GroupMembershipsCreatedEvent event, Object ... parameters) {
        List<String> entitiesThatShouldBeProcessed = this.findEntitiesThatShouldBeProcessed(event);
        if (!entitiesThatShouldBeProcessed.isEmpty()) {
            GroupMembershipsCreatedEvent updatedEvent = new GroupMembershipsCreatedEvent(event.getSource(), event.getDirectory(), entitiesThatShouldBeProcessed, event.getGroupName(), event.getMembershipType());
            this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.GROUP_MEMBERSHIPS_CREATED_ENTRY), this.buildJournalMessage(updatedEvent));
        }
    }

    public Optional<Command<GroupMembershipsCreatedEvent, UserManagementInSyncModel>> newCommand(GroupMembershipsCreatedEvent event) {
        return Optional.of(new GroupMembershipsCreatedEventCommand(this.commandSupport, this.personFactory, this.crowdDirectoryEntityHelper, this.crowdUserDirectoryHelper, this.spaceFilteringService));
    }

    public Optional<Command<GroupMembershipsCreatedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return UserJournalEntryTypes.GROUP_MEMBERSHIPS_CREATED_ENTRY.name().equals(journalEntry.getType()) ? Optional.of(new GroupMembershipsCreatedEventCommand(this.commandSupport, this.personFactory, this.crowdDirectoryEntityHelper, this.crowdUserDirectoryHelper, this.spaceFilteringService)) : Optional.empty();
    }

    @Override
    protected JournalMessage buildJournalMessage(GroupMembershipsCreatedEvent event) {
        return new GroupMembershipJournalMessage(event.getTimestamp(), event.getGroupName(), this.getEntityNames(event.getMembershipType(), event.getEntityNames()), event.getMembershipType());
    }
}

