/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.event.events.user.PostUserRenamedEvent;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.UserEventCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.UserJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.GroupMembershipsUtil;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.model.DirectoryEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PostUserRenamedEventCommand
extends UserEventCommand<PostUserRenamedEvent> {
    private final MembershipDao membershipDao;
    private final CrowdDirectoryService crowdDirectoryService;
    private final CrowdDirectoryEntityHelper crowdDirectoryEntityHelper;
    private final UserAccessor userAccessor;
    private final SpaceFilteringService spaceFilteringService;

    public PostUserRenamedEventCommand(UserGroupCommandSupport commandSupport, PersonFactory personFactory, MembershipDao membershipDao, CrowdDirectoryService crowdDirectoryService, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, UserAccessor userAccessor, SpaceFilteringService spaceFilteringService) {
        super(commandSupport, personFactory);
        this.membershipDao = Objects.requireNonNull(membershipDao);
        this.crowdDirectoryService = Objects.requireNonNull(crowdDirectoryService);
        this.crowdDirectoryEntityHelper = Objects.requireNonNull(crowdDirectoryEntityHelper);
        this.userAccessor = Objects.requireNonNull(userAccessor);
        this.spaceFilteringService = spaceFilteringService;
    }

    public void processEvent(PostUserRenamedEvent event, Object ... parameters) {
        Person personWithNewUsername;
        com.atlassian.crowd.model.user.User userWithNewUsername = event.getUser();
        String newUsername = userWithNewUsername.getName();
        long timestamp = event.getTimestamp();
        boolean membershipAggregationEnabled = this.crowdDirectoryService.isMembershipAggregationEnabled();
        boolean wasCanonical = this.crowdDirectoryEntityHelper.wasCanonical(event.getOldUsername(), event.getUser());
        boolean isCanonical = this.crowdDirectoryEntityHelper.isCanonical((DirectoryEntity)userWithNewUsername);
        if (!wasCanonical && isCanonical) {
            this.buildJournalMessageFromUsername(timestamp, newUsername).ifPresent(journalMessage -> this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_CREATED_ENTRY), (JournalMessage)journalMessage));
        } else if (wasCanonical && !isCanonical) {
            UserJournalMessage userDeletedJournalMessage = new UserJournalMessage(timestamp, event.getOldUserKey());
            this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_DELETED_ENTRY), userDeletedJournalMessage);
        } else if (wasCanonical) {
            this.buildJournalMessageFromUsername(timestamp, newUsername).ifPresent(journalMessage -> this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_RENAMED_ENTRY), (JournalMessage)journalMessage));
        }
        List<String> updatedGroupMembershipForUser = this.getGroupMembershipsForUser(userWithNewUsername.getDirectoryId(), newUsername);
        if (membershipAggregationEnabled || wasCanonical) {
            updatedGroupMembershipForUser.forEach(groupName -> this.commandSupport.removeGroupMembershipForUser((String)groupName, event.getTimestamp(), event.getOldUserKey()));
        }
        if ((personWithNewUsername = this.personFactory.forUsernameWithoutProfile(newUsername)) instanceof KnownUser) {
            KnownUser knownUser = (KnownUser)personWithNewUsername;
            if (membershipAggregationEnabled || isCanonical) {
                String userKey = knownUser.getUserKey();
                updatedGroupMembershipForUser.forEach(groupName -> this.commandSupport.addGroupMembershipForUser((String)groupName, event.getTimestamp(), userKey));
            }
        }
        if (wasCanonical) {
            Optional crowdUserOptional = this.crowdDirectoryEntityHelper.findByName(event.getOldUsername(), com.atlassian.crowd.model.user.User.class);
            crowdUserOptional.ifPresent(crowdUser -> {
                Person personWithNewOldUsername = this.personFactory.forUsernameWithoutProfile(event.getOldUsername());
                if (personWithNewOldUsername instanceof User) {
                    User user = (User)personWithNewOldUsername;
                    String userKeyForUnshadowedUser = user.getUserKey();
                    UserJournalMessage userUnshadowedJournalMessage = new UserJournalMessage(timestamp, userKeyForUnshadowedUser);
                    this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_CREATED_ENTRY), userUnshadowedJournalMessage);
                    List<String> groupNames = membershipAggregationEnabled ? this.userAccessor.getGroupNamesForUserName(event.getOldUsername()) : this.getGroupMembershipsForUser(crowdUser.getDirectoryId(), event.getOldUsername());
                    if (groupNames != null && !groupNames.isEmpty()) {
                        groupNames.forEach(groupName -> this.commandSupport.addGroupMembershipForUser((String)groupName, event.getTimestamp(), userKeyForUnshadowedUser));
                    }
                }
            });
        }
    }

    private List<String> getGroupMembershipsForUser(long directoryId, String newUsername) {
        return this.membershipDao.search(directoryId, GroupMembershipsUtil.allGroupsContainingUserQuery(newUsername));
    }

    private Optional<JournalMessage> buildJournalMessageFromUsername(long timestamp, String username) {
        Person personWithNewUsername = this.personFactory.forUsernameWithoutProfile(username);
        if (personWithNewUsername instanceof User) {
            User user = (User)personWithNewUsername;
            String userKey = user.getUserKey();
            return Optional.of(new UserJournalMessage(timestamp, userKey));
        }
        return Optional.empty();
    }

    public Optional<Command<PostUserRenamedEvent, UserManagementInSyncModel>> newCommand(PostUserRenamedEvent event) {
        return Optional.of(new PostUserRenamedEventCommand(this.commandSupport, this.personFactory, this.membershipDao, this.crowdDirectoryService, this.crowdDirectoryEntityHelper, this.userAccessor, this.spaceFilteringService));
    }

    public Optional<Command<PostUserRenamedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return UserJournalEntryTypes.USER_RENAMED_ENTRY.name().equals(journalEntry.getType()) ? Optional.of(new PostUserRenamedEventCommand(this.commandSupport, this.personFactory, this.membershipDao, this.crowdDirectoryService, this.crowdDirectoryEntityHelper, this.userAccessor, this.spaceFilteringService)) : Optional.empty();
    }
}

