/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.UserManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.UserJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.model.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class UserActivationEventCommandUserManagement
extends UserManagementMultiEventsCommand<UserEditedEvent> {
    private final PersonFactory personFactory;
    private final SpaceFilteringService spaceFilteringService;

    public UserActivationEventCommandUserManagement(UserGroupCommandSupport commandSupport, PersonFactory personFactory, SpaceFilteringService spaceFilteringService) {
        super(commandSupport);
        this.personFactory = personFactory;
        this.spaceFilteringService = spaceFilteringService;
    }

    @Override
    public Map<Class<? extends UserEditedEvent>, UserJournalEntryTypes> getSupportedEventEntryTypesMap() {
        if (this.supportedEventEntryTypesMap == null) {
            this.supportedEventEntryTypesMap = Map.of(UserEditedEvent.class, UserJournalEntryTypes.USER_UPDATED_ENTRY);
        }
        return this.supportedEventEntryTypesMap;
    }

    @Override
    protected Optional<JournalMessage> createMessage(UserEditedEvent event) {
        return Optional.empty();
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            this.commandSupport.deserializeJournalMessage(UserJournalMessage.class, journalEntry).ifPresent(userJournalMessage -> {
                String userKey = userJournalMessage.getUserKey();
                Person person = this.personFactory.forUserKeyWithoutProfile(userKey, Expansions.of((String[])new String[]{"status"}));
                if (person instanceof UnknownUser) {
                    this.logger.warn("Could not find user with user key {}. ", (Object)userKey);
                    return;
                }
                result.add(new UserEventModel(journalEntry.getId(), UserModelType.USER_MANAGEMENT.getName(), entryType.getJsonModelOperation().getName(), person));
            });
        }
        return result;
    }

    @Override
    public void processEvent(UserEditedEvent event, Object ... parameters) {
        User originalUser = event.getOriginalUser();
        User currentUser = event.getUser();
        Person person = this.personFactory.forUsername(currentUser.getName());
        if (person instanceof KnownUser) {
            KnownUser knownUser = (KnownUser)person;
            UserJournalMessage userJournalMessage = new UserJournalMessage(event.getTimestamp(), knownUser.getUserKey());
            if (currentUser.isActive() != originalUser.isActive()) {
                this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_UPDATED_ENTRY), userJournalMessage);
            }
        } else {
            this.logger.error("Could not find user with username {}", (Object)currentUser.getName());
            this.logger.error("User Reactivation/Deactivation event will not be added to the journal");
        }
    }

    public Optional<Command<UserEditedEvent, UserManagementInSyncModel>> newCommand(UserEditedEvent event) {
        return Optional.of(new UserActivationEventCommandUserManagement(this.commandSupport, this.personFactory, this.spaceFilteringService));
    }

    public Optional<Command<UserEditedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return UserJournalEntryTypes.USER_UPDATED_ENTRY.name().equals(journalEntry.getType()) ? Optional.of(new UserActivationEventCommandUserManagement(this.commandSupport, this.personFactory, this.spaceFilteringService)) : Optional.empty();
    }
}

