/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.MultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import java.util.Optional;

public abstract class UserManagementMultiEventsCommand<T>
extends MultiEventsCommand<T, UserManagementInSyncModel, UserJournalEntryTypes> {
    protected final UserGroupCommandSupport commandSupport;

    protected abstract Optional<JournalMessage> createMessage(T var1);

    protected UserManagementMultiEventsCommand(UserGroupCommandSupport commandSupport) {
        this.commandSupport = commandSupport;
    }

    public void processEvent(T event, Object ... params) {
        UserJournalEntryTypes entryType = (UserJournalEntryTypes)((Object)this.getSupportedEventEntryTypesMap().get(event.getClass()));
        if (entryType == null) {
            this.logger.debug("No entry type found for event {}", (Object)event.getClass().getName());
            return;
        }
        Optional<JournalMessage> message = this.createMessage(event);
        if (message.isEmpty()) {
            this.logger.info("Skipping republished event {}", (Object)event.getClass().getName());
            return;
        }
        this.commandSupport.enqueueForUserManagement(String.valueOf((Object)entryType), message.orElseThrow());
    }

    public Optional<Command<T, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry, Command<T, UserManagementInSyncModel> command) {
        UserJournalEntryTypes entryType;
        try {
            entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
        }
        catch (IllegalArgumentException ex) {
            this.logger.debug("Invalid journal entry type {}", (Object)journalEntry.getType(), (Object)ex);
            return Optional.empty();
        }
        if (!this.getSupportedEventEntryTypesMap().containsValue((Object)entryType)) {
            this.logger.debug("Unsupported journal entry type {}", (Object)entryType);
            return Optional.empty();
        }
        return Optional.of(command);
    }
}

