/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils;

import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.ContentModel;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.RestrictedInformationSpaceModel;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.SpaceModel;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.SpacePermissionModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.SpaceFilteringIgnored;
import com.atlassian.confluence.internal.api.incrementalsync.model.SpaceRelatedIncrementalSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.spaces.Spaced;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFilteringUtils {
    private static final Logger log = LoggerFactory.getLogger(ContentFilteringUtils.class);

    public static Predicate<IncrementalSyncModel> predicate(SpaceFilteringService spaceFilteringService) {
        return incrementalSyncModel -> {
            try {
                if (incrementalSyncModel instanceof SpaceFilteringIgnored || !(incrementalSyncModel instanceof SpaceRelatedIncrementalSyncModel)) {
                    return true;
                }
                String spaceKey = null;
                if (incrementalSyncModel instanceof ContentModel) {
                    ContentModel contentModel = (ContentModel)((Object)incrementalSyncModel);
                    spaceKey = ContentFilteringUtils.errorSwallowingGetter(() -> contentModel.getContent().getSpace().getKey());
                } else if (incrementalSyncModel instanceof SpaceModel) {
                    SpaceModel spaceModel = (SpaceModel)((Object)incrementalSyncModel);
                    spaceKey = ContentFilteringUtils.errorSwallowingGetter(() -> spaceModel.getSpace().getKey());
                } else if (incrementalSyncModel instanceof SpacePermissionModel) {
                    SpacePermissionModel spacePermissionModel = (SpacePermissionModel)((Object)incrementalSyncModel);
                    spaceKey = ContentFilteringUtils.errorSwallowingGetter(() -> spacePermissionModel.getPermission().getSpaceKey());
                } else {
                    log.error("Cannot identify content class. Possible data leak. Class: {}", (Object)incrementalSyncModel.getClass());
                }
                return spaceKey == null || !spaceFilteringService.isExcluded(spaceKey);
            }
            catch (Exception e) {
                log.error("Exception occurred while checking space key", (Throwable)e);
                return true;
            }
        };
    }

    public static ContentManagementIncSyncModel createSpaceModel(JournalEntry journalEntry, ContentModelType contentModelType, ContentJournalEntryTypes entryType, Space space, SpaceFilteringService spaceFilteringService) {
        if (spaceFilteringService.isExcluded(space.getKey())) {
            return new RestrictedInformationSpaceModel(journalEntry.getId(), contentModelType.getName(), entryType.getJsonModelOperation().getName(), space);
        }
        return new SpaceModel(journalEntry.getId(), contentModelType.getName(), entryType.getJsonModelOperation().getName(), space);
    }

    public static <T> Predicate<T> alwaysAllowed() {
        return o -> true;
    }

    private static String errorSwallowingGetter(Supplier<String> getter) {
        try {
            return getter.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Predicate<T> errorSwallowingPredicate(Predicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception e) {
                return true;
            }
        };
    }

    public static boolean isAllowed(ContentEntityObject content, SpaceFilteringService spaceFilteringService) {
        Spaced spaced;
        return !(content instanceof Spaced && spaceFilteringService.isExcluded((spaced = (Spaced)content).getSpace().getKey()));
    }
}

