/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils;

import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionEventType;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class IncrementalSyncUtil {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalSyncUtil.class);
    public static final String TTL_FOR_INACTIVE_SUBSCRIPTION_KEY = "IncSyncSubsExpiredTime";
    public static final String TTL_FOR_SUBSCRIPTION_KEY = "IncSyncJournalExpiredTime";

    private IncrementalSyncUtil() {
    }

    public static List<SubscriptionEventType> convertStringToEnumList(String commaSeparatedString) {
        return Arrays.stream(commaSeparatedString.split(",")).map(String::trim).map(SubscriptionEventType::valueOf).collect(Collectors.toList());
    }

    public static long getTTLForSubscriptionInMilliSeconds() {
        return TimeUnit.HOURS.toMillis(Long.getLong(TTL_FOR_SUBSCRIPTION_KEY, 168L));
    }

    public static long getTtlForInactiveSubscriptionInMilliSeconds() {
        return TimeUnit.HOURS.toMillis(Long.getLong(TTL_FOR_INACTIVE_SUBSCRIPTION_KEY, 168L));
    }

    public static <T> Object invokeFactoryMethodForEvent(CommandCreator<?, ?> commandCreator, Class<?> eventClass, T event) {
        Method invocationMethod = ReflectionUtils.findMethod((Class)commandCreator.getClass(), (String)"newCommand", (Class[])new Class[]{eventClass});
        if (invocationMethod == null) {
            logger.debug("Could not find method 'newCommand' in {}", (Object)commandCreator.getClass());
            return null;
        }
        try {
            return invocationMethod.invoke(commandCreator, event);
        }
        catch (Exception e) {
            logger.error("Failed create a command with creator {}. Creation method is {}", new Object[]{commandCreator, invocationMethod, e});
            return null;
        }
    }
}

