/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.rovo;

import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.internal.api.incrementalsync.model.ConfluenceRovoCapabilities;
import com.atlassian.confluence.internal.api.rovo.service.RovoCapabilityService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RovoCapabilityServiceImpl
implements RovoCapabilityService {
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final PermissionManager permissionManager;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public RovoCapabilityServiceImpl(ScopesRequestCacheDelegate scopesRequestCacheDelegate, PermissionManager permissionManager) {
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.permissionManager = permissionManager;
    }

    public ConfluenceRovoCapabilities getCapabilities() {
        this.validateAdminOrReadAllSubscriptionsScope(AuthenticatedUserThreadLocal.get());
        String versionNumber = BuildInformation.INSTANCE.getVersionNumber();
        List capabilities = Arrays.stream(RovoCapabilityService.RovoCapabilityType.values()).map(Enum::name).collect(Collectors.toList());
        return new ConfluenceRovoCapabilities(versionNumber, capabilities);
    }

    private void validateAdminOrReadAllSubscriptionsScope(ConfluenceUser confluenceUser) {
        if (!(this.permissionManager.isSystemAdministrator(confluenceUser) || this.permissionManager.isConfluenceAdministrator(confluenceUser) || this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL"))) {
            throw new IllegalArgumentException("You do not have permission to perform this operation");
        }
    }
}

