/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.security.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.incrementalsync.SpaceFilteringManager;
import com.atlassian.confluence.internal.api.incrementalsync.model.security.InclusionList;
import com.atlassian.confluence.internal.api.incrementalsync.model.security.SpaceReference;
import com.atlassian.confluence.internal.api.security.SpaceFilteringService;
import com.atlassian.confluence.internal.api.security.exception.IdsNotFoundException;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.event.api.EventListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterEventListeners
public class SpaceFilteringServiceImpl
implements SpaceFilteringService {
    private static final int SPACE_FETCHING_BATCH_SIZE = Integer.getInteger("confluence.integration.space.filtering.fetch.batch.size", 500);
    @VisibleForTesting
    static final String UPDATE_LIST_ON_SPACE_CREATION_DARK_FEATURE = "confluence.integration.sync.space.filter.addnewspaces";
    @VisibleForTesting
    static final String SPACE_INSERTION_ON_CREATION_SOURCE = "confluence-dc-system";
    private static final Logger log = LoggerFactory.getLogger(SpaceFilteringServiceImpl.class);
    private final SpaceFilteringManager spaceFilteringManager;
    private final PermissionManager permissionManager;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final SpaceManagerInternal spaceManagerInternal;
    private final DarkFeaturesManager darkFeaturesManager;
    private final PaginationService paginationService;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SpaceFilteringServiceImpl(SpaceFilteringManager spaceFilteringManager, PermissionManager permissionManager, ScopesRequestCacheDelegate scopesRequestCacheDelegate, SpaceManagerInternal spaceManagerInternal, DarkFeaturesManager darkFeaturesManager, PaginationService paginationService) {
        this.spaceFilteringManager = spaceFilteringManager;
        this.permissionManager = permissionManager;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.spaceManagerInternal = spaceManagerInternal;
        this.darkFeaturesManager = darkFeaturesManager;
        this.paginationService = paginationService;
    }

    public boolean isExcluded(String spaceKey) {
        return this.spaceFilteringManager.isExcluded(spaceKey);
    }

    public void setFilteringSettings(Collection<String> spaceKeys, boolean allowNewSpaces, String source) {
        this.validateAdminOrRequiredScope(AuthenticatedUserThreadLocal.get(), "MANAGE_SUBSCRIPTIONS");
        this.spaceFilteringManager.replaceList(new HashSet<String>(spaceKeys), allowNewSpaces, source);
    }

    public void setFilteringSettingsByIds(Collection<Long> spaceIds, boolean allowNewSpaces, String source) throws IdsNotFoundException {
        this.validateAdminOrRequiredScope(AuthenticatedUserThreadLocal.get(), "MANAGE_SUBSCRIPTIONS");
        this.spaceFilteringManager.replaceList(this.retrieveSpaceKeys(new HashSet<Long>(spaceIds)), allowNewSpaces, source);
    }

    public void resetFiltering(String source) {
        this.validateAdminOrRequiredScope(AuthenticatedUserThreadLocal.get(), "MANAGE_SUBSCRIPTIONS");
        this.spaceFilteringManager.resetList(source);
    }

    public Optional<InclusionList> getAllowList() {
        this.validateAdminOrRequiredScope(AuthenticatedUserThreadLocal.get(), "READ_ALL");
        if (!this.spaceFilteringManager.isOptedIn()) {
            return Optional.empty();
        }
        Set spaceKeys = this.spaceFilteringManager.getAllowedSpaces();
        return Optional.of(new InclusionList(this.spaceKeysToReferences(spaceKeys), this.spaceFilteringManager.optInNewSpaces()));
    }

    public PageResponse<Space> getSpaces(PageRequest request) {
        this.validateAdminOrRequiredScope(AuthenticatedUserThreadLocal.get(), "READ_ALL");
        try (Cleanup ignored = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.GET);){
            SpacesQuery query = SpacesQuery.newQuery().build();
            PageResponse pageResponse = this.paginationService.performPaginationListRequest(LimitedRequestImpl.create((PageRequest)request, (int)request.getLimit()), input -> this.spaceManagerInternal.getSpaces(query, input, new Predicate[]{space -> true}), items -> StreamSupport.stream(items.spliterator(), false).map(space -> Space.builder().key(space.getKey()).id(space.getId()).name(space.getName()).build()).collect(Collectors.toSet()));
            return pageResponse;
        }
    }

    @EventListener
    public void onSpaceCreateEvent(SpaceCreateEvent spaceCreateEvent) {
        try {
            if (this.spaceFilteringManager.isOptedIn() && this.spaceFilteringManager.optInNewSpaces() && this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled(UPDATE_LIST_ON_SPACE_CREATION_DARK_FEATURE)) {
                this.spaceFilteringManager.addSpace(spaceCreateEvent.getSpace().getKey(), SPACE_INSERTION_ON_CREATION_SOURCE);
            }
        }
        catch (Exception e) {
            log.error("Error updating space allowlist", (Throwable)e);
        }
    }

    @EventListener
    public void onSpaceImportEvent(AsyncImportFinishedEvent asyncImportFinishedEvent) {
        try {
            if (this.spaceFilteringManager.isOptedIn() && this.spaceFilteringManager.optInNewSpaces() && !asyncImportFinishedEvent.isSiteImport() && this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled(UPDATE_LIST_ON_SPACE_CREATION_DARK_FEATURE)) {
                this.spaceFilteringManager.addSpace(asyncImportFinishedEvent.getImportContext().getSpaceKeyOfSpaceImport(), SPACE_INSERTION_ON_CREATION_SOURCE);
            }
        }
        catch (Exception e) {
            log.error("Error updating space allowlist", (Throwable)e);
        }
    }

    private Set<SpaceReference> spaceKeysToReferences(Set<String> spaceKeys) {
        try (Cleanup ignored = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.GET);){
            HashMap spaceKeysMapping = new HashMap(spaceKeys.size());
            spaceKeys.forEach(spaceKey -> spaceKeysMapping.put(spaceKey, 0L));
            Collection<List<String>> batches = SpaceFilteringServiceImpl.partition(new ArrayList<String>(spaceKeys), SPACE_FETCHING_BATCH_SIZE);
            for (List<String> batch : batches) {
                SpacesQuery query = SpacesQuery.newQuery().withSpaceKeys(batch).build();
                PageResponse spacesBatch = this.spaceManagerInternal.getSpaces(query, LimitedRequestImpl.create((int)batch.size()), new Predicate[0]);
                spacesBatch.getResults().forEach(space -> spaceKeysMapping.put(space.getKey(), space.getId()));
            }
            Set set = spaceKeysMapping.entrySet().stream().map(entry -> new SpaceReference(((Long)entry.getValue()).longValue(), (String)entry.getKey())).collect(Collectors.toSet());
            return set;
        }
    }

    private Set<String> retrieveSpaceKeys(Set<Long> spaceIds) {
        try (Cleanup ignored = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.GET);){
            Collection<List<Long>> batches = SpaceFilteringServiceImpl.partition(new ArrayList<Long>(spaceIds), SPACE_FETCHING_BATCH_SIZE);
            HashMap spaceKeysMapping = new HashMap(spaceIds.size());
            for (List<Long> batch : batches) {
                SpacesQuery query = SpacesQuery.newQuery().withSpaceIds(new HashSet<Long>(batch)).build();
                PageResponse spacesBatch = this.spaceManagerInternal.getSpaces(query, LimitedRequestImpl.create((int)batch.size()), new Predicate[0]);
                spacesBatch.getResults().forEach(space -> spaceKeysMapping.put(space.getId(), space.getKey()));
            }
            if (spaceKeysMapping.size() != spaceIds.size()) {
                spaceIds.removeAll(spaceKeysMapping.keySet());
                throw new IdsNotFoundException("Cannot find spaces for ids", spaceIds);
            }
            HashSet hashSet = new HashSet(spaceKeysMapping.values());
            return hashSet;
        }
    }

    private void validateAdminOrRequiredScope(ConfluenceUser confluenceUser, String scope) {
        if (!(this.permissionManager.isSystemAdministrator(confluenceUser) || this.permissionManager.isConfluenceAdministrator(confluenceUser) || this.scopesRequestCacheDelegate.isScopePermitted(scope))) {
            throw new IllegalArgumentException("You do not have permission to perform this operation");
        }
    }

    private static <T> Collection<List<T>> partition(List<T> inputList, int size) {
        AtomicInteger counter = new AtomicInteger(0);
        return inputList.stream().collect(Collectors.groupingBy(s -> counter.getAndIncrement() / size)).values();
    }
}

