/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.search.CQLSearchResult;
import com.atlassian.confluence.plugins.search.CQLSearcher;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Objects;

@ExperimentalApi
@AnonymousSiteAccess
@SendsAnalytics
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/cqlSearch")
@Internal
public class CQLSearchResource {
    private final CQLSearcher cqlSearcher;
    private final ObjectMapperProvider objectMapperProvider;

    @Inject
    public CQLSearchResource(CQLSearcher cqlSearcher, @ComponentImport ObjectMapperProvider objectMapperProvider) {
        this.cqlSearcher = Objects.requireNonNull(cqlSearcher);
        this.objectMapperProvider = Objects.requireNonNull(objectMapperProvider);
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public SearchPageResponse<CQLSearchResult> search(@QueryParam(value="cql") String cql, @QueryParam(value="cqlcontext") String cqlcontext, @QueryParam(value="excerpt") String excerpt, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="includeArchivedSpaces") @DefaultValue(value="false") boolean includeArchivedSpaces, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)cql)) {
            throw new BadRequestException("cql query parameter is required");
        }
        SearchContext searchContext = SearchContext.builder().build();
        if (!Strings.isNullOrEmpty((String)cqlcontext)) {
            searchContext = this.deserialize(cqlcontext, this.objectMapperProvider.getObjectMapper());
        }
        SearchOptions searchOptions = SearchOptions.builder().searchContext(searchContext).excerptStrategy(excerpt).includeArchivedSpaces(includeArchivedSpaces).build();
        return this.cqlSearcher.getCqlSearchResults(cql, searchOptions, (PageRequest)new RestPageRequest(uriInfo.getRequestUri(), start, limit), ExpansionsParser.parseExperimental((String)expand));
    }

    private SearchContext deserialize(String searchContextJson, ObjectMapper objectMapper) {
        if (searchContextJson == null || searchContextJson.isEmpty()) {
            return null;
        }
        try {
            return (SearchContext)objectMapper.readValue(searchContextJson, SearchContext.class);
        }
        catch (IOException ex) {
            throw new BadRequestException("Could not parse Search Context from cql context param " + searchContextJson, (Throwable)ex);
        }
    }
}

