/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.nutcluster.asyncinvalidation;

import com.atlassian.cache.nutcluster.asyncinvalidation.ClusterNode;
import com.atlassian.cache.nutcluster.asyncinvalidation.Topic;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.Message;
import com.atlassian.nutcluster.core.MessageListener;
import java.io.Serializable;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalMemberFilteringNutclusterTopic<M extends Serializable>
implements Topic<M> {
    private static final Logger log = LoggerFactory.getLogger(LocalMemberFilteringNutclusterTopic.class);
    private final ITopic<M> nutclusterTopic;
    private final ClusterNode localMember;

    public LocalMemberFilteringNutclusterTopic(ITopic<M> nutclusterTopic, ClusterNode localMember) {
        this.nutclusterTopic = nutclusterTopic;
        this.localMember = localMember;
    }

    @Override
    public Topic.Registration addListener(Topic.MessageConsumer<M> consumer) {
        MessageListener<M> messageListener = this.createMessageListener(this.localMember, consumer);
        String registrationId = this.nutclusterTopic.addMessageListener(messageListener);
        return () -> this.nutclusterTopic.removeMessageListener(registrationId);
    }

    private MessageListener<M> createMessageListener(ClusterNode localMember, BiConsumer<ClusterNode, M> consumer) {
        return new LocalMemberFilteringMessageListener(localMember, message -> {
            log.debug("Received message on topic '{}' from member {}: {}", new Object[]{this.nutclusterTopic.getName(), message.getPublishingMember(), message.getMessageObject()});
            consumer.accept(ClusterNode.from(message.getPublishingMember()), (Serializable)message.getMessageObject());
        });
    }

    @Override
    public void publish(M message) {
        log.debug("Sending message on topic '{}': {}", (Object)this.nutclusterTopic.getName(), message);
        this.nutclusterTopic.publish(message);
    }

    private static class LocalMemberFilteringMessageListener<T>
    implements MessageListener<T> {
        private final ClusterNode localMember;
        private final MessageListener<T> delegate;

        public LocalMemberFilteringMessageListener(ClusterNode localMember, MessageListener<T> delegate) {
            this.localMember = localMember;
            this.delegate = delegate;
        }

        public void onMessage(Message<T> message) {
            if (ClusterNode.from(message.getPublishingMember()).equals(this.localMember)) {
                log.debug("Ignoring message on topic from self {}", (Object)this.localMember);
            } else {
                this.delegate.onMessage(message);
            }
        }
    }
}

