/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.nutcluster.asyncinvalidation;

import com.atlassian.cache.Cache;
import com.atlassian.cache.nutcluster.asyncinvalidation.ClusterNode;
import com.atlassian.cache.nutcluster.asyncinvalidation.LocalMemberFilteringNutclusterTopic;
import com.atlassian.cache.nutcluster.asyncinvalidation.SequenceSnapshot;
import com.atlassian.cache.nutcluster.asyncinvalidation.Topic;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.NutclusterInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

final class Topics
implements AutoCloseable {
    private final TopicLookup topicLookup;
    private final Collection<Topic.Registration> topicRegistrations = new ArrayList<Topic.Registration>();

    static Topics from(NutclusterInstance nutcluster, Function<String, String> topicNamePrefixer) {
        return new Topics(TopicLookup.fromNutcluster(nutcluster, topicNamePrefixer));
    }

    private Topics(TopicLookup topicLookup) {
        this.topicLookup = topicLookup;
    }

    <K extends Serializable> Topic<SequenceSnapshot<K>> sequenceSnapshot() {
        return this.topicLookup.findTopic("SequenceSnapshot");
    }

    <T extends Serializable> Topic<T> cacheInvalidation(Cache<?, ?> cache) {
        return this.topicLookup.findTopic("Invalidation." + cache.getName());
    }

    <T extends Serializable> Topic<T> cacheReplication(Cache<?, ?> cache) {
        return this.topicLookup.findTopic("Replication." + cache.getName());
    }

    public void addRegistration(Topic.Registration registration) {
        this.topicRegistrations.add(registration);
    }

    @Override
    public void close() {
        this.topicRegistrations.forEach(Topic.Registration::close);
    }

    @FunctionalInterface
    private static interface TopicLookup {
        public <T extends Serializable> Topic<T> findTopic(String var1);

        public static TopicLookup fromNutcluster(final NutclusterInstance nutcluster, final Function<String, String> topicNamePrefixer) {
            final ClusterNode localMember = ClusterNode.from(nutcluster.getCluster().getLocalMember());
            return new TopicLookup(){

                @Override
                public <T extends Serializable> Topic<T> findTopic(String name) {
                    ITopic nutclusterTopic = nutcluster.getTopic((String)topicNamePrefixer.apply(name));
                    return new LocalMemberFilteringNutclusterTopic(nutclusterTopic, localMember);
                }
            };
        }
    }
}

