/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.analytics.collector;

import com.atlassian.crowd.common.analytics.statistics.collectors.StatisticsCollector;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.event.analytics.PasswordPolicyConfigurationAnalyticsEventBase;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PasswordPolicyStatisticsCollector
implements StatisticsCollector<PasswordPolicyConfigurationAnalyticsEventBase> {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordPolicyStatisticsCollector.class);
    private static final EntityQuery<Directory> ACTIVE_INTERNAL_DIRECTORIES_QUERY = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL), Restriction.on((Property)DirectoryTermKeys.ACTIVE).exactlyMatching((Object)true)})).returningAtMost(-1);
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;

    protected PasswordPolicyStatisticsCollector(CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
    }

    protected abstract PasswordPolicyConfigurationAnalyticsEventBase produceEvent(Directory var1, @Nullable PasswordPolicyConfiguration var2);

    public Iterable<PasswordPolicyConfigurationAnalyticsEventBase> collect() {
        return this.getActiveInternalDirectories().stream().map(directory -> this.produceEvent((Directory)directory, this.getPasswordPolicyConfiguration(directory.getId()))).collect(Collectors.toList());
    }

    private PasswordPolicyConfiguration getPasswordPolicyConfiguration(long dirId) {
        try {
            return this.crowdDirectoryService.getPasswordPolicyConfiguration(dirId);
        }
        catch (DirectoryNotFoundException | OperationNotSupportedException ex) {
            LOG.debug("Could not load PasswordPolicyConfiguration for Directory[id={}]", (Object)dirId, (Object)ex);
            return null;
        }
    }

    private List<Directory> getActiveInternalDirectories() {
        return this.directoryManager.searchDirectories(ACTIVE_INTERNAL_DIRECTORIES_QUERY);
    }
}

