/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class BooleanFuse
implements BooleanSupplier,
Supplier<Boolean> {
    private final Supplier<Boolean> realStateSupplier;
    private final boolean trippedState;
    private volatile boolean state;

    public BooleanFuse(boolean initialState, Supplier<Boolean> realStateSupplier) {
        this.state = initialState;
        this.trippedState = !initialState;
        this.realStateSupplier = realStateSupplier;
    }

    public BooleanFuse(boolean initialState, BooleanSupplier realStateSupplier) {
        this(initialState, realStateSupplier::getAsBoolean);
    }

    @Override
    public boolean getAsBoolean() {
        if (this.state == this.trippedState) {
            return this.state;
        }
        this.refreshState();
        return this.state;
    }

    @Override
    public Boolean get() {
        return this.getAsBoolean();
    }

    private synchronized void refreshState() {
        if (this.state == this.trippedState) {
            return;
        }
        this.state = this.realStateSupplier.get();
    }
}

