/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.awt.Color;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ColourUtils {
    public static final Pattern TEXT_COLOR_RGB_PATTERN = Pattern.compile("(?<textColor>(?<!-)color: rgb\\((?<red>\\d{1,3}), ?(?<green>\\d{1,3}), ?(?<blue>\\d{1,3})\\);)");
    public static final Pattern VALID_RGB_COLOR_PATTERN = Pattern.compile("^rgb\\(\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])\\s*\\)$", 2);
    public static final Pattern VALID_RGBA_COLOR_PATTERN = Pattern.compile("^rgba\\(\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])\\s*,\\s*((0.[0-9]*)|[01])\\s*\\)$", 2);
    public static final Pattern VALID_HEX_COLOR_PATTERN = Pattern.compile("(^#([a-f\\d]{3}|[a-f\\d]{4}|[a-f\\d]{6}|[a-f\\d]{8})$)", 2);
    public static final Pattern VALID_HSL_COLOR_PATTERN = Pattern.compile("^hsl\\(\\s*(0|[1-9]\\d?|[12]\\d\\d|3[0-5]\\d)\\s*,\\s*((0|[1-9]\\d?|100)%)\\s*,\\s*((0|[1-9]\\d?|100)%)\\s*\\)$", 2);
    public static final Pattern VALID_HSLA_COLOR_PATTERN = Pattern.compile("^hsla\\(\\s*(0|[1-9]\\d?|[12]\\d\\d|3[0-5]\\d)\\s*,\\s*((0|[1-9]\\d?|100)%)\\s*,\\s*((0|[1-9]\\d?|100)%)\\s*,\\s*((0.[0-9]*)|[01])\\s*\\)$", 2);
    public static final Pattern VALID_COLOR_NAME_PATTERN = Pattern.compile("^aqua|black|blue|fuchsia|gray|grey|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|transparent|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen$", 2);
    public static final Pattern TEXT_COLOR_DESIGN_TOKEN_PATTERN = Pattern.compile("color\\s*:\\s*(?<color>(?<!-)var\\s*\\(\\s*--ds-[\\w-]+\\s*,\\s*(?<fallback>#[a-fA-F\\d]{6})\\s*\\))\\s*;?");
    public static final Double EPSILON = 1.0E-5;

    public static String colorToHex(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public static Color hexToColor(String hexColor) {
        return Color.decode(hexColor.trim());
    }

    public static String darken(String hexColor, double amount) {
        Color color = ColourUtils.hexToColor(hexColor);
        return ColourUtils.colorToHex(ColourUtils.darken(color, amount));
    }

    public static String lighten(String hexColor, double amount) {
        Color color = ColourUtils.hexToColor(hexColor);
        return ColourUtils.colorToHex(ColourUtils.lighten(color, amount));
    }

    public static String saturate(String hexColor, double amount) {
        Color color = ColourUtils.hexToColor(hexColor);
        return ColourUtils.colorToHex(ColourUtils.saturate(color, amount));
    }

    public static String desaturate(String hexColor, double amount) {
        Color color = ColourUtils.hexToColor(hexColor);
        return ColourUtils.colorToHex(ColourUtils.desaturate(color, amount));
    }

    public static Color darken(Color color, double amount) {
        float[] hsl = ColourUtils.toHSL(color);
        hsl[2] = (float)((double)hsl[2] - amount / 100.0);
        hsl[2] = ColourUtils.clamp(hsl[2]);
        int[] rgb = ColourUtils.hslToRgb(hsl);
        return new Color(rgb[0], rgb[1], rgb[2], color.getAlpha());
    }

    public static Color lighten(Color color, double amount) {
        float[] hsl = ColourUtils.toHSL(color);
        hsl[2] = (float)((double)hsl[2] + amount / 100.0);
        hsl[2] = ColourUtils.clamp(hsl[2]);
        int[] rgb = ColourUtils.hslToRgb(hsl);
        return new Color(rgb[0], rgb[1], rgb[2], color.getAlpha());
    }

    public static Color desaturate(Color color, double amount) {
        float[] hsl = ColourUtils.toHSL(color);
        hsl[1] = (float)((double)hsl[1] - amount / 100.0);
        hsl[1] = ColourUtils.clamp(hsl[1]);
        int[] rgb = ColourUtils.hslToRgb(hsl);
        return new Color(rgb[0], rgb[1], rgb[2], color.getAlpha());
    }

    public static Color saturate(Color color, double amount) {
        float[] hsl = ColourUtils.toHSL(color);
        hsl[1] = (float)((double)hsl[1] + amount / 100.0);
        hsl[1] = ColourUtils.clamp(hsl[1]);
        int[] rgb = ColourUtils.hslToRgb(hsl);
        return new Color(rgb[0], rgb[1], rgb[2], color.getAlpha());
    }

    public static float[] toHSL(Color color) {
        float[] rgba = color.getRGBComponents(null);
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        float max = NumberUtils.max((float)r, (float)g, (float)b);
        float min = NumberUtils.min((float)r, (float)g, (float)b);
        float chroma = max - min;
        float hPrime = 0.0f;
        if (ColourUtils.isAlmostEqual(chroma, 0.0f).booleanValue()) {
            hPrime = 0.0f;
        } else if (ColourUtils.isAlmostEqual(max, r).booleanValue()) {
            hPrime = (g - b) / chroma;
            if (hPrime < 0.0f) {
                hPrime += 6.0f;
            }
        } else if (ColourUtils.isAlmostEqual(max, g).booleanValue()) {
            hPrime = (b - r) / chroma + 2.0f;
        } else if (ColourUtils.isAlmostEqual(max, b).booleanValue()) {
            hPrime = (r - g) / chroma + 4.0f;
        }
        float h = 60.0f * hPrime;
        float l = (max + min) * 0.5f;
        float s = ColourUtils.isAlmostEqual(chroma, 0.0f) != false ? 0.0f : chroma / (1.0f - Math.abs(2.0f * l - 1.0f));
        return new float[]{h, s, l, a};
    }

    public static int[] hslToRgb(float[] hsl) {
        float b1;
        float g1;
        float r1;
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        float a = hsl[3];
        float chroma = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float hPrime = h / 60.0f;
        float hMod2 = hPrime;
        if (hMod2 >= 4.0f) {
            hMod2 -= 4.0f;
        } else if (hMod2 >= 2.0f) {
            hMod2 -= 2.0f;
        }
        float x = chroma * (1.0f - Math.abs(hMod2 - 1.0f));
        if (hPrime < 1.0f) {
            r1 = chroma;
            g1 = x;
            b1 = 0.0f;
        } else if (hPrime < 2.0f) {
            r1 = x;
            g1 = chroma;
            b1 = 0.0f;
        } else if (hPrime < 3.0f) {
            r1 = 0.0f;
            g1 = chroma;
            b1 = x;
        } else if (hPrime < 4.0f) {
            r1 = 0.0f;
            g1 = x;
            b1 = chroma;
        } else if (hPrime < 5.0f) {
            r1 = x;
            g1 = 0.0f;
            b1 = chroma;
        } else {
            r1 = chroma;
            g1 = 0.0f;
            b1 = x;
        }
        float m = l - 0.5f * chroma;
        int r = (int)((r1 + m) * 255.0f + 0.5f);
        int g = (int)((g1 + m) * 255.0f + 0.5f);
        int b = (int)((b1 + m) * 255.0f + 0.5f);
        return new int[]{r, g, b};
    }

    private static float clamp(float f) {
        return Math.min(1.0f, Math.max(0.0f, f));
    }

    private static Boolean isAlmostEqual(float a, float b) {
        return (double)Math.abs(a - b) < EPSILON;
    }

    public static String getColorWithInvertedLightness(String hexColor) {
        Color color = Color.decode(hexColor);
        float[] hsla = ColourUtils.toHSL(color);
        float lightness = hsla[2];
        hsla[2] = Math.abs(1.0f - lightness);
        int[] rgb = ColourUtils.hslToRgb(hsla);
        Color newColor = new Color(rgb[0], rgb[1], rgb[2], color.getAlpha());
        return ColourUtils.colorToHex(newColor);
    }

    public static String findClosetColor(String hexColor, Set<String> colorList) {
        Color styleColor = Color.decode(hexColor);
        Iterator<String> iterator = colorList.iterator();
        String closestColor = iterator.next();
        float minDistance = ColourUtils.getColorDistance(styleColor, Color.decode(closestColor));
        while (iterator.hasNext()) {
            String currentColor = iterator.next();
            Color decodedColor = Color.decode(currentColor);
            float currentDistance = ColourUtils.getColorDistance(styleColor, decodedColor);
            if (!(currentDistance < minDistance)) continue;
            minDistance = currentDistance;
            closestColor = currentColor;
        }
        return closestColor;
    }

    public static String getFallbackColorForDesignTokenColor(String styleValue) {
        Matcher matcher;
        if (StringUtils.isNotEmpty((CharSequence)styleValue) && (matcher = TEXT_COLOR_DESIGN_TOKEN_PATTERN.matcher(styleValue)).find()) {
            String colorStyle = matcher.group("color");
            return styleValue.replace(colorStyle, matcher.group("fallback"));
        }
        return null;
    }

    private static float getColorDistance(Color c1, Color c2) {
        return (float)(c1.getRed() - c2.getRed()) * (float)(c1.getRed() - c2.getRed()) + (float)((c1.getGreen() - c2.getGreen()) * (c1.getGreen() - c2.getGreen())) + (float)((c1.getBlue() - c2.getBlue()) * (c1.getBlue() - c2.getBlue()));
    }

    public static boolean isValidColor(String color) {
        if (color == null) {
            return false;
        }
        color = color.trim();
        Matcher hexMatcher = VALID_HEX_COLOR_PATTERN.matcher(color);
        Matcher rgbMatcher = VALID_RGB_COLOR_PATTERN.matcher(color);
        Matcher rgbaMatcher = VALID_RGBA_COLOR_PATTERN.matcher(color);
        Matcher nameMatcher = VALID_COLOR_NAME_PATTERN.matcher(color);
        Matcher hslMatcher = VALID_HSL_COLOR_PATTERN.matcher(color);
        Matcher hslaMatcher = VALID_HSLA_COLOR_PATTERN.matcher(color);
        return hexMatcher.matches() || rgbMatcher.matches() || rgbaMatcher.matches() || nameMatcher.matches() || hslMatcher.matches() || hslaMatcher.matches();
    }
}

