/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.collections;

import com.atlassian.confluence.util.collections.MapBackedEntrySet;
import com.google.common.base.Supplier;
import io.atlassian.util.concurrent.LazyReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class LazyMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, LazyReference<? extends V>> refMap;
    private final Set<Map.Entry<K, V>> entrySetView;

    public LazyMap() {
        this(new HashMap());
    }

    private LazyMap(Map<K, LazyReference<? extends V>> refMap) {
        this.refMap = refMap;
        this.entrySetView = new MapBackedEntrySet(this);
    }

    @Deprecated(forRemoval=true)
    public static <K, V> LazyMap<K, V> newInstance(Map<K, ? extends Supplier<? extends V>> supplierMap) {
        return LazyMap.fromSuppliersMap(supplierMap);
    }

    public static <K, V> LazyMap<K, V> fromSuppliersMap(Map<K, ? extends java.util.function.Supplier<? extends V>> supplierMap) {
        HashMap refMap = new HashMap();
        supplierMap.forEach((k, v) -> refMap.put(k, LazyMap.toLazyReference(v)));
        return new LazyMap(refMap);
    }

    public static <K, V> LazyMap<K, V> copyOf(LazyMap<K, V> map) {
        return new LazyMap<K, V>(new HashMap<K, LazyReference<? extends V>>(map.refMap));
    }

    private static <T> LazyReference<T> toLazyReference(final java.util.function.Supplier<T> supplier) {
        if (supplier instanceof LazyReference) {
            LazyReference lazyReference = (LazyReference)supplier;
            return lazyReference;
        }
        return new LazyReference<T>(){

            protected T create() {
                return supplier.get();
            }
        };
    }

    @Override
    public V get(Object key) {
        LazyReference<? extends V> ref = this.refMap.get(key);
        return (V)(ref != null ? ref.get() : null);
    }

    public void lazyPut(K key, java.util.function.Supplier<? extends V> value) {
        this.refMap.put(key, LazyMap.toLazyReference(value));
    }

    @Override
    public V put(K key, V value) {
        V prev = this.get(key);
        this.lazyPut(key, () -> value);
        return prev;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m instanceof LazyMap) {
            LazyMap other = (LazyMap)m;
            this.putAll(other);
            return;
        }
        m.entrySet().forEach((? super T e) -> this.lazyPut(e.getKey(), e::getValue));
    }

    @Override
    public void putAll(LazyMap<? extends K, ? extends V> other) {
        this.refMap.putAll(other.refMap);
    }

    public void putAllIfAbsent(LazyMap<K, V> other) {
        for (Map.Entry<K, LazyReference<V>> entry : other.refMap.entrySet()) {
            if (this.refMap.containsKey(entry.getKey())) continue;
            this.refMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return this.refMap.keySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetView;
    }

    @Override
    public int size() {
        return this.refMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.refMap.isEmpty();
    }

    @Override
    public V remove(Object key) {
        LazyReference<? extends V> removedSupplier = this.refMap.remove(key);
        return (V)(removedSupplier != null ? removedSupplier.get() : null);
    }
}

