/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client;

import com.atlassian.mywork.client.service.ServiceSelectorImpl;
import com.atlassian.mywork.service.NotificationService;
import com.atlassian.mywork.service.RegistrationService;
import com.atlassian.mywork.service.TaskService;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class MyworkDelegatorServices {
    @Autowired
    ServiceSelectorImpl serviceSelector;

    MyworkDelegatorServices() {
    }

    @Bean
    TaskService delegatingTaskService(@Qualifier(value="localTaskService") TaskService localService, @Qualifier(value="task-service") TaskService remoteService) throws Exception {
        return this.createServiceProxy(TaskService.class, localService, remoteService);
    }

    @Bean
    NotificationService delegatingNotificationService(@Qualifier(value="localNotificationService") NotificationService localService, @Qualifier(value="notification-service") NotificationService remoteService) throws Exception {
        return this.createServiceProxy(NotificationService.class, localService, remoteService);
    }

    @Bean
    RegistrationService delegatingRegistrationService(@Qualifier(value="localRegistrationService") RegistrationService localService, @Qualifier(value="registration-service") RegistrationService remoteService) throws Exception {
        return this.createServiceProxy(RegistrationService.class, localService, remoteService);
    }

    <T> T createServiceProxy(Class<T> serviceClass, T localService, T remoteService) throws ClassNotFoundException {
        return (T)this.serviceSelector.createInstance(serviceClass.getName(), localService, remoteService);
    }

    @Bean
    FactoryBean<ServiceRegistration> delegatingTaskService_export(@Qualifier(value="delegatingTaskService") TaskService service) {
        return OsgiServices.exportOsgiService(service, ExportOptions.as(TaskService.class, new Class[0]).withProperty("type", "delegator"));
    }

    @Bean
    FactoryBean<ServiceRegistration> delegatingNotificationService_export(@Qualifier(value="delegatingNotificationService") NotificationService service) {
        return OsgiServices.exportOsgiService(service, ExportOptions.as(NotificationService.class, new Class[0]).withProperty("type", "delegator"));
    }

    @Bean
    FactoryBean<ServiceRegistration> delegatingRegistrationService_export(@Qualifier(value="delegatingRegistrationService") RegistrationService service) {
        return OsgiServices.exportOsgiService(service, ExportOptions.as(RegistrationService.class, new Class[0]).withProperty("type", "delegator"));
    }
}

