/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.mywork.client.service.ServingRequestsAware;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

@UnrestrictedAccess
public class ServingRequestsFilter
implements Filter {
    private final AtomicBoolean servingRequests = new AtomicBoolean(false);
    private final ServingRequestsAware servingRequestsAware;

    public ServingRequestsFilter(ServingRequestsAware servingRequestsAware) {
        this.servingRequestsAware = servingRequestsAware;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.servingRequests.compareAndSet(false, true)) {
            this.servingRequestsAware.onServingRequests();
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

