/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.listener;

import com.atlassian.mywork.client.listener.ServiceListener;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.base.Function;
import java.io.Closeable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PluginModuleServiceListener
implements ServiceListener,
LifecycleAware {
    private final PluginEventManager pluginEventManager;
    private final PluginAccessor pluginAccessor;
    private final Set<Function<Plugin, Void>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public PluginModuleServiceListener(PluginEventManager pluginEventManager, PluginAccessor pluginAccessor) {
        this.pluginEventManager = pluginEventManager;
        this.pluginAccessor = pluginAccessor;
    }

    public synchronized <M> Closeable addListener(Class<M> type, Function<M, Void> callback) {
        Function wrappedCallback = plugin -> {
            for (ModuleDescriptor descriptor : plugin.getModuleDescriptorsByModuleClass(type)) {
                callback.apply(descriptor.getModule());
            }
            return null;
        };
        this.listeners.add((Function<Plugin, Void>)wrappedCallback);
        for (Object module : this.pluginAccessor.getEnabledModulesByClass(type)) {
            callback.apply(module);
        }
        return () -> {
            PluginModuleServiceListener pluginModuleServiceListener = this;
            synchronized (pluginModuleServiceListener) {
                this.listeners.remove(wrappedCallback);
            }
        };
    }

    @PluginEventListener
    public void pluginEnabledEvent(PluginEnabledEvent event) {
        for (Function<Plugin, Void> listener : this.listeners) {
            listener.apply((Object)event.getPlugin());
        }
    }

    public void onStart() {
        this.pluginEventManager.register((Object)this);
    }

    public void onStop() {
        this.pluginEventManager.unregister((Object)this);
    }
}

