/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.reliability;

import com.atlassian.mywork.client.reliability.ReliabilityService;
import com.atlassian.mywork.client.reliability.UnreliableTask;
import com.atlassian.mywork.client.reliability.UnreliableTaskListener;
import com.atlassian.mywork.client.reliability.UnreliableWorker;
import com.atlassian.mywork.client.schedule.Scheduler;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atlassian.util.concurrent.SettableFuture;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReliabilityService
implements ReliabilityService {
    private static final Logger log = LoggerFactory.getLogger(DefaultReliabilityService.class);
    private static final int MAX_QUEUE_SIZE = 10000;
    private final LoadingCache<String, PriorityBlockingQueue<TimestampedTask>> queues = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, PriorityBlockingQueue<TimestampedTask>>(){

        public PriorityBlockingQueue<TimestampedTask> load(String key) {
            PriorityBlockingQueue<TimestampedTask> queue = new PriorityBlockingQueue<TimestampedTask>();
            DefaultReliabilityService.this.schedule(queue);
            return queue;
        }
    });
    private volatile boolean queueFull = false;
    private final Scheduler scheduler;
    private final UnreliableWorker worker;

    public DefaultReliabilityService(Scheduler scheduler, UnreliableWorker worker) {
        this.scheduler = scheduler;
        this.worker = worker;
    }

    @Override
    public Future<String> submit(UnreliableTask task) {
        TimestampedTask wrapper = new TimestampedTask(task);
        PriorityBlockingQueue queue = (PriorityBlockingQueue)this.queues.getUnchecked((Object)task.appLinkId);
        if (queue.size() > 10000) {
            if (!this.queueFull) {
                log.warn("Queue has exceeded the maximum size. Tasks cannot be delivered");
            }
            wrapper.future.cancel(false);
            this.queueFull = true;
        } else {
            queue.add(wrapper);
            this.queueFull = false;
        }
        return wrapper.future;
    }

    private void schedule(final PriorityBlockingQueue<TimestampedTask> queue) {
        this.scheduler.schedule((Scheduler.ScheduleCallback callback) -> {
            TimestampedTask wrapper;
            try {
                wrapper = (TimestampedTask)queue.take();
            }
            catch (InterruptedException e) {
                callback.failed();
                return;
            }
            final UnreliableTask task = wrapper.task;
            this.worker.start(task, new UnreliableTaskListener(){

                @Override
                public void succeeded(String result) {
                    log.debug("Succeeded task \"{}\"", (Object)task.getTaskData());
                    wrapper.future.set((Object)result);
                    callback.pass();
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("Failed task \"{}\"", (Object)task.getTaskData(), (Object)throwable);
                    if (queue.size() <= 10000) {
                        queue.add(wrapper);
                    }
                    callback.failed();
                }

                @Override
                public void cancel() {
                    wrapper.future.cancel(false);
                    callback.pass();
                }
            });
        });
    }

    private static class TimestampedTask
    implements Comparable<TimestampedTask> {
        private final SettableFuture<String> future = new SettableFuture();
        private final long timestamp = new Date().getTime();
        private final UnreliableTask task;

        public TimestampedTask(UnreliableTask task) {
            this.task = task;
        }

        @Override
        public int compareTo(TimestampedTask o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public boolean equals(Object o) {
            if (!(o instanceof TimestampedTask)) {
                return false;
            }
            TimestampedTask ttask = (TimestampedTask)o;
            return this.timestamp == ttask.timestamp;
        }

        public int hashCode() {
            return Long.valueOf(this.timestamp).hashCode();
        }
    }
}

