/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.mywork.service.ActionServiceSelector;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="action")
@Produces(value={"application/json"})
public class ActionResource {
    private final UserManager userManager;
    private final ActionServiceSelector actionService;

    @Inject
    public ActionResource(UserManager userManager, ActionServiceSelector actionService) {
        this.userManager = userManager;
        this.actionService = actionService;
    }

    @POST
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response execute(JsonNode action) {
        String username = this.userManager.getRemoteUsername();
        return Response.ok((Object)this.actionService.get(action.get("application").textValue()).execute(username, action)).build();
    }
}

