/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.mywork.client.ClientUtil;
import com.atlassian.mywork.rest.MyWorkCacheControl;
import com.atlassian.mywork.service.HostService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="host")
@Produces(value={"application/json"})
public class HostResource {
    private static final Logger log = LoggerFactory.getLogger(HostResource.class);
    private final HostService hostService;
    private final HostApplication hostApplication;

    @Inject
    public HostResource(HostService hostService, @Named(value="hostApplication") HostApplication hostApplication) {
        this.hostService = hostService;
        this.hostApplication = hostApplication;
    }

    @POST
    @Path(value="verifyAuth")
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Boolean verifyAuth() {
        Iterator iterator = this.hostService.getActiveHost().iterator();
        if (iterator.hasNext()) {
            ApplicationLink appLink = (ApplicationLink)iterator.next();
            return !ClientUtil.credentialsRequired(appLink, this.hostApplication.getId());
        }
        log.warn("User authorisation failed: Could not find an available host");
        return false;
    }

    @GET
    @Path(value="appid")
    @Produces(value={"text/plain"})
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ"})
    public Response getAppId() {
        Option<ApplicationLink> hosts = this.hostService.getActiveHost();
        String appId = !Iterables.isEmpty(hosts) ? ((ApplicationLink)Iterables.getOnlyElement(hosts)).getId().get() : null;
        return Response.ok(appId).cacheControl(MyWorkCacheControl.never()).build();
    }
}

