/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.mywork.service.ClientRegistrationService;
import com.atlassian.mywork.service.HostService;
import com.atlassian.mywork.service.ServiceSelector;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.atlassian.fugue.Option;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="registration")
@Produces(value={"application/json"})
public class RegistrationResource {
    private static final Logger log = LoggerFactory.getLogger(RegistrationResource.class);
    private final ServiceSelector serviceSelector;
    private final ClientRegistrationService clientRegistrationService;
    private final HostService hostService;

    @Inject
    public RegistrationResource(ServiceSelector serviceSelector, ClientRegistrationService clientRegistrationService, HostService hostService) {
        this.serviceSelector = serviceSelector;
        this.clientRegistrationService = clientRegistrationService;
        this.hostService = hostService;
    }

    @GET
    @UnrestrictedAccess
    @ScopesAllowed(requiredScope={"READ"})
    public Response getRegistration(@QueryParam(value="appid") String appid) {
        log.debug("Retrieving registration for appID [{}]", (Object)appid);
        ServiceSelector.Target target = this.serviceSelector.getTarget();
        if (target == ServiceSelector.Target.REMOTE || target == ServiceSelector.Target.AUTO) {
            Option<ApplicationLink> activeHost = this.hostService.getActiveHost();
            if (activeHost.isDefined()) {
                if (((ApplicationLink)activeHost.get()).getId().get().equals(appid)) {
                    return Response.ok(this.clientRegistrationService.createRegistrations()).build();
                }
                log.debug("Active host [{}] doesn't match requested appid [{}]", activeHost.get(), (Object)appid);
            } else {
                log.debug("No active host defined by host service; cannot locate registration for appid [{}]", (Object)appid);
            }
        } else {
            log.debug("Request for registration for appid [{}] not acting as a client; target is [{}]", (Object)appid, (Object)target);
        }
        log.debug("Returning registration-not-found for appid [{}]", (Object)appid);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

