/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.service;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Lazy;
import jakarta.annotation.Nullable;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class HostIdCache {
    private static final Logger log = LoggerFactory.getLogger(HostIdCache.class);
    private final Supplier<Cache<String, Option<String>>> cacheRef;

    public HostIdCache(CacheFactory cacheFactory, String cacheName) {
        this(Lazy.supplier(() -> HostIdCache.createCache(cacheFactory, cacheName)));
    }

    @VisibleForTesting
    HostIdCache(Supplier<Cache<String, Option<String>>> cacheRef) {
        this.cacheRef = cacheRef;
    }

    private static Cache<String, Option<String>> createCache(CacheFactory cacheFactory, String cacheName) {
        return cacheFactory.getCache(cacheName, null, new CacheSettingsBuilder().remote().build());
    }

    public void setHost(String hostKey, Option<ApplicationId> host) {
        Option appId = host.map(ApplicationId::get);
        log.debug("Setting cached {} to {}", (Object)hostKey, (Object)appId);
        this.cacheRef.get().put((Object)hostKey, (Object)appId);
    }

    @Nullable
    public Option<ApplicationId> getHost(String hostKey) {
        try {
            Option cachedValue = (Option)this.cacheRef.get().get((Object)hostKey);
            if (cachedValue != null) {
                return cachedValue.map(ApplicationId::new);
            }
            return null;
        }
        catch (RuntimeException ex) {
            log.warn("Failed to retrieve host from cache", (Throwable)ex);
            return null;
        }
    }

    public void clear() {
        try {
            this.cacheRef.get().removeAll();
        }
        catch (RuntimeException ex) {
            log.error("Failed to clear cache", (Throwable)ex);
            throw ex;
        }
    }
}

